/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.AutonomousDatabase;
import java.beans.ConstructorProperties;

public class StartAutonomousDatabaseResponse {
    private String etag;
    private String opcRequestId;
    private AutonomousDatabase autonomousDatabase;

    @ConstructorProperties(value={"etag", "opcRequestId", "autonomousDatabase"})
    StartAutonomousDatabaseResponse(String etag, String opcRequestId, AutonomousDatabase autonomousDatabase) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.autonomousDatabase = autonomousDatabase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutonomousDatabase getAutonomousDatabase() {
        return this.autonomousDatabase;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private AutonomousDatabase autonomousDatabase;

        public Builder copy(StartAutonomousDatabaseResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.autonomousDatabase(o.getAutonomousDatabase());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder autonomousDatabase(AutonomousDatabase autonomousDatabase) {
            this.autonomousDatabase = autonomousDatabase;
            return this;
        }

        public StartAutonomousDatabaseResponse build() {
            return new StartAutonomousDatabaseResponse(this.etag, this.opcRequestId, this.autonomousDatabase);
        }

        public String toString() {
            return "StartAutonomousDatabaseResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", autonomousDatabase=" + this.autonomousDatabase + ")";
        }
    }
}

