/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.DataGuardAssociation;
import java.beans.ConstructorProperties;

public class SwitchoverDataGuardAssociationResponse {
    private String etag;
    private String opcRequestId;
    private DataGuardAssociation dataGuardAssociation;

    @ConstructorProperties(value={"etag", "opcRequestId", "dataGuardAssociation"})
    SwitchoverDataGuardAssociationResponse(String etag, String opcRequestId, DataGuardAssociation dataGuardAssociation) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.dataGuardAssociation = dataGuardAssociation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DataGuardAssociation getDataGuardAssociation() {
        return this.dataGuardAssociation;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private DataGuardAssociation dataGuardAssociation;

        public Builder copy(SwitchoverDataGuardAssociationResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.dataGuardAssociation(o.getDataGuardAssociation());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dataGuardAssociation(DataGuardAssociation dataGuardAssociation) {
            this.dataGuardAssociation = dataGuardAssociation;
            return this;
        }

        public SwitchoverDataGuardAssociationResponse build() {
            return new SwitchoverDataGuardAssociationResponse(this.etag, this.opcRequestId, this.dataGuardAssociation);
        }

        public String toString() {
            return "SwitchoverDataGuardAssociationResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", dataGuardAssociation=" + this.dataGuardAssociation + ")";
        }
    }
}

