/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseConnectionStringProfile
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="consumerGroup")
    private final ConsumerGroup consumerGroup;
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="tlsAuthentication")
    private final TlsAuthentication tlsAuthentication;
    @JsonProperty(value="hostFormat")
    private final HostFormat hostFormat;
    @JsonProperty(value="sessionMode")
    private final SessionMode sessionMode;
    @JsonProperty(value="syntaxFormat")
    private final SyntaxFormat syntaxFormat;
    @JsonProperty(value="isRegional")
    private final Boolean isRegional;

    @Deprecated
    @ConstructorProperties(value={"displayName", "value", "consumerGroup", "protocol", "tlsAuthentication", "hostFormat", "sessionMode", "syntaxFormat", "isRegional"})
    public DatabaseConnectionStringProfile(String displayName, String value, ConsumerGroup consumerGroup, Protocol protocol, TlsAuthentication tlsAuthentication, HostFormat hostFormat, SessionMode sessionMode, SyntaxFormat syntaxFormat, Boolean isRegional) {
        this.displayName = displayName;
        this.value = value;
        this.consumerGroup = consumerGroup;
        this.protocol = protocol;
        this.tlsAuthentication = tlsAuthentication;
        this.hostFormat = hostFormat;
        this.sessionMode = sessionMode;
        this.syntaxFormat = syntaxFormat;
        this.isRegional = isRegional;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getValue() {
        return this.value;
    }

    public ConsumerGroup getConsumerGroup() {
        return this.consumerGroup;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public TlsAuthentication getTlsAuthentication() {
        return this.tlsAuthentication;
    }

    public HostFormat getHostFormat() {
        return this.hostFormat;
    }

    public SessionMode getSessionMode() {
        return this.sessionMode;
    }

    public SyntaxFormat getSyntaxFormat() {
        return this.syntaxFormat;
    }

    public Boolean getIsRegional() {
        return this.isRegional;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseConnectionStringProfile(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", consumerGroup=").append(String.valueOf((Object)this.consumerGroup));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", tlsAuthentication=").append(String.valueOf((Object)this.tlsAuthentication));
        sb.append(", hostFormat=").append(String.valueOf((Object)this.hostFormat));
        sb.append(", sessionMode=").append(String.valueOf((Object)this.sessionMode));
        sb.append(", syntaxFormat=").append(String.valueOf((Object)this.syntaxFormat));
        sb.append(", isRegional=").append(String.valueOf(this.isRegional));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseConnectionStringProfile)) {
            return false;
        }
        DatabaseConnectionStringProfile other = (DatabaseConnectionStringProfile)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.consumerGroup, (Object)other.consumerGroup) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals((Object)this.tlsAuthentication, (Object)other.tlsAuthentication) && Objects.equals((Object)this.hostFormat, (Object)other.hostFormat) && Objects.equals((Object)this.sessionMode, (Object)other.sessionMode) && Objects.equals((Object)this.syntaxFormat, (Object)other.syntaxFormat) && Objects.equals(this.isRegional, other.isRegional) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.consumerGroup == null ? 43 : this.consumerGroup.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.tlsAuthentication == null ? 43 : this.tlsAuthentication.hashCode());
        result = result * 59 + (this.hostFormat == null ? 43 : this.hostFormat.hashCode());
        result = result * 59 + (this.sessionMode == null ? 43 : this.sessionMode.hashCode());
        result = result * 59 + (this.syntaxFormat == null ? 43 : this.syntaxFormat.hashCode());
        result = result * 59 + (this.isRegional == null ? 43 : this.isRegional.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SyntaxFormat implements BmcEnum
    {
        Long("LONG"),
        Ezconnect("EZCONNECT"),
        Ezconnectplus("EZCONNECTPLUS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SyntaxFormat> map;

        private SyntaxFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SyntaxFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SyntaxFormat', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SyntaxFormat.class);
            map = new HashMap<String, SyntaxFormat>();
            for (SyntaxFormat v : SyntaxFormat.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SessionMode implements BmcEnum
    {
        Direct("DIRECT"),
        Redirect("REDIRECT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SessionMode> map;

        private SessionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SessionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SessionMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SessionMode.class);
            map = new HashMap<String, SessionMode>();
            for (SessionMode v : SessionMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum HostFormat implements BmcEnum
    {
        Fqdn("FQDN"),
        Ip("IP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HostFormat> map;

        private HostFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HostFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HostFormat', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HostFormat.class);
            map = new HashMap<String, HostFormat>();
            for (HostFormat v : HostFormat.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TlsAuthentication implements BmcEnum
    {
        Server("SERVER"),
        Mutual("MUTUAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TlsAuthentication> map;

        private TlsAuthentication(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TlsAuthentication create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TlsAuthentication', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TlsAuthentication.class);
            map = new HashMap<String, TlsAuthentication>();
            for (TlsAuthentication v : TlsAuthentication.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Protocol implements BmcEnum
    {
        Tcp("TCP"),
        Tcps("TCPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ConsumerGroup implements BmcEnum
    {
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW"),
        Tp("TP"),
        Tpurgent("TPURGENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConsumerGroup> map;

        private ConsumerGroup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConsumerGroup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConsumerGroup', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConsumerGroup.class);
            map = new HashMap<String, ConsumerGroup>();
            for (ConsumerGroup v : ConsumerGroup.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="consumerGroup")
        private ConsumerGroup consumerGroup;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="tlsAuthentication")
        private TlsAuthentication tlsAuthentication;
        @JsonProperty(value="hostFormat")
        private HostFormat hostFormat;
        @JsonProperty(value="sessionMode")
        private SessionMode sessionMode;
        @JsonProperty(value="syntaxFormat")
        private SyntaxFormat syntaxFormat;
        @JsonProperty(value="isRegional")
        private Boolean isRegional;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder consumerGroup(ConsumerGroup consumerGroup) {
            this.consumerGroup = consumerGroup;
            this.__explicitlySet__.add("consumerGroup");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder tlsAuthentication(TlsAuthentication tlsAuthentication) {
            this.tlsAuthentication = tlsAuthentication;
            this.__explicitlySet__.add("tlsAuthentication");
            return this;
        }

        public Builder hostFormat(HostFormat hostFormat) {
            this.hostFormat = hostFormat;
            this.__explicitlySet__.add("hostFormat");
            return this;
        }

        public Builder sessionMode(SessionMode sessionMode) {
            this.sessionMode = sessionMode;
            this.__explicitlySet__.add("sessionMode");
            return this;
        }

        public Builder syntaxFormat(SyntaxFormat syntaxFormat) {
            this.syntaxFormat = syntaxFormat;
            this.__explicitlySet__.add("syntaxFormat");
            return this;
        }

        public Builder isRegional(Boolean isRegional) {
            this.isRegional = isRegional;
            this.__explicitlySet__.add("isRegional");
            return this;
        }

        public DatabaseConnectionStringProfile build() {
            DatabaseConnectionStringProfile model = new DatabaseConnectionStringProfile(this.displayName, this.value, this.consumerGroup, this.protocol, this.tlsAuthentication, this.hostFormat, this.sessionMode, this.syntaxFormat, this.isRegional);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseConnectionStringProfile model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("consumerGroup")) {
                this.consumerGroup(model.getConsumerGroup());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("tlsAuthentication")) {
                this.tlsAuthentication(model.getTlsAuthentication());
            }
            if (model.wasPropertyExplicitlySet("hostFormat")) {
                this.hostFormat(model.getHostFormat());
            }
            if (model.wasPropertyExplicitlySet("sessionMode")) {
                this.sessionMode(model.getSessionMode());
            }
            if (model.wasPropertyExplicitlySet("syntaxFormat")) {
                this.syntaxFormat(model.getSyntaxFormat());
            }
            if (model.wasPropertyExplicitlySet("isRegional")) {
                this.isRegional(model.getIsRegional());
            }
            return this;
        }
    }
}

