/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DataCollectionOptions;
import com.oracle.bmc.database.model.DbSystemOptions;
import com.oracle.bmc.database.model.ExadataIormConfig;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="iormConfigCache")
    private final ExadataIormConfig iormConfigCache;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomains")
    private final List<String> faultDomains;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="backupSubnetId")
    private final String backupSubnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="backupNetworkNsgIds")
    private final List<String> backupNetworkNsgIds;
    @JsonProperty(value="giSoftwareImageId")
    private final String giSoftwareImageId;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="storageVolumePerformanceMode")
    private final StorageVolumePerformanceMode storageVolumePerformanceMode;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="dbSystemOptions")
    private final DbSystemOptions dbSystemOptions;
    @JsonProperty(value="sshPublicKeys")
    private final List<String> sshPublicKeys;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="osVersion")
    private final String osVersion;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="dataStoragePercentage")
    private final Integer dataStoragePercentage;
    @JsonProperty(value="databaseEdition")
    private final DatabaseEdition databaseEdition;
    @JsonProperty(value="lastPatchHistoryEntryId")
    private final String lastPatchHistoryEntryId;
    @JsonProperty(value="listenerPort")
    private final Integer listenerPort;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="diskRedundancy")
    private final DiskRedundancy diskRedundancy;
    @JsonProperty(value="sparseDiskgroup")
    private final Boolean sparseDiskgroup;
    @JsonProperty(value="scanIpIds")
    private final List<String> scanIpIds;
    @JsonProperty(value="vipIds")
    private final List<String> vipIds;
    @JsonProperty(value="scanDnsRecordId")
    private final String scanDnsRecordId;
    @JsonProperty(value="scanDnsName")
    private final String scanDnsName;
    @JsonProperty(value="zoneId")
    private final String zoneId;
    @JsonProperty(value="dataStorageSizeInGBs")
    private final Integer dataStorageSizeInGBs;
    @JsonProperty(value="recoStorageSizeInGB")
    private final Integer recoStorageSizeInGB;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="maintenanceWindow")
    private final MaintenanceWindow maintenanceWindow;
    @JsonProperty(value="lastMaintenanceRunId")
    private final String lastMaintenanceRunId;
    @JsonProperty(value="nextMaintenanceRunId")
    private final String nextMaintenanceRunId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="sourceDbSystemId")
    private final String sourceDbSystemId;
    @JsonProperty(value="pointInTimeDataDiskCloneTimestamp")
    private final Date pointInTimeDataDiskCloneTimestamp;
    @JsonProperty(value="dataCollectionOptions")
    private final DataCollectionOptions dataCollectionOptions;

    @Deprecated
    @ConstructorProperties(value={"iormConfigCache", "id", "compartmentId", "displayName", "availabilityDomain", "faultDomains", "subnetId", "backupSubnetId", "nsgIds", "backupNetworkNsgIds", "giSoftwareImageId", "memorySizeInGBs", "storageVolumePerformanceMode", "shape", "dbSystemOptions", "sshPublicKeys", "timeZone", "hostname", "domain", "kmsKeyId", "version", "osVersion", "cpuCoreCount", "clusterName", "dataStoragePercentage", "databaseEdition", "lastPatchHistoryEntryId", "listenerPort", "lifecycleState", "timeCreated", "lifecycleDetails", "diskRedundancy", "sparseDiskgroup", "scanIpIds", "vipIds", "scanDnsRecordId", "scanDnsName", "zoneId", "dataStorageSizeInGBs", "recoStorageSizeInGB", "nodeCount", "licenseModel", "maintenanceWindow", "lastMaintenanceRunId", "nextMaintenanceRunId", "freeformTags", "definedTags", "sourceDbSystemId", "pointInTimeDataDiskCloneTimestamp", "dataCollectionOptions"})
    public DbSystem(ExadataIormConfig iormConfigCache, String id, String compartmentId, String displayName, String availabilityDomain, List<String> faultDomains, String subnetId, String backupSubnetId, List<String> nsgIds, List<String> backupNetworkNsgIds, String giSoftwareImageId, Integer memorySizeInGBs, StorageVolumePerformanceMode storageVolumePerformanceMode, String shape, DbSystemOptions dbSystemOptions, List<String> sshPublicKeys, String timeZone, String hostname, String domain, String kmsKeyId, String version, String osVersion, Integer cpuCoreCount, String clusterName, Integer dataStoragePercentage, DatabaseEdition databaseEdition, String lastPatchHistoryEntryId, Integer listenerPort, LifecycleState lifecycleState, Date timeCreated, String lifecycleDetails, DiskRedundancy diskRedundancy, Boolean sparseDiskgroup, List<String> scanIpIds, List<String> vipIds, String scanDnsRecordId, String scanDnsName, String zoneId, Integer dataStorageSizeInGBs, Integer recoStorageSizeInGB, Integer nodeCount, LicenseModel licenseModel, MaintenanceWindow maintenanceWindow, String lastMaintenanceRunId, String nextMaintenanceRunId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String sourceDbSystemId, Date pointInTimeDataDiskCloneTimestamp, DataCollectionOptions dataCollectionOptions) {
        this.iormConfigCache = iormConfigCache;
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.availabilityDomain = availabilityDomain;
        this.faultDomains = faultDomains;
        this.subnetId = subnetId;
        this.backupSubnetId = backupSubnetId;
        this.nsgIds = nsgIds;
        this.backupNetworkNsgIds = backupNetworkNsgIds;
        this.giSoftwareImageId = giSoftwareImageId;
        this.memorySizeInGBs = memorySizeInGBs;
        this.storageVolumePerformanceMode = storageVolumePerformanceMode;
        this.shape = shape;
        this.dbSystemOptions = dbSystemOptions;
        this.sshPublicKeys = sshPublicKeys;
        this.timeZone = timeZone;
        this.hostname = hostname;
        this.domain = domain;
        this.kmsKeyId = kmsKeyId;
        this.version = version;
        this.osVersion = osVersion;
        this.cpuCoreCount = cpuCoreCount;
        this.clusterName = clusterName;
        this.dataStoragePercentage = dataStoragePercentage;
        this.databaseEdition = databaseEdition;
        this.lastPatchHistoryEntryId = lastPatchHistoryEntryId;
        this.listenerPort = listenerPort;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.diskRedundancy = diskRedundancy;
        this.sparseDiskgroup = sparseDiskgroup;
        this.scanIpIds = scanIpIds;
        this.vipIds = vipIds;
        this.scanDnsRecordId = scanDnsRecordId;
        this.scanDnsName = scanDnsName;
        this.zoneId = zoneId;
        this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        this.recoStorageSizeInGB = recoStorageSizeInGB;
        this.nodeCount = nodeCount;
        this.licenseModel = licenseModel;
        this.maintenanceWindow = maintenanceWindow;
        this.lastMaintenanceRunId = lastMaintenanceRunId;
        this.nextMaintenanceRunId = nextMaintenanceRunId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.sourceDbSystemId = sourceDbSystemId;
        this.pointInTimeDataDiskCloneTimestamp = pointInTimeDataDiskCloneTimestamp;
        this.dataCollectionOptions = dataCollectionOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ExadataIormConfig getIormConfigCache() {
        return this.iormConfigCache;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public List<String> getFaultDomains() {
        return this.faultDomains;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getBackupSubnetId() {
        return this.backupSubnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public List<String> getBackupNetworkNsgIds() {
        return this.backupNetworkNsgIds;
    }

    public String getGiSoftwareImageId() {
        return this.giSoftwareImageId;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public StorageVolumePerformanceMode getStorageVolumePerformanceMode() {
        return this.storageVolumePerformanceMode;
    }

    public String getShape() {
        return this.shape;
    }

    public DbSystemOptions getDbSystemOptions() {
        return this.dbSystemOptions;
    }

    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getDataStoragePercentage() {
        return this.dataStoragePercentage;
    }

    public DatabaseEdition getDatabaseEdition() {
        return this.databaseEdition;
    }

    public String getLastPatchHistoryEntryId() {
        return this.lastPatchHistoryEntryId;
    }

    public Integer getListenerPort() {
        return this.listenerPort;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public DiskRedundancy getDiskRedundancy() {
        return this.diskRedundancy;
    }

    public Boolean getSparseDiskgroup() {
        return this.sparseDiskgroup;
    }

    public List<String> getScanIpIds() {
        return this.scanIpIds;
    }

    public List<String> getVipIds() {
        return this.vipIds;
    }

    public String getScanDnsRecordId() {
        return this.scanDnsRecordId;
    }

    public String getScanDnsName() {
        return this.scanDnsName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Integer getDataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public Integer getRecoStorageSizeInGB() {
        return this.recoStorageSizeInGB;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public MaintenanceWindow getMaintenanceWindow() {
        return this.maintenanceWindow;
    }

    public String getLastMaintenanceRunId() {
        return this.lastMaintenanceRunId;
    }

    public String getNextMaintenanceRunId() {
        return this.nextMaintenanceRunId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getSourceDbSystemId() {
        return this.sourceDbSystemId;
    }

    public Date getPointInTimeDataDiskCloneTimestamp() {
        return this.pointInTimeDataDiskCloneTimestamp;
    }

    public DataCollectionOptions getDataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystem(");
        sb.append("super=").append(super.toString());
        sb.append("iormConfigCache=").append(String.valueOf((Object)this.iormConfigCache));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomains=").append(String.valueOf(this.faultDomains));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", backupSubnetId=").append(String.valueOf(this.backupSubnetId));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", backupNetworkNsgIds=").append(String.valueOf(this.backupNetworkNsgIds));
        sb.append(", giSoftwareImageId=").append(String.valueOf(this.giSoftwareImageId));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", storageVolumePerformanceMode=").append(String.valueOf((Object)this.storageVolumePerformanceMode));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", dbSystemOptions=").append(String.valueOf((Object)this.dbSystemOptions));
        sb.append(", sshPublicKeys=").append(String.valueOf(this.sshPublicKeys));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", osVersion=").append(String.valueOf(this.osVersion));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", clusterName=").append(String.valueOf(this.clusterName));
        sb.append(", dataStoragePercentage=").append(String.valueOf(this.dataStoragePercentage));
        sb.append(", databaseEdition=").append(String.valueOf((Object)this.databaseEdition));
        sb.append(", lastPatchHistoryEntryId=").append(String.valueOf(this.lastPatchHistoryEntryId));
        sb.append(", listenerPort=").append(String.valueOf(this.listenerPort));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", diskRedundancy=").append(String.valueOf((Object)this.diskRedundancy));
        sb.append(", sparseDiskgroup=").append(String.valueOf(this.sparseDiskgroup));
        sb.append(", scanIpIds=").append(String.valueOf(this.scanIpIds));
        sb.append(", vipIds=").append(String.valueOf(this.vipIds));
        sb.append(", scanDnsRecordId=").append(String.valueOf(this.scanDnsRecordId));
        sb.append(", scanDnsName=").append(String.valueOf(this.scanDnsName));
        sb.append(", zoneId=").append(String.valueOf(this.zoneId));
        sb.append(", dataStorageSizeInGBs=").append(String.valueOf(this.dataStorageSizeInGBs));
        sb.append(", recoStorageSizeInGB=").append(String.valueOf(this.recoStorageSizeInGB));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", maintenanceWindow=").append(String.valueOf((Object)this.maintenanceWindow));
        sb.append(", lastMaintenanceRunId=").append(String.valueOf(this.lastMaintenanceRunId));
        sb.append(", nextMaintenanceRunId=").append(String.valueOf(this.nextMaintenanceRunId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", sourceDbSystemId=").append(String.valueOf(this.sourceDbSystemId));
        sb.append(", pointInTimeDataDiskCloneTimestamp=").append(String.valueOf(this.pointInTimeDataDiskCloneTimestamp));
        sb.append(", dataCollectionOptions=").append(String.valueOf((Object)this.dataCollectionOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystem)) {
            return false;
        }
        DbSystem other = (DbSystem)((Object)o);
        return Objects.equals((Object)this.iormConfigCache, (Object)other.iormConfigCache) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomains, other.faultDomains) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.backupSubnetId, other.backupSubnetId) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.backupNetworkNsgIds, other.backupNetworkNsgIds) && Objects.equals(this.giSoftwareImageId, other.giSoftwareImageId) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals((Object)this.storageVolumePerformanceMode, (Object)other.storageVolumePerformanceMode) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.dbSystemOptions, (Object)other.dbSystemOptions) && Objects.equals(this.sshPublicKeys, other.sshPublicKeys) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.domain, other.domain) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.version, other.version) && Objects.equals(this.osVersion, other.osVersion) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.dataStoragePercentage, other.dataStoragePercentage) && Objects.equals((Object)this.databaseEdition, (Object)other.databaseEdition) && Objects.equals(this.lastPatchHistoryEntryId, other.lastPatchHistoryEntryId) && Objects.equals(this.listenerPort, other.listenerPort) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.diskRedundancy, (Object)other.diskRedundancy) && Objects.equals(this.sparseDiskgroup, other.sparseDiskgroup) && Objects.equals(this.scanIpIds, other.scanIpIds) && Objects.equals(this.vipIds, other.vipIds) && Objects.equals(this.scanDnsRecordId, other.scanDnsRecordId) && Objects.equals(this.scanDnsName, other.scanDnsName) && Objects.equals(this.zoneId, other.zoneId) && Objects.equals(this.dataStorageSizeInGBs, other.dataStorageSizeInGBs) && Objects.equals(this.recoStorageSizeInGB, other.recoStorageSizeInGB) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals((Object)this.maintenanceWindow, (Object)other.maintenanceWindow) && Objects.equals(this.lastMaintenanceRunId, other.lastMaintenanceRunId) && Objects.equals(this.nextMaintenanceRunId, other.nextMaintenanceRunId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.sourceDbSystemId, other.sourceDbSystemId) && Objects.equals(this.pointInTimeDataDiskCloneTimestamp, other.pointInTimeDataDiskCloneTimestamp) && Objects.equals((Object)this.dataCollectionOptions, (Object)other.dataCollectionOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.iormConfigCache == null ? 43 : this.iormConfigCache.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomains == null ? 43 : this.faultDomains.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.backupSubnetId == null ? 43 : this.backupSubnetId.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.backupNetworkNsgIds == null ? 43 : this.backupNetworkNsgIds.hashCode());
        result = result * 59 + (this.giSoftwareImageId == null ? 43 : this.giSoftwareImageId.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.storageVolumePerformanceMode == null ? 43 : this.storageVolumePerformanceMode.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.dbSystemOptions == null ? 43 : this.dbSystemOptions.hashCode());
        result = result * 59 + (this.sshPublicKeys == null ? 43 : this.sshPublicKeys.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.osVersion == null ? 43 : this.osVersion.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.clusterName == null ? 43 : this.clusterName.hashCode());
        result = result * 59 + (this.dataStoragePercentage == null ? 43 : this.dataStoragePercentage.hashCode());
        result = result * 59 + (this.databaseEdition == null ? 43 : this.databaseEdition.hashCode());
        result = result * 59 + (this.lastPatchHistoryEntryId == null ? 43 : this.lastPatchHistoryEntryId.hashCode());
        result = result * 59 + (this.listenerPort == null ? 43 : this.listenerPort.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.diskRedundancy == null ? 43 : this.diskRedundancy.hashCode());
        result = result * 59 + (this.sparseDiskgroup == null ? 43 : this.sparseDiskgroup.hashCode());
        result = result * 59 + (this.scanIpIds == null ? 43 : this.scanIpIds.hashCode());
        result = result * 59 + (this.vipIds == null ? 43 : this.vipIds.hashCode());
        result = result * 59 + (this.scanDnsRecordId == null ? 43 : this.scanDnsRecordId.hashCode());
        result = result * 59 + (this.scanDnsName == null ? 43 : this.scanDnsName.hashCode());
        result = result * 59 + (this.zoneId == null ? 43 : this.zoneId.hashCode());
        result = result * 59 + (this.dataStorageSizeInGBs == null ? 43 : this.dataStorageSizeInGBs.hashCode());
        result = result * 59 + (this.recoStorageSizeInGB == null ? 43 : this.recoStorageSizeInGB.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.maintenanceWindow == null ? 43 : this.maintenanceWindow.hashCode());
        result = result * 59 + (this.lastMaintenanceRunId == null ? 43 : this.lastMaintenanceRunId.hashCode());
        result = result * 59 + (this.nextMaintenanceRunId == null ? 43 : this.nextMaintenanceRunId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.sourceDbSystemId == null ? 43 : this.sourceDbSystemId.hashCode());
        result = result * 59 + (this.pointInTimeDataDiskCloneTimestamp == null ? 43 : this.pointInTimeDataDiskCloneTimestamp.hashCode());
        result = result * 59 + (this.dataCollectionOptions == null ? 43 : this.dataCollectionOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DiskRedundancy implements BmcEnum
    {
        High("HIGH"),
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DiskRedundancy> map;

        private DiskRedundancy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiskRedundancy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DiskRedundancy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DiskRedundancy.class);
            map = new HashMap<String, DiskRedundancy>();
            for (DiskRedundancy v : DiskRedundancy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        Migrated("MIGRATED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        NeedsAttention("NEEDS_ATTENTION"),
        Upgrading("UPGRADING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseEdition implements BmcEnum
    {
        StandardEdition("STANDARD_EDITION"),
        EnterpriseEdition("ENTERPRISE_EDITION"),
        EnterpriseEditionHighPerformance("ENTERPRISE_EDITION_HIGH_PERFORMANCE"),
        EnterpriseEditionExtremePerformance("ENTERPRISE_EDITION_EXTREME_PERFORMANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseEdition> map;

        private DatabaseEdition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseEdition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseEdition', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseEdition.class);
            map = new HashMap<String, DatabaseEdition>();
            for (DatabaseEdition v : DatabaseEdition.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum StorageVolumePerformanceMode implements BmcEnum
    {
        Balanced("BALANCED"),
        HighPerformance("HIGH_PERFORMANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StorageVolumePerformanceMode> map;

        private StorageVolumePerformanceMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StorageVolumePerformanceMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StorageVolumePerformanceMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StorageVolumePerformanceMode.class);
            map = new HashMap<String, StorageVolumePerformanceMode>();
            for (StorageVolumePerformanceMode v : StorageVolumePerformanceMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="iormConfigCache")
        private ExadataIormConfig iormConfigCache;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomains")
        private List<String> faultDomains;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="backupSubnetId")
        private String backupSubnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="backupNetworkNsgIds")
        private List<String> backupNetworkNsgIds;
        @JsonProperty(value="giSoftwareImageId")
        private String giSoftwareImageId;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="storageVolumePerformanceMode")
        private StorageVolumePerformanceMode storageVolumePerformanceMode;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="dbSystemOptions")
        private DbSystemOptions dbSystemOptions;
        @JsonProperty(value="sshPublicKeys")
        private List<String> sshPublicKeys;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="osVersion")
        private String osVersion;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="dataStoragePercentage")
        private Integer dataStoragePercentage;
        @JsonProperty(value="databaseEdition")
        private DatabaseEdition databaseEdition;
        @JsonProperty(value="lastPatchHistoryEntryId")
        private String lastPatchHistoryEntryId;
        @JsonProperty(value="listenerPort")
        private Integer listenerPort;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="diskRedundancy")
        private DiskRedundancy diskRedundancy;
        @JsonProperty(value="sparseDiskgroup")
        private Boolean sparseDiskgroup;
        @JsonProperty(value="scanIpIds")
        private List<String> scanIpIds;
        @JsonProperty(value="vipIds")
        private List<String> vipIds;
        @JsonProperty(value="scanDnsRecordId")
        private String scanDnsRecordId;
        @JsonProperty(value="scanDnsName")
        private String scanDnsName;
        @JsonProperty(value="zoneId")
        private String zoneId;
        @JsonProperty(value="dataStorageSizeInGBs")
        private Integer dataStorageSizeInGBs;
        @JsonProperty(value="recoStorageSizeInGB")
        private Integer recoStorageSizeInGB;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="maintenanceWindow")
        private MaintenanceWindow maintenanceWindow;
        @JsonProperty(value="lastMaintenanceRunId")
        private String lastMaintenanceRunId;
        @JsonProperty(value="nextMaintenanceRunId")
        private String nextMaintenanceRunId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="sourceDbSystemId")
        private String sourceDbSystemId;
        @JsonProperty(value="pointInTimeDataDiskCloneTimestamp")
        private Date pointInTimeDataDiskCloneTimestamp;
        @JsonProperty(value="dataCollectionOptions")
        private DataCollectionOptions dataCollectionOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder iormConfigCache(ExadataIormConfig iormConfigCache) {
            this.iormConfigCache = iormConfigCache;
            this.__explicitlySet__.add("iormConfigCache");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomains(List<String> faultDomains) {
            this.faultDomains = faultDomains;
            this.__explicitlySet__.add("faultDomains");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder backupSubnetId(String backupSubnetId) {
            this.backupSubnetId = backupSubnetId;
            this.__explicitlySet__.add("backupSubnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder backupNetworkNsgIds(List<String> backupNetworkNsgIds) {
            this.backupNetworkNsgIds = backupNetworkNsgIds;
            this.__explicitlySet__.add("backupNetworkNsgIds");
            return this;
        }

        public Builder giSoftwareImageId(String giSoftwareImageId) {
            this.giSoftwareImageId = giSoftwareImageId;
            this.__explicitlySet__.add("giSoftwareImageId");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder storageVolumePerformanceMode(StorageVolumePerformanceMode storageVolumePerformanceMode) {
            this.storageVolumePerformanceMode = storageVolumePerformanceMode;
            this.__explicitlySet__.add("storageVolumePerformanceMode");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder dbSystemOptions(DbSystemOptions dbSystemOptions) {
            this.dbSystemOptions = dbSystemOptions;
            this.__explicitlySet__.add("dbSystemOptions");
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            this.__explicitlySet__.add("sshPublicKeys");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.__explicitlySet__.add("osVersion");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder dataStoragePercentage(Integer dataStoragePercentage) {
            this.dataStoragePercentage = dataStoragePercentage;
            this.__explicitlySet__.add("dataStoragePercentage");
            return this;
        }

        public Builder databaseEdition(DatabaseEdition databaseEdition) {
            this.databaseEdition = databaseEdition;
            this.__explicitlySet__.add("databaseEdition");
            return this;
        }

        public Builder lastPatchHistoryEntryId(String lastPatchHistoryEntryId) {
            this.lastPatchHistoryEntryId = lastPatchHistoryEntryId;
            this.__explicitlySet__.add("lastPatchHistoryEntryId");
            return this;
        }

        public Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder diskRedundancy(DiskRedundancy diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
            this.__explicitlySet__.add("diskRedundancy");
            return this;
        }

        public Builder sparseDiskgroup(Boolean sparseDiskgroup) {
            this.sparseDiskgroup = sparseDiskgroup;
            this.__explicitlySet__.add("sparseDiskgroup");
            return this;
        }

        public Builder scanIpIds(List<String> scanIpIds) {
            this.scanIpIds = scanIpIds;
            this.__explicitlySet__.add("scanIpIds");
            return this;
        }

        public Builder vipIds(List<String> vipIds) {
            this.vipIds = vipIds;
            this.__explicitlySet__.add("vipIds");
            return this;
        }

        public Builder scanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
            this.__explicitlySet__.add("scanDnsRecordId");
            return this;
        }

        public Builder scanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
            this.__explicitlySet__.add("scanDnsName");
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            this.__explicitlySet__.add("zoneId");
            return this;
        }

        public Builder dataStorageSizeInGBs(Integer dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            this.__explicitlySet__.add("dataStorageSizeInGBs");
            return this;
        }

        public Builder recoStorageSizeInGB(Integer recoStorageSizeInGB) {
            this.recoStorageSizeInGB = recoStorageSizeInGB;
            this.__explicitlySet__.add("recoStorageSizeInGB");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            this.__explicitlySet__.add("maintenanceWindow");
            return this;
        }

        public Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            this.__explicitlySet__.add("lastMaintenanceRunId");
            return this;
        }

        public Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            this.__explicitlySet__.add("nextMaintenanceRunId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder sourceDbSystemId(String sourceDbSystemId) {
            this.sourceDbSystemId = sourceDbSystemId;
            this.__explicitlySet__.add("sourceDbSystemId");
            return this;
        }

        public Builder pointInTimeDataDiskCloneTimestamp(Date pointInTimeDataDiskCloneTimestamp) {
            this.pointInTimeDataDiskCloneTimestamp = pointInTimeDataDiskCloneTimestamp;
            this.__explicitlySet__.add("pointInTimeDataDiskCloneTimestamp");
            return this;
        }

        public Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            this.__explicitlySet__.add("dataCollectionOptions");
            return this;
        }

        public DbSystem build() {
            DbSystem model = new DbSystem(this.iormConfigCache, this.id, this.compartmentId, this.displayName, this.availabilityDomain, this.faultDomains, this.subnetId, this.backupSubnetId, this.nsgIds, this.backupNetworkNsgIds, this.giSoftwareImageId, this.memorySizeInGBs, this.storageVolumePerformanceMode, this.shape, this.dbSystemOptions, this.sshPublicKeys, this.timeZone, this.hostname, this.domain, this.kmsKeyId, this.version, this.osVersion, this.cpuCoreCount, this.clusterName, this.dataStoragePercentage, this.databaseEdition, this.lastPatchHistoryEntryId, this.listenerPort, this.lifecycleState, this.timeCreated, this.lifecycleDetails, this.diskRedundancy, this.sparseDiskgroup, this.scanIpIds, this.vipIds, this.scanDnsRecordId, this.scanDnsName, this.zoneId, this.dataStorageSizeInGBs, this.recoStorageSizeInGB, this.nodeCount, this.licenseModel, this.maintenanceWindow, this.lastMaintenanceRunId, this.nextMaintenanceRunId, this.freeformTags, this.definedTags, this.sourceDbSystemId, this.pointInTimeDataDiskCloneTimestamp, this.dataCollectionOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystem model) {
            if (model.wasPropertyExplicitlySet("iormConfigCache")) {
                this.iormConfigCache(model.getIormConfigCache());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomains")) {
                this.faultDomains(model.getFaultDomains());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("backupSubnetId")) {
                this.backupSubnetId(model.getBackupSubnetId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("backupNetworkNsgIds")) {
                this.backupNetworkNsgIds(model.getBackupNetworkNsgIds());
            }
            if (model.wasPropertyExplicitlySet("giSoftwareImageId")) {
                this.giSoftwareImageId(model.getGiSoftwareImageId());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("storageVolumePerformanceMode")) {
                this.storageVolumePerformanceMode(model.getStorageVolumePerformanceMode());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("dbSystemOptions")) {
                this.dbSystemOptions(model.getDbSystemOptions());
            }
            if (model.wasPropertyExplicitlySet("sshPublicKeys")) {
                this.sshPublicKeys(model.getSshPublicKeys());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("osVersion")) {
                this.osVersion(model.getOsVersion());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("clusterName")) {
                this.clusterName(model.getClusterName());
            }
            if (model.wasPropertyExplicitlySet("dataStoragePercentage")) {
                this.dataStoragePercentage(model.getDataStoragePercentage());
            }
            if (model.wasPropertyExplicitlySet("databaseEdition")) {
                this.databaseEdition(model.getDatabaseEdition());
            }
            if (model.wasPropertyExplicitlySet("lastPatchHistoryEntryId")) {
                this.lastPatchHistoryEntryId(model.getLastPatchHistoryEntryId());
            }
            if (model.wasPropertyExplicitlySet("listenerPort")) {
                this.listenerPort(model.getListenerPort());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("diskRedundancy")) {
                this.diskRedundancy(model.getDiskRedundancy());
            }
            if (model.wasPropertyExplicitlySet("sparseDiskgroup")) {
                this.sparseDiskgroup(model.getSparseDiskgroup());
            }
            if (model.wasPropertyExplicitlySet("scanIpIds")) {
                this.scanIpIds(model.getScanIpIds());
            }
            if (model.wasPropertyExplicitlySet("vipIds")) {
                this.vipIds(model.getVipIds());
            }
            if (model.wasPropertyExplicitlySet("scanDnsRecordId")) {
                this.scanDnsRecordId(model.getScanDnsRecordId());
            }
            if (model.wasPropertyExplicitlySet("scanDnsName")) {
                this.scanDnsName(model.getScanDnsName());
            }
            if (model.wasPropertyExplicitlySet("zoneId")) {
                this.zoneId(model.getZoneId());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInGBs")) {
                this.dataStorageSizeInGBs(model.getDataStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("recoStorageSizeInGB")) {
                this.recoStorageSizeInGB(model.getRecoStorageSizeInGB());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindow")) {
                this.maintenanceWindow(model.getMaintenanceWindow());
            }
            if (model.wasPropertyExplicitlySet("lastMaintenanceRunId")) {
                this.lastMaintenanceRunId(model.getLastMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("nextMaintenanceRunId")) {
                this.nextMaintenanceRunId(model.getNextMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("sourceDbSystemId")) {
                this.sourceDbSystemId(model.getSourceDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("pointInTimeDataDiskCloneTimestamp")) {
                this.pointInTimeDataDiskCloneTimestamp(model.getPointInTimeDataDiskCloneTimestamp());
            }
            if (model.wasPropertyExplicitlySet("dataCollectionOptions")) {
                this.dataCollectionOptions(model.getDataCollectionOptions());
            }
            return this;
        }
    }
}

