/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.Diagnosability;
import com.oracle.bmc.databasemanagement.DiagnosabilityPaginators;
import com.oracle.bmc.databasemanagement.model.AlertLogCollection;
import com.oracle.bmc.databasemanagement.model.AlertLogCountsCollection;
import com.oracle.bmc.databasemanagement.model.AttentionLogCollection;
import com.oracle.bmc.databasemanagement.model.AttentionLogCountsCollection;
import com.oracle.bmc.databasemanagement.requests.ListAlertLogsRequest;
import com.oracle.bmc.databasemanagement.requests.ListAttentionLogsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAlertLogCountsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAttentionLogCountsRequest;
import com.oracle.bmc.databasemanagement.responses.ListAlertLogsResponse;
import com.oracle.bmc.databasemanagement.responses.ListAttentionLogsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAlertLogCountsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAttentionLogCountsResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosabilityClient
extends BaseSyncClient
implements Diagnosability {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DIAGNOSABILITY").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosabilityClient.class);
    private final DiagnosabilityPaginators paginators = new DiagnosabilityPaginators(this);

    DiagnosabilityClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListAlertLogsResponse listAlertLogs(ListAlertLogsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListAlertLogsResponse)this.clientCall(request, ListAlertLogsResponse::builder).logger(LOG, "listAlertLogs").serviceDetails("Diagnosability", "ListAlertLogs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAlertLogs").method(Method.GET).requestBuilder(ListAlertLogsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("alertLogs").appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("levelFilter", (BmcEnum)request.getLevelFilter()).appendEnumQueryParam("typeFilter", (BmcEnum)request.getTypeFilter()).appendQueryParam("logSearchText", (Object)request.getLogSearchText()).appendQueryParam("isRegularExpression", (Object)request.getIsRegularExpression()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AlertLogCollection.class, ListAlertLogsResponse.Builder::alertLogCollection).handleResponseHeaderString("opc-request-id", ListAlertLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAlertLogsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAttentionLogsResponse listAttentionLogs(ListAttentionLogsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListAttentionLogsResponse)this.clientCall(request, ListAttentionLogsResponse::builder).logger(LOG, "listAttentionLogs").serviceDetails("Diagnosability", "ListAttentionLogs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAttentionLogs").method(Method.GET).requestBuilder(ListAttentionLogsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("attentionLogs").appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("urgencyFilter", (BmcEnum)request.getUrgencyFilter()).appendEnumQueryParam("typeFilter", (BmcEnum)request.getTypeFilter()).appendQueryParam("logSearchText", (Object)request.getLogSearchText()).appendQueryParam("isRegularExpression", (Object)request.getIsRegularExpression()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AttentionLogCollection.class, ListAttentionLogsResponse.Builder::attentionLogCollection).handleResponseHeaderString("opc-request-id", ListAttentionLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAttentionLogsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAlertLogCountsResponse summarizeAlertLogCounts(SummarizeAlertLogCountsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (SummarizeAlertLogCountsResponse)this.clientCall(request, SummarizeAlertLogCountsResponse::builder).logger(LOG, "summarizeAlertLogCounts").serviceDetails("Diagnosability", "SummarizeAlertLogCounts", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAlertLogCounts").method(Method.GET).requestBuilder(SummarizeAlertLogCountsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("alertLogCounts").appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("levelFilter", (BmcEnum)request.getLevelFilter()).appendEnumQueryParam("groupBy", (BmcEnum)request.getGroupBy()).appendEnumQueryParam("typeFilter", (BmcEnum)request.getTypeFilter()).appendQueryParam("logSearchText", (Object)request.getLogSearchText()).appendQueryParam("isRegularExpression", (Object)request.getIsRegularExpression()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AlertLogCountsCollection.class, SummarizeAlertLogCountsResponse.Builder::alertLogCountsCollection).handleResponseHeaderString("opc-request-id", SummarizeAlertLogCountsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAlertLogCountsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeAttentionLogCountsResponse summarizeAttentionLogCounts(SummarizeAttentionLogCountsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (SummarizeAttentionLogCountsResponse)this.clientCall(request, SummarizeAttentionLogCountsResponse::builder).logger(LOG, "summarizeAttentionLogCounts").serviceDetails("Diagnosability", "SummarizeAttentionLogCounts", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAttentionLogCounts").method(Method.GET).requestBuilder(SummarizeAttentionLogCountsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("attentionLogCounts").appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("urgencyFilter", (BmcEnum)request.getUrgencyFilter()).appendEnumQueryParam("groupBy", (BmcEnum)request.getGroupBy()).appendEnumQueryParam("typeFilter", (BmcEnum)request.getTypeFilter()).appendQueryParam("logSearchText", (Object)request.getLogSearchText()).appendQueryParam("isRegularExpression", (Object)request.getIsRegularExpression()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AttentionLogCountsCollection.class, SummarizeAttentionLogCountsResponse.Builder::attentionLogCountsCollection).handleResponseHeaderString("opc-request-id", SummarizeAttentionLogCountsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAttentionLogCountsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public DiagnosabilityPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DiagnosabilityClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DiagnosabilityClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DiagnosabilityClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DiagnosabilityClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DiagnosabilityClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DiagnosabilityClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DiagnosabilityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DiagnosabilityClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DiagnosabilityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DiagnosabilityClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DiagnosabilityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DiagnosabilityClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DiagnosabilityClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DiagnosabilityClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DiagnosabilityClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DiagnosabilityClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DiagnosabilityClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

