/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AlertLogSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="messageLevel")
    private final MessageLevel messageLevel;
    @JsonProperty(value="messageType")
    private final MessageType messageType;
    @JsonProperty(value="messageContent")
    private final String messageContent;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="supplementalDetail")
    private final String supplementalDetail;
    @JsonProperty(value="fileLocation")
    private final String fileLocation;

    @Deprecated
    @ConstructorProperties(value={"messageLevel", "messageType", "messageContent", "timestamp", "supplementalDetail", "fileLocation"})
    public AlertLogSummary(MessageLevel messageLevel, MessageType messageType, String messageContent, Date timestamp, String supplementalDetail, String fileLocation) {
        this.messageLevel = messageLevel;
        this.messageType = messageType;
        this.messageContent = messageContent;
        this.timestamp = timestamp;
        this.supplementalDetail = supplementalDetail;
        this.fileLocation = fileLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MessageLevel getMessageLevel() {
        return this.messageLevel;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getSupplementalDetail() {
        return this.supplementalDetail;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AlertLogSummary(");
        sb.append("super=").append(super.toString());
        sb.append("messageLevel=").append(String.valueOf((Object)this.messageLevel));
        sb.append(", messageType=").append(String.valueOf((Object)this.messageType));
        sb.append(", messageContent=").append(String.valueOf(this.messageContent));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", supplementalDetail=").append(String.valueOf(this.supplementalDetail));
        sb.append(", fileLocation=").append(String.valueOf(this.fileLocation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlertLogSummary)) {
            return false;
        }
        AlertLogSummary other = (AlertLogSummary)((Object)o);
        return Objects.equals((Object)this.messageLevel, (Object)other.messageLevel) && Objects.equals((Object)this.messageType, (Object)other.messageType) && Objects.equals(this.messageContent, other.messageContent) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.supplementalDetail, other.supplementalDetail) && Objects.equals(this.fileLocation, other.fileLocation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.messageLevel == null ? 43 : this.messageLevel.hashCode());
        result = result * 59 + (this.messageType == null ? 43 : this.messageType.hashCode());
        result = result * 59 + (this.messageContent == null ? 43 : this.messageContent.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.supplementalDetail == null ? 43 : this.supplementalDetail.hashCode());
        result = result * 59 + (this.fileLocation == null ? 43 : this.fileLocation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MessageType implements BmcEnum
    {
        Unknown("UNKNOWN"),
        IncidentError("INCIDENT_ERROR"),
        Error("ERROR"),
        Warning("WARNING"),
        Notification("NOTIFICATION"),
        Trace("TRACE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MessageType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MessageType.class);
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MessageLevel implements BmcEnum
    {
        Critical("CRITICAL"),
        Severe("SEVERE"),
        Important("IMPORTANT"),
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MessageLevel> map;

        private MessageLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MessageLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MessageLevel.class);
            map = new HashMap<String, MessageLevel>();
            for (MessageLevel v : MessageLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="messageLevel")
        private MessageLevel messageLevel;
        @JsonProperty(value="messageType")
        private MessageType messageType;
        @JsonProperty(value="messageContent")
        private String messageContent;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="supplementalDetail")
        private String supplementalDetail;
        @JsonProperty(value="fileLocation")
        private String fileLocation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder messageLevel(MessageLevel messageLevel) {
            this.messageLevel = messageLevel;
            this.__explicitlySet__.add("messageLevel");
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            this.__explicitlySet__.add("messageType");
            return this;
        }

        public Builder messageContent(String messageContent) {
            this.messageContent = messageContent;
            this.__explicitlySet__.add("messageContent");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder supplementalDetail(String supplementalDetail) {
            this.supplementalDetail = supplementalDetail;
            this.__explicitlySet__.add("supplementalDetail");
            return this;
        }

        public Builder fileLocation(String fileLocation) {
            this.fileLocation = fileLocation;
            this.__explicitlySet__.add("fileLocation");
            return this;
        }

        public AlertLogSummary build() {
            AlertLogSummary model = new AlertLogSummary(this.messageLevel, this.messageType, this.messageContent, this.timestamp, this.supplementalDetail, this.fileLocation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AlertLogSummary model) {
            if (model.wasPropertyExplicitlySet("messageLevel")) {
                this.messageLevel(model.getMessageLevel());
            }
            if (model.wasPropertyExplicitlySet("messageType")) {
                this.messageType(model.getMessageType());
            }
            if (model.wasPropertyExplicitlySet("messageContent")) {
                this.messageContent(model.getMessageContent());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("supplementalDetail")) {
                this.supplementalDetail(model.getSupplementalDetail());
            }
            if (model.wasPropertyExplicitlySet("fileLocation")) {
                this.fileLocation(model.getFileLocation());
            }
            return this;
        }
    }
}

