/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDatabaseManagementConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateExternalDbSystemDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dbSystemDiscoveryId")
    private final String dbSystemDiscoveryId;
    @JsonProperty(value="databaseManagementConfig")
    private final ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "dbSystemDiscoveryId", "databaseManagementConfig"})
    public CreateExternalDbSystemDetails(String displayName, String compartmentId, String dbSystemDiscoveryId, ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.dbSystemDiscoveryId = dbSystemDiscoveryId;
        this.databaseManagementConfig = databaseManagementConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbSystemDiscoveryId() {
        return this.dbSystemDiscoveryId;
    }

    public ExternalDbSystemDatabaseManagementConfigDetails getDatabaseManagementConfig() {
        return this.databaseManagementConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateExternalDbSystemDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dbSystemDiscoveryId=").append(String.valueOf(this.dbSystemDiscoveryId));
        sb.append(", databaseManagementConfig=").append(String.valueOf((Object)this.databaseManagementConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateExternalDbSystemDetails)) {
            return false;
        }
        CreateExternalDbSystemDetails other = (CreateExternalDbSystemDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dbSystemDiscoveryId, other.dbSystemDiscoveryId) && Objects.equals((Object)this.databaseManagementConfig, (Object)other.databaseManagementConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dbSystemDiscoveryId == null ? 43 : this.dbSystemDiscoveryId.hashCode());
        result = result * 59 + (this.databaseManagementConfig == null ? 43 : this.databaseManagementConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dbSystemDiscoveryId")
        private String dbSystemDiscoveryId;
        @JsonProperty(value="databaseManagementConfig")
        private ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dbSystemDiscoveryId(String dbSystemDiscoveryId) {
            this.dbSystemDiscoveryId = dbSystemDiscoveryId;
            this.__explicitlySet__.add("dbSystemDiscoveryId");
            return this;
        }

        public Builder databaseManagementConfig(ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig) {
            this.databaseManagementConfig = databaseManagementConfig;
            this.__explicitlySet__.add("databaseManagementConfig");
            return this;
        }

        public CreateExternalDbSystemDetails build() {
            CreateExternalDbSystemDetails model = new CreateExternalDbSystemDetails(this.displayName, this.compartmentId, this.dbSystemDiscoveryId, this.databaseManagementConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateExternalDbSystemDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemDiscoveryId")) {
                this.dbSystemDiscoveryId(model.getDbSystemDiscoveryId());
            }
            if (model.wasPropertyExplicitlySet("databaseManagementConfig")) {
                this.databaseManagementConfig(model.getDatabaseManagementConfig());
            }
            return this;
        }
    }
}

