/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AssociatedComponent;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalClusterInstance;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalDbSystemComponent;
import com.oracle.bmc.databasemanagement.model.ExternalClusterNetworkConfiguration;
import com.oracle.bmc.databasemanagement.model.ExternalClusterScanListenerConfiguration;
import com.oracle.bmc.databasemanagement.model.ExternalClusterVipConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveredExternalCluster
extends DiscoveredExternalDbSystemComponent {
    @JsonProperty(value="gridHome")
    private final String gridHome;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="isFlexCluster")
    private final Boolean isFlexCluster;
    @JsonProperty(value="networkConfigurations")
    private final List<ExternalClusterNetworkConfiguration> networkConfigurations;
    @JsonProperty(value="vipConfigurations")
    private final List<ExternalClusterVipConfiguration> vipConfigurations;
    @JsonProperty(value="scanConfigurations")
    private final List<ExternalClusterScanListenerConfiguration> scanConfigurations;
    @JsonProperty(value="ocrFileLocation")
    private final String ocrFileLocation;
    @JsonProperty(value="clusterInstances")
    private final List<DiscoveredExternalClusterInstance> clusterInstances;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DiscoveredExternalCluster(String componentId, String displayName, String componentName, String resourceId, Boolean isSelectedForMonitoring, DiscoveredExternalDbSystemComponent.Status status, List<AssociatedComponent> associatedComponents, String gridHome, String version, Boolean isFlexCluster, List<ExternalClusterNetworkConfiguration> networkConfigurations, List<ExternalClusterVipConfiguration> vipConfigurations, List<ExternalClusterScanListenerConfiguration> scanConfigurations, String ocrFileLocation, List<DiscoveredExternalClusterInstance> clusterInstances) {
        super(componentId, displayName, componentName, resourceId, isSelectedForMonitoring, status, associatedComponents);
        this.gridHome = gridHome;
        this.version = version;
        this.isFlexCluster = isFlexCluster;
        this.networkConfigurations = networkConfigurations;
        this.vipConfigurations = vipConfigurations;
        this.scanConfigurations = scanConfigurations;
        this.ocrFileLocation = ocrFileLocation;
        this.clusterInstances = clusterInstances;
    }

    public String getGridHome() {
        return this.gridHome;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getIsFlexCluster() {
        return this.isFlexCluster;
    }

    public List<ExternalClusterNetworkConfiguration> getNetworkConfigurations() {
        return this.networkConfigurations;
    }

    public List<ExternalClusterVipConfiguration> getVipConfigurations() {
        return this.vipConfigurations;
    }

    public List<ExternalClusterScanListenerConfiguration> getScanConfigurations() {
        return this.scanConfigurations;
    }

    public String getOcrFileLocation() {
        return this.ocrFileLocation;
    }

    public List<DiscoveredExternalClusterInstance> getClusterInstances() {
        return this.clusterInstances;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveredExternalCluster(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", gridHome=").append(String.valueOf(this.gridHome));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", isFlexCluster=").append(String.valueOf(this.isFlexCluster));
        sb.append(", networkConfigurations=").append(String.valueOf(this.networkConfigurations));
        sb.append(", vipConfigurations=").append(String.valueOf(this.vipConfigurations));
        sb.append(", scanConfigurations=").append(String.valueOf(this.scanConfigurations));
        sb.append(", ocrFileLocation=").append(String.valueOf(this.ocrFileLocation));
        sb.append(", clusterInstances=").append(String.valueOf(this.clusterInstances));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveredExternalCluster)) {
            return false;
        }
        DiscoveredExternalCluster other = (DiscoveredExternalCluster)((Object)o);
        return Objects.equals(this.gridHome, other.gridHome) && Objects.equals(this.version, other.version) && Objects.equals(this.isFlexCluster, other.isFlexCluster) && Objects.equals(this.networkConfigurations, other.networkConfigurations) && Objects.equals(this.vipConfigurations, other.vipConfigurations) && Objects.equals(this.scanConfigurations, other.scanConfigurations) && Objects.equals(this.ocrFileLocation, other.ocrFileLocation) && Objects.equals(this.clusterInstances, other.clusterInstances) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.gridHome == null ? 43 : this.gridHome.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.isFlexCluster == null ? 43 : this.isFlexCluster.hashCode());
        result = result * 59 + (this.networkConfigurations == null ? 43 : this.networkConfigurations.hashCode());
        result = result * 59 + (this.vipConfigurations == null ? 43 : this.vipConfigurations.hashCode());
        result = result * 59 + (this.scanConfigurations == null ? 43 : this.scanConfigurations.hashCode());
        result = result * 59 + (this.ocrFileLocation == null ? 43 : this.ocrFileLocation.hashCode());
        result = result * 59 + (this.clusterInstances == null ? 43 : this.clusterInstances.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="componentId")
        private String componentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="componentName")
        private String componentName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="isSelectedForMonitoring")
        private Boolean isSelectedForMonitoring;
        @JsonProperty(value="status")
        private DiscoveredExternalDbSystemComponent.Status status;
        @JsonProperty(value="associatedComponents")
        private List<AssociatedComponent> associatedComponents;
        @JsonProperty(value="gridHome")
        private String gridHome;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="isFlexCluster")
        private Boolean isFlexCluster;
        @JsonProperty(value="networkConfigurations")
        private List<ExternalClusterNetworkConfiguration> networkConfigurations;
        @JsonProperty(value="vipConfigurations")
        private List<ExternalClusterVipConfiguration> vipConfigurations;
        @JsonProperty(value="scanConfigurations")
        private List<ExternalClusterScanListenerConfiguration> scanConfigurations;
        @JsonProperty(value="ocrFileLocation")
        private String ocrFileLocation;
        @JsonProperty(value="clusterInstances")
        private List<DiscoveredExternalClusterInstance> clusterInstances;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder componentId(String componentId) {
            this.componentId = componentId;
            this.__explicitlySet__.add("componentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.__explicitlySet__.add("componentName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder isSelectedForMonitoring(Boolean isSelectedForMonitoring) {
            this.isSelectedForMonitoring = isSelectedForMonitoring;
            this.__explicitlySet__.add("isSelectedForMonitoring");
            return this;
        }

        public Builder status(DiscoveredExternalDbSystemComponent.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder associatedComponents(List<AssociatedComponent> associatedComponents) {
            this.associatedComponents = associatedComponents;
            this.__explicitlySet__.add("associatedComponents");
            return this;
        }

        public Builder gridHome(String gridHome) {
            this.gridHome = gridHome;
            this.__explicitlySet__.add("gridHome");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder isFlexCluster(Boolean isFlexCluster) {
            this.isFlexCluster = isFlexCluster;
            this.__explicitlySet__.add("isFlexCluster");
            return this;
        }

        public Builder networkConfigurations(List<ExternalClusterNetworkConfiguration> networkConfigurations) {
            this.networkConfigurations = networkConfigurations;
            this.__explicitlySet__.add("networkConfigurations");
            return this;
        }

        public Builder vipConfigurations(List<ExternalClusterVipConfiguration> vipConfigurations) {
            this.vipConfigurations = vipConfigurations;
            this.__explicitlySet__.add("vipConfigurations");
            return this;
        }

        public Builder scanConfigurations(List<ExternalClusterScanListenerConfiguration> scanConfigurations) {
            this.scanConfigurations = scanConfigurations;
            this.__explicitlySet__.add("scanConfigurations");
            return this;
        }

        public Builder ocrFileLocation(String ocrFileLocation) {
            this.ocrFileLocation = ocrFileLocation;
            this.__explicitlySet__.add("ocrFileLocation");
            return this;
        }

        public Builder clusterInstances(List<DiscoveredExternalClusterInstance> clusterInstances) {
            this.clusterInstances = clusterInstances;
            this.__explicitlySet__.add("clusterInstances");
            return this;
        }

        public DiscoveredExternalCluster build() {
            DiscoveredExternalCluster model = new DiscoveredExternalCluster(this.componentId, this.displayName, this.componentName, this.resourceId, this.isSelectedForMonitoring, this.status, this.associatedComponents, this.gridHome, this.version, this.isFlexCluster, this.networkConfigurations, this.vipConfigurations, this.scanConfigurations, this.ocrFileLocation, this.clusterInstances);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveredExternalCluster model) {
            if (model.wasPropertyExplicitlySet("componentId")) {
                this.componentId(model.getComponentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("componentName")) {
                this.componentName(model.getComponentName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("isSelectedForMonitoring")) {
                this.isSelectedForMonitoring(model.getIsSelectedForMonitoring());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("associatedComponents")) {
                this.associatedComponents(model.getAssociatedComponents());
            }
            if (model.wasPropertyExplicitlySet("gridHome")) {
                this.gridHome(model.getGridHome());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("isFlexCluster")) {
                this.isFlexCluster(model.getIsFlexCluster());
            }
            if (model.wasPropertyExplicitlySet("networkConfigurations")) {
                this.networkConfigurations(model.getNetworkConfigurations());
            }
            if (model.wasPropertyExplicitlySet("vipConfigurations")) {
                this.vipConfigurations(model.getVipConfigurations());
            }
            if (model.wasPropertyExplicitlySet("scanConfigurations")) {
                this.scanConfigurations(model.getScanConfigurations());
            }
            if (model.wasPropertyExplicitlySet("ocrFileLocation")) {
                this.ocrFileLocation(model.getOcrFileLocation());
            }
            if (model.wasPropertyExplicitlySet("clusterInstances")) {
                this.clusterInstances(model.getClusterInstances());
            }
            return this;
        }
    }
}

