/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AssociatedComponent;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalDbSystemComponent;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscoveryConnector;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveredExternalPluggableDatabase
extends DiscoveredExternalDbSystemComponent {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="containerDatabaseId")
    private final String containerDatabaseId;
    @JsonProperty(value="guid")
    private final String guid;
    @JsonProperty(value="connector")
    private final ExternalDbSystemDiscoveryConnector connector;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DiscoveredExternalPluggableDatabase(String componentId, String displayName, String componentName, String resourceId, Boolean isSelectedForMonitoring, DiscoveredExternalDbSystemComponent.Status status, List<AssociatedComponent> associatedComponents, String compartmentId, String containerDatabaseId, String guid, ExternalDbSystemDiscoveryConnector connector) {
        super(componentId, displayName, componentName, resourceId, isSelectedForMonitoring, status, associatedComponents);
        this.compartmentId = compartmentId;
        this.containerDatabaseId = containerDatabaseId;
        this.guid = guid;
        this.connector = connector;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getContainerDatabaseId() {
        return this.containerDatabaseId;
    }

    public String getGuid() {
        return this.guid;
    }

    public ExternalDbSystemDiscoveryConnector getConnector() {
        return this.connector;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveredExternalPluggableDatabase(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", containerDatabaseId=").append(String.valueOf(this.containerDatabaseId));
        sb.append(", guid=").append(String.valueOf(this.guid));
        sb.append(", connector=").append(String.valueOf((Object)this.connector));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveredExternalPluggableDatabase)) {
            return false;
        }
        DiscoveredExternalPluggableDatabase other = (DiscoveredExternalPluggableDatabase)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.containerDatabaseId, other.containerDatabaseId) && Objects.equals(this.guid, other.guid) && Objects.equals((Object)this.connector, (Object)other.connector) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.containerDatabaseId == null ? 43 : this.containerDatabaseId.hashCode());
        result = result * 59 + (this.guid == null ? 43 : this.guid.hashCode());
        result = result * 59 + (this.connector == null ? 43 : this.connector.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="componentId")
        private String componentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="componentName")
        private String componentName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="isSelectedForMonitoring")
        private Boolean isSelectedForMonitoring;
        @JsonProperty(value="status")
        private DiscoveredExternalDbSystemComponent.Status status;
        @JsonProperty(value="associatedComponents")
        private List<AssociatedComponent> associatedComponents;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="containerDatabaseId")
        private String containerDatabaseId;
        @JsonProperty(value="guid")
        private String guid;
        @JsonProperty(value="connector")
        private ExternalDbSystemDiscoveryConnector connector;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder componentId(String componentId) {
            this.componentId = componentId;
            this.__explicitlySet__.add("componentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.__explicitlySet__.add("componentName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder isSelectedForMonitoring(Boolean isSelectedForMonitoring) {
            this.isSelectedForMonitoring = isSelectedForMonitoring;
            this.__explicitlySet__.add("isSelectedForMonitoring");
            return this;
        }

        public Builder status(DiscoveredExternalDbSystemComponent.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder associatedComponents(List<AssociatedComponent> associatedComponents) {
            this.associatedComponents = associatedComponents;
            this.__explicitlySet__.add("associatedComponents");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder containerDatabaseId(String containerDatabaseId) {
            this.containerDatabaseId = containerDatabaseId;
            this.__explicitlySet__.add("containerDatabaseId");
            return this;
        }

        public Builder guid(String guid) {
            this.guid = guid;
            this.__explicitlySet__.add("guid");
            return this;
        }

        public Builder connector(ExternalDbSystemDiscoveryConnector connector) {
            this.connector = connector;
            this.__explicitlySet__.add("connector");
            return this;
        }

        public DiscoveredExternalPluggableDatabase build() {
            DiscoveredExternalPluggableDatabase model = new DiscoveredExternalPluggableDatabase(this.componentId, this.displayName, this.componentName, this.resourceId, this.isSelectedForMonitoring, this.status, this.associatedComponents, this.compartmentId, this.containerDatabaseId, this.guid, this.connector);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveredExternalPluggableDatabase model) {
            if (model.wasPropertyExplicitlySet("componentId")) {
                this.componentId(model.getComponentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("componentName")) {
                this.componentName(model.getComponentName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("isSelectedForMonitoring")) {
                this.isSelectedForMonitoring(model.getIsSelectedForMonitoring());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("associatedComponents")) {
                this.associatedComponents(model.getAssociatedComponents());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("containerDatabaseId")) {
                this.containerDatabaseId(model.getContainerDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("guid")) {
                this.guid(model.getGuid());
            }
            if (model.wasPropertyExplicitlySet("connector")) {
                this.connector(model.getConnector());
            }
            return this;
        }
    }
}

