/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDatabaseManagementConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalDbSystem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dbSystemDiscoveryId")
    private final String dbSystemDiscoveryId;
    @JsonProperty(value="discoveryAgentId")
    private final String discoveryAgentId;
    @JsonProperty(value="isCluster")
    private final Boolean isCluster;
    @JsonProperty(value="homeDirectory")
    private final String homeDirectory;
    @JsonProperty(value="databaseManagementConfig")
    private final ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "dbSystemDiscoveryId", "discoveryAgentId", "isCluster", "homeDirectory", "databaseManagementConfig", "lifecycleState", "lifecycleDetails", "timeCreated", "timeUpdated"})
    public ExternalDbSystem(String id, String displayName, String compartmentId, String dbSystemDiscoveryId, String discoveryAgentId, Boolean isCluster, String homeDirectory, ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig, LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.dbSystemDiscoveryId = dbSystemDiscoveryId;
        this.discoveryAgentId = discoveryAgentId;
        this.isCluster = isCluster;
        this.homeDirectory = homeDirectory;
        this.databaseManagementConfig = databaseManagementConfig;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbSystemDiscoveryId() {
        return this.dbSystemDiscoveryId;
    }

    public String getDiscoveryAgentId() {
        return this.discoveryAgentId;
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public ExternalDbSystemDatabaseManagementConfigDetails getDatabaseManagementConfig() {
        return this.databaseManagementConfig;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalDbSystem(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dbSystemDiscoveryId=").append(String.valueOf(this.dbSystemDiscoveryId));
        sb.append(", discoveryAgentId=").append(String.valueOf(this.discoveryAgentId));
        sb.append(", isCluster=").append(String.valueOf(this.isCluster));
        sb.append(", homeDirectory=").append(String.valueOf(this.homeDirectory));
        sb.append(", databaseManagementConfig=").append(String.valueOf((Object)this.databaseManagementConfig));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalDbSystem)) {
            return false;
        }
        ExternalDbSystem other = (ExternalDbSystem)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dbSystemDiscoveryId, other.dbSystemDiscoveryId) && Objects.equals(this.discoveryAgentId, other.discoveryAgentId) && Objects.equals(this.isCluster, other.isCluster) && Objects.equals(this.homeDirectory, other.homeDirectory) && Objects.equals((Object)this.databaseManagementConfig, (Object)other.databaseManagementConfig) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dbSystemDiscoveryId == null ? 43 : this.dbSystemDiscoveryId.hashCode());
        result = result * 59 + (this.discoveryAgentId == null ? 43 : this.discoveryAgentId.hashCode());
        result = result * 59 + (this.isCluster == null ? 43 : this.isCluster.hashCode());
        result = result * 59 + (this.homeDirectory == null ? 43 : this.homeDirectory.hashCode());
        result = result * 59 + (this.databaseManagementConfig == null ? 43 : this.databaseManagementConfig.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Inactive("INACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dbSystemDiscoveryId")
        private String dbSystemDiscoveryId;
        @JsonProperty(value="discoveryAgentId")
        private String discoveryAgentId;
        @JsonProperty(value="isCluster")
        private Boolean isCluster;
        @JsonProperty(value="homeDirectory")
        private String homeDirectory;
        @JsonProperty(value="databaseManagementConfig")
        private ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dbSystemDiscoveryId(String dbSystemDiscoveryId) {
            this.dbSystemDiscoveryId = dbSystemDiscoveryId;
            this.__explicitlySet__.add("dbSystemDiscoveryId");
            return this;
        }

        public Builder discoveryAgentId(String discoveryAgentId) {
            this.discoveryAgentId = discoveryAgentId;
            this.__explicitlySet__.add("discoveryAgentId");
            return this;
        }

        public Builder isCluster(Boolean isCluster) {
            this.isCluster = isCluster;
            this.__explicitlySet__.add("isCluster");
            return this;
        }

        public Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            this.__explicitlySet__.add("homeDirectory");
            return this;
        }

        public Builder databaseManagementConfig(ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig) {
            this.databaseManagementConfig = databaseManagementConfig;
            this.__explicitlySet__.add("databaseManagementConfig");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public ExternalDbSystem build() {
            ExternalDbSystem model = new ExternalDbSystem(this.id, this.displayName, this.compartmentId, this.dbSystemDiscoveryId, this.discoveryAgentId, this.isCluster, this.homeDirectory, this.databaseManagementConfig, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalDbSystem model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemDiscoveryId")) {
                this.dbSystemDiscoveryId(model.getDbSystemDiscoveryId());
            }
            if (model.wasPropertyExplicitlySet("discoveryAgentId")) {
                this.discoveryAgentId(model.getDiscoveryAgentId());
            }
            if (model.wasPropertyExplicitlySet("isCluster")) {
                this.isCluster(model.getIsCluster());
            }
            if (model.wasPropertyExplicitlySet("homeDirectory")) {
                this.homeDirectory(model.getHomeDirectory());
            }
            if (model.wasPropertyExplicitlySet("databaseManagementConfig")) {
                this.databaseManagementConfig(model.getDatabaseManagementConfig());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

