/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseCredential;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType")
@JsonFilter(value="explicitlySetFilter")
public final class ManagedDatabaseSecretCredential
extends ManagedDatabaseCredential {
    @JsonProperty(value="passwordSecretId")
    private final String passwordSecretId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ManagedDatabaseSecretCredential(String username, ManagedDatabaseCredential.Role role, String passwordSecretId) {
        super(username, role);
        this.passwordSecretId = passwordSecretId;
    }

    public String getPasswordSecretId() {
        return this.passwordSecretId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedDatabaseSecretCredential(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", passwordSecretId=").append(String.valueOf(this.passwordSecretId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedDatabaseSecretCredential)) {
            return false;
        }
        ManagedDatabaseSecretCredential other = (ManagedDatabaseSecretCredential)((Object)o);
        return Objects.equals(this.passwordSecretId, other.passwordSecretId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.passwordSecretId == null ? 43 : this.passwordSecretId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="role")
        private ManagedDatabaseCredential.Role role;
        @JsonProperty(value="passwordSecretId")
        private String passwordSecretId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder role(ManagedDatabaseCredential.Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder passwordSecretId(String passwordSecretId) {
            this.passwordSecretId = passwordSecretId;
            this.__explicitlySet__.add("passwordSecretId");
            return this;
        }

        public ManagedDatabaseSecretCredential build() {
            ManagedDatabaseSecretCredential model = new ManagedDatabaseSecretCredential(this.username, this.role, this.passwordSecretId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedDatabaseSecretCredential model) {
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("passwordSecretId")) {
                this.passwordSecretId(model.getPasswordSecretId());
            }
            return this;
        }
    }
}

