/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDimensionDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MetricStatisticsDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="min")
    private final Double min;
    @JsonProperty(value="max")
    private final Double max;
    @JsonProperty(value="median")
    private final Double median;
    @JsonProperty(value="lowerQuartile")
    private final Double lowerQuartile;
    @JsonProperty(value="upperQuartile")
    private final Double upperQuartile;
    @JsonProperty(value="unit")
    private final String unit;
    @JsonProperty(value="dimensions")
    private final List<MetricDimensionDefinition> dimensions;

    @Deprecated
    @ConstructorProperties(value={"min", "max", "median", "lowerQuartile", "upperQuartile", "unit", "dimensions"})
    public MetricStatisticsDefinition(Double min, Double max, Double median, Double lowerQuartile, Double upperQuartile, String unit, List<MetricDimensionDefinition> dimensions) {
        this.min = min;
        this.max = max;
        this.median = median;
        this.lowerQuartile = lowerQuartile;
        this.upperQuartile = upperQuartile;
        this.unit = unit;
        this.dimensions = dimensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getMedian() {
        return this.median;
    }

    public Double getLowerQuartile() {
        return this.lowerQuartile;
    }

    public Double getUpperQuartile() {
        return this.upperQuartile;
    }

    public String getUnit() {
        return this.unit;
    }

    public List<MetricDimensionDefinition> getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricStatisticsDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("min=").append(String.valueOf(this.min));
        sb.append(", max=").append(String.valueOf(this.max));
        sb.append(", median=").append(String.valueOf(this.median));
        sb.append(", lowerQuartile=").append(String.valueOf(this.lowerQuartile));
        sb.append(", upperQuartile=").append(String.valueOf(this.upperQuartile));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricStatisticsDefinition)) {
            return false;
        }
        MetricStatisticsDefinition other = (MetricStatisticsDefinition)((Object)o);
        return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.median, other.median) && Objects.equals(this.lowerQuartile, other.lowerQuartile) && Objects.equals(this.upperQuartile, other.upperQuartile) && Objects.equals(this.unit, other.unit) && Objects.equals(this.dimensions, other.dimensions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.min == null ? 43 : this.min.hashCode());
        result = result * 59 + (this.max == null ? 43 : this.max.hashCode());
        result = result * 59 + (this.median == null ? 43 : this.median.hashCode());
        result = result * 59 + (this.lowerQuartile == null ? 43 : this.lowerQuartile.hashCode());
        result = result * 59 + (this.upperQuartile == null ? 43 : this.upperQuartile.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="min")
        private Double min;
        @JsonProperty(value="max")
        private Double max;
        @JsonProperty(value="median")
        private Double median;
        @JsonProperty(value="lowerQuartile")
        private Double lowerQuartile;
        @JsonProperty(value="upperQuartile")
        private Double upperQuartile;
        @JsonProperty(value="unit")
        private String unit;
        @JsonProperty(value="dimensions")
        private List<MetricDimensionDefinition> dimensions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder min(Double min) {
            this.min = min;
            this.__explicitlySet__.add("min");
            return this;
        }

        public Builder max(Double max) {
            this.max = max;
            this.__explicitlySet__.add("max");
            return this;
        }

        public Builder median(Double median) {
            this.median = median;
            this.__explicitlySet__.add("median");
            return this;
        }

        public Builder lowerQuartile(Double lowerQuartile) {
            this.lowerQuartile = lowerQuartile;
            this.__explicitlySet__.add("lowerQuartile");
            return this;
        }

        public Builder upperQuartile(Double upperQuartile) {
            this.upperQuartile = upperQuartile;
            this.__explicitlySet__.add("upperQuartile");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder dimensions(List<MetricDimensionDefinition> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public MetricStatisticsDefinition build() {
            MetricStatisticsDefinition model = new MetricStatisticsDefinition(this.min, this.max, this.median, this.lowerQuartile, this.upperQuartile, this.unit, this.dimensions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MetricStatisticsDefinition model) {
            if (model.wasPropertyExplicitlySet("min")) {
                this.min(model.getMin());
            }
            if (model.wasPropertyExplicitlySet("max")) {
                this.max(model.getMax());
            }
            if (model.wasPropertyExplicitlySet("median")) {
                this.median(model.getMedian());
            }
            if (model.wasPropertyExplicitlySet("lowerQuartile")) {
                this.lowerQuartile(model.getLowerQuartile());
            }
            if (model.wasPropertyExplicitlySet("upperQuartile")) {
                this.upperQuartile(model.getUpperQuartile());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            return this;
        }
    }
}

