/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.WorkRequestResourceActionType;
import com.oracle.bmc.databasemanagement.model.WorkRequestSubResource;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="actionType")
    private final WorkRequestResourceActionType actionType;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="entityUri")
    private final String entityUri;
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="entityDependencies")
    private final List<WorkRequestSubResource> entityDependencies;

    @Deprecated
    @ConstructorProperties(value={"entityType", "actionType", "identifier", "entityUri", "entityName", "entityDependencies"})
    public WorkRequestResource(String entityType, WorkRequestResourceActionType actionType, String identifier, String entityUri, String entityName, List<WorkRequestSubResource> entityDependencies) {
        this.entityType = entityType;
        this.actionType = actionType;
        this.identifier = identifier;
        this.entityUri = entityUri;
        this.entityName = entityName;
        this.entityDependencies = entityDependencies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public WorkRequestResourceActionType getActionType() {
        return this.actionType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getEntityUri() {
        return this.entityUri;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public List<WorkRequestSubResource> getEntityDependencies() {
        return this.entityDependencies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestResource(");
        sb.append("super=").append(super.toString());
        sb.append("entityType=").append(String.valueOf(this.entityType));
        sb.append(", actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", entityUri=").append(String.valueOf(this.entityUri));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(", entityDependencies=").append(String.valueOf(this.entityDependencies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestResource)) {
            return false;
        }
        WorkRequestResource other = (WorkRequestResource)((Object)o);
        return Objects.equals(this.entityType, other.entityType) && Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.entityUri, other.entityUri) && Objects.equals(this.entityName, other.entityName) && Objects.equals(this.entityDependencies, other.entityDependencies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.entityUri == null ? 43 : this.entityUri.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.entityDependencies == null ? 43 : this.entityDependencies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="actionType")
        private WorkRequestResourceActionType actionType;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="entityUri")
        private String entityUri;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="entityDependencies")
        private List<WorkRequestSubResource> entityDependencies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder actionType(WorkRequestResourceActionType actionType) {
            this.actionType = actionType;
            this.__explicitlySet__.add("actionType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder entityUri(String entityUri) {
            this.entityUri = entityUri;
            this.__explicitlySet__.add("entityUri");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder entityDependencies(List<WorkRequestSubResource> entityDependencies) {
            this.entityDependencies = entityDependencies;
            this.__explicitlySet__.add("entityDependencies");
            return this;
        }

        public WorkRequestResource build() {
            WorkRequestResource model = new WorkRequestResource(this.entityType, this.actionType, this.identifier, this.entityUri, this.entityName, this.entityDependencies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResource model) {
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("actionType")) {
                this.actionType(model.getActionType());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("entityUri")) {
                this.entityUri(model.getEntityUri());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("entityDependencies")) {
                this.entityDependencies(model.getEntityDependencies());
            }
            return this;
        }
    }
}

