/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalExadataInfrastructureRequest
extends BmcRequest<Void> {
    private String externalExadataInfrastructureId;
    private String opcRequestId;

    public String getExternalExadataInfrastructureId() {
        return this.externalExadataInfrastructureId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalExadataInfrastructureId(this.externalExadataInfrastructureId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalExadataInfrastructureId=").append(String.valueOf(this.externalExadataInfrastructureId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalExadataInfrastructureRequest)) {
            return false;
        }
        GetExternalExadataInfrastructureRequest other = (GetExternalExadataInfrastructureRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalExadataInfrastructureId, other.externalExadataInfrastructureId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalExadataInfrastructureId == null ? 43 : this.externalExadataInfrastructureId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalExadataInfrastructureRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalExadataInfrastructureId = null;
        private String opcRequestId = null;

        public Builder externalExadataInfrastructureId(String externalExadataInfrastructureId) {
            this.externalExadataInfrastructureId = externalExadataInfrastructureId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalExadataInfrastructureRequest o) {
            this.externalExadataInfrastructureId(o.getExternalExadataInfrastructureId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalExadataInfrastructureRequest build() {
            GetExternalExadataInfrastructureRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalExadataInfrastructureRequest buildWithoutInvocationCallback() {
            GetExternalExadataInfrastructureRequest request = new GetExternalExadataInfrastructureRequest();
            request.externalExadataInfrastructureId = this.externalExadataInfrastructureId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

