/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SummarizeAwrDbCpuUsagesRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String awrDbId;
    private String instNum;
    private Integer beginSnIdGreaterThanOrEqualTo;
    private Integer endSnIdLessThanOrEqualTo;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private SessionType sessionType;
    private Integer containerId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getAwrDbId() {
        return this.awrDbId;
    }

    public String getInstNum() {
        return this.instNum;
    }

    public Integer getBeginSnIdGreaterThanOrEqualTo() {
        return this.beginSnIdGreaterThanOrEqualTo;
    }

    public Integer getEndSnIdLessThanOrEqualTo() {
        return this.endSnIdLessThanOrEqualTo;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public Integer getContainerId() {
        return this.containerId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).awrDbId(this.awrDbId).instNum(this.instNum).beginSnIdGreaterThanOrEqualTo(this.beginSnIdGreaterThanOrEqualTo).endSnIdLessThanOrEqualTo(this.endSnIdLessThanOrEqualTo).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).sessionType(this.sessionType).containerId(this.containerId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",awrDbId=").append(String.valueOf(this.awrDbId));
        sb.append(",instNum=").append(String.valueOf(this.instNum));
        sb.append(",beginSnIdGreaterThanOrEqualTo=").append(String.valueOf(this.beginSnIdGreaterThanOrEqualTo));
        sb.append(",endSnIdLessThanOrEqualTo=").append(String.valueOf(this.endSnIdLessThanOrEqualTo));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",sessionType=").append(String.valueOf((Object)this.sessionType));
        sb.append(",containerId=").append(String.valueOf(this.containerId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeAwrDbCpuUsagesRequest)) {
            return false;
        }
        SummarizeAwrDbCpuUsagesRequest other = (SummarizeAwrDbCpuUsagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.awrDbId, other.awrDbId) && Objects.equals(this.instNum, other.instNum) && Objects.equals(this.beginSnIdGreaterThanOrEqualTo, other.beginSnIdGreaterThanOrEqualTo) && Objects.equals(this.endSnIdLessThanOrEqualTo, other.endSnIdLessThanOrEqualTo) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals((Object)this.sessionType, (Object)other.sessionType) && Objects.equals(this.containerId, other.containerId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.awrDbId == null ? 43 : this.awrDbId.hashCode());
        result = result * 59 + (this.instNum == null ? 43 : this.instNum.hashCode());
        result = result * 59 + (this.beginSnIdGreaterThanOrEqualTo == null ? 43 : this.beginSnIdGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endSnIdLessThanOrEqualTo == null ? 43 : this.endSnIdLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.sessionType == null ? 43 : this.sessionType.hashCode());
        result = result * 59 + (this.containerId == null ? 43 : this.containerId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeAwrDbCpuUsagesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String awrDbId = null;
        private String instNum = null;
        private Integer beginSnIdGreaterThanOrEqualTo = null;
        private Integer endSnIdLessThanOrEqualTo = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private SessionType sessionType = null;
        private Integer containerId = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder awrDbId(String awrDbId) {
            this.awrDbId = awrDbId;
            return this;
        }

        public Builder instNum(String instNum) {
            this.instNum = instNum;
            return this;
        }

        public Builder beginSnIdGreaterThanOrEqualTo(Integer beginSnIdGreaterThanOrEqualTo) {
            this.beginSnIdGreaterThanOrEqualTo = beginSnIdGreaterThanOrEqualTo;
            return this;
        }

        public Builder endSnIdLessThanOrEqualTo(Integer endSnIdLessThanOrEqualTo) {
            this.endSnIdLessThanOrEqualTo = endSnIdLessThanOrEqualTo;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder sessionType(SessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder containerId(Integer containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeAwrDbCpuUsagesRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.awrDbId(o.getAwrDbId());
            this.instNum(o.getInstNum());
            this.beginSnIdGreaterThanOrEqualTo(o.getBeginSnIdGreaterThanOrEqualTo());
            this.endSnIdLessThanOrEqualTo(o.getEndSnIdLessThanOrEqualTo());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.sessionType(o.getSessionType());
            this.containerId(o.getContainerId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeAwrDbCpuUsagesRequest build() {
            SummarizeAwrDbCpuUsagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeAwrDbCpuUsagesRequest buildWithoutInvocationCallback() {
            SummarizeAwrDbCpuUsagesRequest request = new SummarizeAwrDbCpuUsagesRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.awrDbId = this.awrDbId;
            request.instNum = this.instNum;
            request.beginSnIdGreaterThanOrEqualTo = this.beginSnIdGreaterThanOrEqualTo;
            request.endSnIdLessThanOrEqualTo = this.endSnIdLessThanOrEqualTo;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.sessionType = this.sessionType;
            request.containerId = this.containerId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeSampled("TIME_SAMPLED"),
        AvgValue("AVG_VALUE");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SessionType implements BmcEnum
    {
        Foreground("FOREGROUND"),
        Background("BACKGROUND"),
        All("ALL");

        private final String value;
        private static Map<String, SessionType> map;

        private SessionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SessionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SessionType: " + key);
        }

        static {
            map = new HashMap<String, SessionType>();
            for (SessionType v : SessionType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

