/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.SqlTuning;
import com.oracle.bmc.databasemanagement.SqlTuningPaginators;
import com.oracle.bmc.databasemanagement.model.ExecutionPlanStatsComparision;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskFindingCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskRecommendationCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskSqlExecutionPlan;
import com.oracle.bmc.databasemanagement.model.SqlTuningAdvisorTaskSummaryReport;
import com.oracle.bmc.databasemanagement.model.SqlTuningSet;
import com.oracle.bmc.databasemanagement.model.SqlTuningSetAdminActionStatus;
import com.oracle.bmc.databasemanagement.model.SqlTuningSetCollection;
import com.oracle.bmc.databasemanagement.model.SqlTuningTaskReturn;
import com.oracle.bmc.databasemanagement.requests.CloneSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.CreateSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlsInSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.FetchSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.GetExecutionPlanStatsComparisionRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlExecutionPlanRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlTuningAdvisorTaskSummaryReportRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTaskFindingsRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTaskRecommendationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningAdvisorTasksRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlTuningSetsRequest;
import com.oracle.bmc.databasemanagement.requests.LoadSqlTuningSetRequest;
import com.oracle.bmc.databasemanagement.requests.SaveSqlTuningSetAsRequest;
import com.oracle.bmc.databasemanagement.requests.StartSqlTuningTaskRequest;
import com.oracle.bmc.databasemanagement.requests.ValidateBasicFilterRequest;
import com.oracle.bmc.databasemanagement.responses.CloneSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.CreateSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlsInSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.FetchSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.GetExecutionPlanStatsComparisionResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlExecutionPlanResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlTuningAdvisorTaskSummaryReportResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTaskFindingsResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTaskRecommendationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningAdvisorTasksResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlTuningSetsResponse;
import com.oracle.bmc.databasemanagement.responses.LoadSqlTuningSetResponse;
import com.oracle.bmc.databasemanagement.responses.SaveSqlTuningSetAsResponse;
import com.oracle.bmc.databasemanagement.responses.StartSqlTuningTaskResponse;
import com.oracle.bmc.databasemanagement.responses.ValidateBasicFilterResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTuningClient
extends BaseSyncClient
implements SqlTuning {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SQLTUNING").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SqlTuningClient.class);
    private final SqlTuningPaginators paginators = new SqlTuningPaginators(this);

    SqlTuningClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CloneSqlTuningTaskResponse cloneSqlTuningTask(CloneSqlTuningTaskRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCloneSqlTuningTaskDetails(), "cloneSqlTuningTaskDetails is required");
        return (CloneSqlTuningTaskResponse)this.clientCall(request, CloneSqlTuningTaskResponse::builder).logger(LOG, "cloneSqlTuningTask").serviceDetails("SqlTuning", "CloneSqlTuningTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/CloneSqlTuningTask").method(Method.POST).requestBuilder(CloneSqlTuningTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("cloneSqlTuningTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningTaskReturn.class, CloneSqlTuningTaskResponse.Builder::sqlTuningTaskReturn).handleResponseHeaderString("opc-request-id", CloneSqlTuningTaskResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSqlTuningSetResponse createSqlTuningSet(CreateSqlTuningSetRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateSqlTuningSetDetails(), "createSqlTuningSetDetails is required");
        return (CreateSqlTuningSetResponse)this.clientCall(request, CreateSqlTuningSetResponse::builder).logger(LOG, "createSqlTuningSet").serviceDetails("SqlTuning", "CreateSqlTuningSet", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SqlTuningSet/CreateSqlTuningSet").method(Method.POST).requestBuilder(CreateSqlTuningSetRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningSet.class, CreateSqlTuningSetResponse.Builder::sqlTuningSet).handleResponseHeaderString("opc-request-id", CreateSqlTuningSetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DropSqlTuningSetResponse dropSqlTuningSet(DropSqlTuningSetRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDropSqlTuningSetDetails(), "dropSqlTuningSetDetails is required");
        return (DropSqlTuningSetResponse)this.clientCall(request, DropSqlTuningSetResponse::builder).logger(LOG, "dropSqlTuningSet").serviceDetails("SqlTuning", "DropSqlTuningSet", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SqlTuningSet/DropSqlTuningSet").method(Method.POST).requestBuilder(DropSqlTuningSetRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendPathParam((Number)request.getSqlTuningSetId()).appendPathParam("actions").appendPathParam("dropSqlTuningSet").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningSetAdminActionStatus.class, DropSqlTuningSetResponse.Builder::sqlTuningSetAdminActionStatus).handleResponseHeaderString("opc-request-id", DropSqlTuningSetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DropSqlTuningTaskResponse dropSqlTuningTask(DropSqlTuningTaskRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDropSqlTuningTaskDetails(), "dropSqlTuningTaskDetails is required");
        return (DropSqlTuningTaskResponse)this.clientCall(request, DropSqlTuningTaskResponse::builder).logger(LOG, "dropSqlTuningTask").serviceDetails("SqlTuning", "DropSqlTuningTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DropSqlTuningTask").method(Method.POST).requestBuilder(DropSqlTuningTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("dropSqlTuningTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DropSqlTuningTaskResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DropSqlsInSqlTuningSetResponse dropSqlsInSqlTuningSet(DropSqlsInSqlTuningSetRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDropSqlsInSqlTuningSetDetails(), "dropSqlsInSqlTuningSetDetails is required");
        return (DropSqlsInSqlTuningSetResponse)this.clientCall(request, DropSqlsInSqlTuningSetResponse::builder).logger(LOG, "dropSqlsInSqlTuningSet").serviceDetails("SqlTuning", "DropSqlsInSqlTuningSet", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SqlTuningSet/DropSqlsInSqlTuningSet").method(Method.POST).requestBuilder(DropSqlsInSqlTuningSetRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendPathParam((Number)request.getSqlTuningSetId()).appendPathParam("actions").appendPathParam("dropSqlsInSqlTuningSet").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningSetAdminActionStatus.class, DropSqlsInSqlTuningSetResponse.Builder::sqlTuningSetAdminActionStatus).handleResponseHeaderString("opc-request-id", DropSqlsInSqlTuningSetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public FetchSqlTuningSetResponse fetchSqlTuningSet(FetchSqlTuningSetRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getFetchSqlTuningSetDetails(), "fetchSqlTuningSetDetails is required");
        return (FetchSqlTuningSetResponse)this.clientCall(request, FetchSqlTuningSetResponse::builder).logger(LOG, "fetchSqlTuningSet").serviceDetails("SqlTuning", "FetchSqlTuningSet", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SqlTuningSet/FetchSqlTuningSet").method(Method.POST).requestBuilder(FetchSqlTuningSetRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendPathParam((Number)request.getSqlTuningSetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningSet.class, FetchSqlTuningSetResponse.Builder::sqlTuningSet).handleResponseHeaderString("opc-request-id", FetchSqlTuningSetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetExecutionPlanStatsComparisionResponse getExecutionPlanStatsComparision(GetExecutionPlanStatsComparisionRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlObjectId(), "sqlObjectId is required");
        Objects.requireNonNull(request.getExecutionId(), "executionId is required");
        return (GetExecutionPlanStatsComparisionResponse)this.clientCall(request, GetExecutionPlanStatsComparisionResponse::builder).logger(LOG, "getExecutionPlanStatsComparision").serviceDetails("SqlTuning", "GetExecutionPlanStatsComparision", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetExecutionPlanStatsComparision").method(Method.GET).requestBuilder(GetExecutionPlanStatsComparisionRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("executionPlanStatsComparision").appendQueryParam("sqlObjectId", (Object)request.getSqlObjectId()).appendQueryParam("executionId", (Object)request.getExecutionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExecutionPlanStatsComparision.class, GetExecutionPlanStatsComparisionResponse.Builder::executionPlanStatsComparision).handleResponseHeaderString("opc-request-id", GetExecutionPlanStatsComparisionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSqlExecutionPlanResponse getSqlExecutionPlan(GetSqlExecutionPlanRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlObjectId(), "sqlObjectId is required");
        Objects.requireNonNull(request.getAttribute(), "attribute is required");
        return (GetSqlExecutionPlanResponse)this.clientCall(request, GetSqlExecutionPlanResponse::builder).logger(LOG, "getSqlExecutionPlan").serviceDetails("SqlTuning", "GetSqlExecutionPlan", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetSqlExecutionPlan").method(Method.GET).requestBuilder(GetSqlExecutionPlanRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("sqlExecutionPlan").appendQueryParam("sqlObjectId", (Object)request.getSqlObjectId()).appendEnumQueryParam("attribute", (BmcEnum)request.getAttribute()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskSqlExecutionPlan.class, GetSqlExecutionPlanResponse.Builder::sqlTuningAdvisorTaskSqlExecutionPlan).handleResponseHeaderString("opc-request-id", GetSqlExecutionPlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSqlTuningAdvisorTaskSummaryReportResponse getSqlTuningAdvisorTaskSummaryReport(GetSqlTuningAdvisorTaskSummaryReportRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (GetSqlTuningAdvisorTaskSummaryReportResponse)this.clientCall(request, GetSqlTuningAdvisorTaskSummaryReportResponse::builder).logger(LOG, "getSqlTuningAdvisorTaskSummaryReport").serviceDetails("SqlTuning", "GetSqlTuningAdvisorTaskSummaryReport", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetSqlTuningAdvisorTaskSummaryReport").method(Method.GET).requestBuilder(GetSqlTuningAdvisorTaskSummaryReportRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("summaryReport").appendEnumQueryParam("searchPeriod", (BmcEnum)request.getSearchPeriod()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("beginExecIdGreaterThanOrEqualTo", (Object)request.getBeginExecIdGreaterThanOrEqualTo()).appendQueryParam("endExecIdLessThanOrEqualTo", (Object)request.getEndExecIdLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskSummaryReport.class, GetSqlTuningAdvisorTaskSummaryReportResponse.Builder::sqlTuningAdvisorTaskSummaryReport).handleResponseHeaderString("opc-request-id", GetSqlTuningAdvisorTaskSummaryReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSqlTuningAdvisorTaskFindingsResponse listSqlTuningAdvisorTaskFindings(ListSqlTuningAdvisorTaskFindingsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListSqlTuningAdvisorTaskFindingsResponse)this.clientCall(request, ListSqlTuningAdvisorTaskFindingsResponse::builder).logger(LOG, "listSqlTuningAdvisorTaskFindings").serviceDetails("SqlTuning", "ListSqlTuningAdvisorTaskFindings", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningAdvisorTaskFindings").method(Method.GET).requestBuilder(ListSqlTuningAdvisorTaskFindingsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("findings").appendQueryParam("beginExecId", (Object)request.getBeginExecId()).appendQueryParam("endExecId", (Object)request.getEndExecId()).appendEnumQueryParam("searchPeriod", (BmcEnum)request.getSearchPeriod()).appendEnumQueryParam("findingFilter", (BmcEnum)request.getFindingFilter()).appendQueryParam("statsHashFilter", (Object)request.getStatsHashFilter()).appendQueryParam("indexHashFilter", (Object)request.getIndexHashFilter()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskFindingCollection.class, ListSqlTuningAdvisorTaskFindingsResponse.Builder::sqlTuningAdvisorTaskFindingCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningAdvisorTaskFindingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningAdvisorTaskFindingsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSqlTuningAdvisorTaskRecommendationsResponse listSqlTuningAdvisorTaskRecommendations(ListSqlTuningAdvisorTaskRecommendationsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlObjectId(), "sqlObjectId is required");
        Objects.requireNonNull(request.getExecutionId(), "executionId is required");
        return (ListSqlTuningAdvisorTaskRecommendationsResponse)this.clientCall(request, ListSqlTuningAdvisorTaskRecommendationsResponse::builder).logger(LOG, "listSqlTuningAdvisorTaskRecommendations").serviceDetails("SqlTuning", "ListSqlTuningAdvisorTaskRecommendations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningAdvisorTaskRecommendations").method(Method.GET).requestBuilder(ListSqlTuningAdvisorTaskRecommendationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendPathParam((Number)request.getSqlTuningAdvisorTaskId()).appendPathParam("recommendations").appendQueryParam("sqlObjectId", (Object)request.getSqlObjectId()).appendQueryParam("executionId", (Object)request.getExecutionId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskRecommendationCollection.class, ListSqlTuningAdvisorTaskRecommendationsResponse.Builder::sqlTuningAdvisorTaskRecommendationCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningAdvisorTaskRecommendationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningAdvisorTaskRecommendationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSqlTuningAdvisorTasksResponse listSqlTuningAdvisorTasks(ListSqlTuningAdvisorTasksRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListSqlTuningAdvisorTasksResponse)this.clientCall(request, ListSqlTuningAdvisorTasksResponse::builder).logger(LOG, "listSqlTuningAdvisorTasks").serviceDetails("SqlTuning", "ListSqlTuningAdvisorTasks", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningAdvisorTasks").method(Method.GET).requestBuilder(ListSqlTuningAdvisorTasksRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningAdvisorTasks").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningAdvisorTaskCollection.class, ListSqlTuningAdvisorTasksResponse.Builder::sqlTuningAdvisorTaskCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningAdvisorTasksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningAdvisorTasksResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSqlTuningSetsResponse listSqlTuningSets(ListSqlTuningSetsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ListSqlTuningSetsResponse)this.clientCall(request, ListSqlTuningSetsResponse::builder).logger(LOG, "listSqlTuningSets").serviceDetails("SqlTuning", "ListSqlTuningSets", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlTuningSets").method(Method.GET).requestBuilder(ListSqlTuningSetsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendQueryParam("owner", (Object)request.getOwner()).appendQueryParam("nameContains", (Object)request.getNameContains()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SqlTuningSetCollection.class, ListSqlTuningSetsResponse.Builder::sqlTuningSetCollection).handleResponseHeaderString("opc-request-id", ListSqlTuningSetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlTuningSetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public LoadSqlTuningSetResponse loadSqlTuningSet(LoadSqlTuningSetRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getLoadSqlTuningSetDetails(), "loadSqlTuningSetDetails is required");
        return (LoadSqlTuningSetResponse)this.clientCall(request, LoadSqlTuningSetResponse::builder).logger(LOG, "loadSqlTuningSet").serviceDetails("SqlTuning", "LoadSqlTuningSet", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SqlTuningSet/LoadSqlTuningSet").method(Method.POST).requestBuilder(LoadSqlTuningSetRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendPathParam((Number)request.getSqlTuningSetId()).appendPathParam("actions").appendPathParam("loadSqlTuningSet").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningSetAdminActionStatus.class, LoadSqlTuningSetResponse.Builder::sqlTuningSetAdminActionStatus).handleResponseHeaderString("opc-request-id", LoadSqlTuningSetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SaveSqlTuningSetAsResponse saveSqlTuningSetAs(SaveSqlTuningSetAsRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSaveSqlTuningSetAsDetails(), "saveSqlTuningSetAsDetails is required");
        return (SaveSqlTuningSetAsResponse)this.clientCall(request, SaveSqlTuningSetAsResponse::builder).logger(LOG, "saveSqlTuningSetAs").serviceDetails("SqlTuning", "SaveSqlTuningSetAs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SqlTuningSet/SaveSqlTuningSetAs").method(Method.POST).requestBuilder(SaveSqlTuningSetAsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendPathParam((Number)request.getSqlTuningSetId()).appendPathParam("actions").appendPathParam("saveAs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningSetAdminActionStatus.class, SaveSqlTuningSetAsResponse.Builder::sqlTuningSetAdminActionStatus).handleResponseHeaderString("opc-request-id", SaveSqlTuningSetAsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public StartSqlTuningTaskResponse startSqlTuningTask(StartSqlTuningTaskRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartSqlTuningTaskDetails(), "startSqlTuningTaskDetails is required");
        return (StartSqlTuningTaskResponse)this.clientCall(request, StartSqlTuningTaskResponse::builder).logger(LOG, "startSqlTuningTask").serviceDetails("SqlTuning", "StartSqlTuningTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/StartSqlTuningTask").method(Method.POST).requestBuilder(StartSqlTuningTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("startSqlTuningTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningTaskReturn.class, StartSqlTuningTaskResponse.Builder::sqlTuningTaskReturn).handleResponseHeaderString("opc-request-id", StartSqlTuningTaskResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ValidateBasicFilterResponse validateBasicFilter(ValidateBasicFilterRequest request) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getValidateBasicFilterDetails(), "validateBasicFilterDetails is required");
        return (ValidateBasicFilterResponse)this.clientCall(request, ValidateBasicFilterResponse::builder).logger(LOG, "validateBasicFilter").serviceDetails("SqlTuning", "ValidateBasicFilter", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SqlTuningSet/ValidateBasicFilter").method(Method.POST).requestBuilder(ValidateBasicFilterRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlTuningSets").appendPathParam((Number)request.getSqlTuningSetId()).appendPathParam("actions").appendPathParam("validateBasicFilter").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(SqlTuningSetAdminActionStatus.class, ValidateBasicFilterResponse.Builder::sqlTuningSetAdminActionStatus).handleResponseHeaderString("opc-request-id", ValidateBasicFilterResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SqlTuningPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SqlTuningClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SqlTuningClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SqlTuningClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SqlTuningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SqlTuningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SqlTuningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SqlTuningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SqlTuningClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SqlTuningClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SqlTuningClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "databasemanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"databasemanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SqlTuningClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SqlTuningClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

