/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AwrDbWaitEventSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="timeBegin")
    private final Date timeBegin;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="waitsPerSec")
    private final Double waitsPerSec;
    @JsonProperty(value="avgWaitTimePerSec")
    private final Double avgWaitTimePerSec;
    @JsonProperty(value="avgWaitTimePerWait")
    private final Double avgWaitTimePerWait;
    @JsonProperty(value="snapshotId")
    private final Integer snapshotId;

    @Deprecated
    @ConstructorProperties(value={"name", "timeBegin", "timeEnd", "waitsPerSec", "avgWaitTimePerSec", "avgWaitTimePerWait", "snapshotId"})
    public AwrDbWaitEventSummary(String name, Date timeBegin, Date timeEnd, Double waitsPerSec, Double avgWaitTimePerSec, Double avgWaitTimePerWait, Integer snapshotId) {
        this.name = name;
        this.timeBegin = timeBegin;
        this.timeEnd = timeEnd;
        this.waitsPerSec = waitsPerSec;
        this.avgWaitTimePerSec = avgWaitTimePerSec;
        this.avgWaitTimePerWait = avgWaitTimePerWait;
        this.snapshotId = snapshotId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Date getTimeBegin() {
        return this.timeBegin;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Double getWaitsPerSec() {
        return this.waitsPerSec;
    }

    public Double getAvgWaitTimePerSec() {
        return this.avgWaitTimePerSec;
    }

    public Double getAvgWaitTimePerWait() {
        return this.avgWaitTimePerWait;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrDbWaitEventSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", timeBegin=").append(String.valueOf(this.timeBegin));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", waitsPerSec=").append(String.valueOf(this.waitsPerSec));
        sb.append(", avgWaitTimePerSec=").append(String.valueOf(this.avgWaitTimePerSec));
        sb.append(", avgWaitTimePerWait=").append(String.valueOf(this.avgWaitTimePerWait));
        sb.append(", snapshotId=").append(String.valueOf(this.snapshotId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrDbWaitEventSummary)) {
            return false;
        }
        AwrDbWaitEventSummary other = (AwrDbWaitEventSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.timeBegin, other.timeBegin) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.waitsPerSec, other.waitsPerSec) && Objects.equals(this.avgWaitTimePerSec, other.avgWaitTimePerSec) && Objects.equals(this.avgWaitTimePerWait, other.avgWaitTimePerWait) && Objects.equals(this.snapshotId, other.snapshotId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.timeBegin == null ? 43 : this.timeBegin.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.waitsPerSec == null ? 43 : this.waitsPerSec.hashCode());
        result = result * 59 + (this.avgWaitTimePerSec == null ? 43 : this.avgWaitTimePerSec.hashCode());
        result = result * 59 + (this.avgWaitTimePerWait == null ? 43 : this.avgWaitTimePerWait.hashCode());
        result = result * 59 + (this.snapshotId == null ? 43 : this.snapshotId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="timeBegin")
        private Date timeBegin;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="waitsPerSec")
        private Double waitsPerSec;
        @JsonProperty(value="avgWaitTimePerSec")
        private Double avgWaitTimePerSec;
        @JsonProperty(value="avgWaitTimePerWait")
        private Double avgWaitTimePerWait;
        @JsonProperty(value="snapshotId")
        private Integer snapshotId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder timeBegin(Date timeBegin) {
            this.timeBegin = timeBegin;
            this.__explicitlySet__.add("timeBegin");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder waitsPerSec(Double waitsPerSec) {
            this.waitsPerSec = waitsPerSec;
            this.__explicitlySet__.add("waitsPerSec");
            return this;
        }

        public Builder avgWaitTimePerSec(Double avgWaitTimePerSec) {
            this.avgWaitTimePerSec = avgWaitTimePerSec;
            this.__explicitlySet__.add("avgWaitTimePerSec");
            return this;
        }

        public Builder avgWaitTimePerWait(Double avgWaitTimePerWait) {
            this.avgWaitTimePerWait = avgWaitTimePerWait;
            this.__explicitlySet__.add("avgWaitTimePerWait");
            return this;
        }

        public Builder snapshotId(Integer snapshotId) {
            this.snapshotId = snapshotId;
            this.__explicitlySet__.add("snapshotId");
            return this;
        }

        public AwrDbWaitEventSummary build() {
            AwrDbWaitEventSummary model = new AwrDbWaitEventSummary(this.name, this.timeBegin, this.timeEnd, this.waitsPerSec, this.avgWaitTimePerSec, this.avgWaitTimePerWait, this.snapshotId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwrDbWaitEventSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeBegin")) {
                this.timeBegin(model.getTimeBegin());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("waitsPerSec")) {
                this.waitsPerSec(model.getWaitsPerSec());
            }
            if (model.wasPropertyExplicitlySet("avgWaitTimePerSec")) {
                this.avgWaitTimePerSec(model.getAvgWaitTimePerSec());
            }
            if (model.wasPropertyExplicitlySet("avgWaitTimePerWait")) {
                this.avgWaitTimePerWait(model.getAvgWaitTimePerWait());
            }
            if (model.wasPropertyExplicitlySet("snapshotId")) {
                this.snapshotId(model.getSnapshotId());
            }
            return this;
        }
    }
}

