/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DbmResource;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageServerSummary;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalExadataStorageGrid
extends DbmResource {
    @JsonProperty(value="exadataInfrastructureId")
    private final String exadataInfrastructureId;
    @JsonProperty(value="serverCount")
    private final BigDecimal serverCount;
    @JsonProperty(value="storageServers")
    private final List<ExternalExadataStorageServerSummary> storageServers;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalExadataStorageGrid(String id, String displayName, String version, String internalId, String status, DbmResource.LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, String lifecycleDetails, Map<String, String> additionalDetails, String exadataInfrastructureId, BigDecimal serverCount, List<ExternalExadataStorageServerSummary> storageServers) {
        super(id, displayName, version, internalId, status, lifecycleState, timeCreated, timeUpdated, lifecycleDetails, additionalDetails);
        this.exadataInfrastructureId = exadataInfrastructureId;
        this.serverCount = serverCount;
        this.storageServers = storageServers;
    }

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public BigDecimal getServerCount() {
        return this.serverCount;
    }

    public List<ExternalExadataStorageServerSummary> getStorageServers() {
        return this.storageServers;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalExadataStorageGrid(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", exadataInfrastructureId=").append(String.valueOf(this.exadataInfrastructureId));
        sb.append(", serverCount=").append(String.valueOf(this.serverCount));
        sb.append(", storageServers=").append(String.valueOf(this.storageServers));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalExadataStorageGrid)) {
            return false;
        }
        ExternalExadataStorageGrid other = (ExternalExadataStorageGrid)((Object)o);
        return Objects.equals(this.exadataInfrastructureId, other.exadataInfrastructureId) && Objects.equals(this.serverCount, other.serverCount) && Objects.equals(this.storageServers, other.storageServers) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exadataInfrastructureId == null ? 43 : this.exadataInfrastructureId.hashCode());
        result = result * 59 + (this.serverCount == null ? 43 : this.serverCount.hashCode());
        result = result * 59 + (this.storageServers == null ? 43 : this.storageServers.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="internalId")
        private String internalId;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="lifecycleState")
        private DbmResource.LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="additionalDetails")
        private Map<String, String> additionalDetails;
        @JsonProperty(value="exadataInfrastructureId")
        private String exadataInfrastructureId;
        @JsonProperty(value="serverCount")
        private BigDecimal serverCount;
        @JsonProperty(value="storageServers")
        private List<ExternalExadataStorageServerSummary> storageServers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder internalId(String internalId) {
            this.internalId = internalId;
            this.__explicitlySet__.add("internalId");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder lifecycleState(DbmResource.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder additionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.__explicitlySet__.add("additionalDetails");
            return this;
        }

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            this.__explicitlySet__.add("exadataInfrastructureId");
            return this;
        }

        public Builder serverCount(BigDecimal serverCount) {
            this.serverCount = serverCount;
            this.__explicitlySet__.add("serverCount");
            return this;
        }

        public Builder storageServers(List<ExternalExadataStorageServerSummary> storageServers) {
            this.storageServers = storageServers;
            this.__explicitlySet__.add("storageServers");
            return this;
        }

        public ExternalExadataStorageGrid build() {
            ExternalExadataStorageGrid model = new ExternalExadataStorageGrid(this.id, this.displayName, this.version, this.internalId, this.status, this.lifecycleState, this.timeCreated, this.timeUpdated, this.lifecycleDetails, this.additionalDetails, this.exadataInfrastructureId, this.serverCount, this.storageServers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalExadataStorageGrid model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("internalId")) {
                this.internalId(model.getInternalId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("additionalDetails")) {
                this.additionalDetails(model.getAdditionalDetails());
            }
            if (model.wasPropertyExplicitlySet("exadataInfrastructureId")) {
                this.exadataInfrastructureId(model.getExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("serverCount")) {
                this.serverCount(model.getServerCount());
            }
            if (model.wasPropertyExplicitlySet("storageServers")) {
                this.storageServers(model.getStorageServers());
            }
            return this;
        }
    }
}

