/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabasePlan;
import com.oracle.bmc.databasemanagement.model.IormPlanObjectiveEnum;
import com.oracle.bmc.databasemanagement.model.IormPlanStatusEnum;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IormPlan
extends ExplicitlySetBmcModel {
    @JsonProperty(value="planStatus")
    private final IormPlanStatusEnum planStatus;
    @JsonProperty(value="planObjective")
    private final IormPlanObjectiveEnum planObjective;
    @JsonProperty(value="dbPlan")
    private final DatabasePlan dbPlan;

    @Deprecated
    @ConstructorProperties(value={"planStatus", "planObjective", "dbPlan"})
    public IormPlan(IormPlanStatusEnum planStatus, IormPlanObjectiveEnum planObjective, DatabasePlan dbPlan) {
        this.planStatus = planStatus;
        this.planObjective = planObjective;
        this.dbPlan = dbPlan;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public IormPlanStatusEnum getPlanStatus() {
        return this.planStatus;
    }

    public IormPlanObjectiveEnum getPlanObjective() {
        return this.planObjective;
    }

    public DatabasePlan getDbPlan() {
        return this.dbPlan;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IormPlan(");
        sb.append("super=").append(super.toString());
        sb.append("planStatus=").append(String.valueOf((Object)this.planStatus));
        sb.append(", planObjective=").append(String.valueOf((Object)this.planObjective));
        sb.append(", dbPlan=").append(String.valueOf((Object)this.dbPlan));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IormPlan)) {
            return false;
        }
        IormPlan other = (IormPlan)((Object)o);
        return Objects.equals((Object)this.planStatus, (Object)other.planStatus) && Objects.equals((Object)this.planObjective, (Object)other.planObjective) && Objects.equals((Object)this.dbPlan, (Object)other.dbPlan) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.planStatus == null ? 43 : this.planStatus.hashCode());
        result = result * 59 + (this.planObjective == null ? 43 : this.planObjective.hashCode());
        result = result * 59 + (this.dbPlan == null ? 43 : this.dbPlan.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="planStatus")
        private IormPlanStatusEnum planStatus;
        @JsonProperty(value="planObjective")
        private IormPlanObjectiveEnum planObjective;
        @JsonProperty(value="dbPlan")
        private DatabasePlan dbPlan;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder planStatus(IormPlanStatusEnum planStatus) {
            this.planStatus = planStatus;
            this.__explicitlySet__.add("planStatus");
            return this;
        }

        public Builder planObjective(IormPlanObjectiveEnum planObjective) {
            this.planObjective = planObjective;
            this.__explicitlySet__.add("planObjective");
            return this;
        }

        public Builder dbPlan(DatabasePlan dbPlan) {
            this.dbPlan = dbPlan;
            this.__explicitlySet__.add("dbPlan");
            return this;
        }

        public IormPlan build() {
            IormPlan model = new IormPlan(this.planStatus, this.planObjective, this.dbPlan);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IormPlan model) {
            if (model.wasPropertyExplicitlySet("planStatus")) {
                this.planStatus(model.getPlanStatus());
            }
            if (model.wasPropertyExplicitlySet("planObjective")) {
                this.planObjective(model.getPlanObjective());
            }
            if (model.wasPropertyExplicitlySet("dbPlan")) {
                this.dbPlan(model.getDbPlan());
            }
            return this;
        }
    }
}

