/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DbManagementAnalyticsMetric;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MetricsAggregationRange
extends ExplicitlySetBmcModel {
    @JsonProperty(value="header")
    private final DbManagementAnalyticsMetric header;
    @JsonProperty(value="metrics")
    private final List<DbManagementAnalyticsMetric> metrics;
    @JsonProperty(value="rangeStartTimeInEpochSeconds")
    private final Long rangeStartTimeInEpochSeconds;
    @JsonProperty(value="rangeEndTimeInEpochSeconds")
    private final Long rangeEndTimeInEpochSeconds;

    @Deprecated
    @ConstructorProperties(value={"header", "metrics", "rangeStartTimeInEpochSeconds", "rangeEndTimeInEpochSeconds"})
    public MetricsAggregationRange(DbManagementAnalyticsMetric header, List<DbManagementAnalyticsMetric> metrics, Long rangeStartTimeInEpochSeconds, Long rangeEndTimeInEpochSeconds) {
        this.header = header;
        this.metrics = metrics;
        this.rangeStartTimeInEpochSeconds = rangeStartTimeInEpochSeconds;
        this.rangeEndTimeInEpochSeconds = rangeEndTimeInEpochSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DbManagementAnalyticsMetric getHeader() {
        return this.header;
    }

    public List<DbManagementAnalyticsMetric> getMetrics() {
        return this.metrics;
    }

    public Long getRangeStartTimeInEpochSeconds() {
        return this.rangeStartTimeInEpochSeconds;
    }

    public Long getRangeEndTimeInEpochSeconds() {
        return this.rangeEndTimeInEpochSeconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricsAggregationRange(");
        sb.append("super=").append(super.toString());
        sb.append("header=").append(String.valueOf((Object)this.header));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(", rangeStartTimeInEpochSeconds=").append(String.valueOf(this.rangeStartTimeInEpochSeconds));
        sb.append(", rangeEndTimeInEpochSeconds=").append(String.valueOf(this.rangeEndTimeInEpochSeconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricsAggregationRange)) {
            return false;
        }
        MetricsAggregationRange other = (MetricsAggregationRange)((Object)o);
        return Objects.equals((Object)this.header, (Object)other.header) && Objects.equals(this.metrics, other.metrics) && Objects.equals(this.rangeStartTimeInEpochSeconds, other.rangeStartTimeInEpochSeconds) && Objects.equals(this.rangeEndTimeInEpochSeconds, other.rangeEndTimeInEpochSeconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.header == null ? 43 : this.header.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + (this.rangeStartTimeInEpochSeconds == null ? 43 : this.rangeStartTimeInEpochSeconds.hashCode());
        result = result * 59 + (this.rangeEndTimeInEpochSeconds == null ? 43 : this.rangeEndTimeInEpochSeconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="header")
        private DbManagementAnalyticsMetric header;
        @JsonProperty(value="metrics")
        private List<DbManagementAnalyticsMetric> metrics;
        @JsonProperty(value="rangeStartTimeInEpochSeconds")
        private Long rangeStartTimeInEpochSeconds;
        @JsonProperty(value="rangeEndTimeInEpochSeconds")
        private Long rangeEndTimeInEpochSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder header(DbManagementAnalyticsMetric header) {
            this.header = header;
            this.__explicitlySet__.add("header");
            return this;
        }

        public Builder metrics(List<DbManagementAnalyticsMetric> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public Builder rangeStartTimeInEpochSeconds(Long rangeStartTimeInEpochSeconds) {
            this.rangeStartTimeInEpochSeconds = rangeStartTimeInEpochSeconds;
            this.__explicitlySet__.add("rangeStartTimeInEpochSeconds");
            return this;
        }

        public Builder rangeEndTimeInEpochSeconds(Long rangeEndTimeInEpochSeconds) {
            this.rangeEndTimeInEpochSeconds = rangeEndTimeInEpochSeconds;
            this.__explicitlySet__.add("rangeEndTimeInEpochSeconds");
            return this;
        }

        public MetricsAggregationRange build() {
            MetricsAggregationRange model = new MetricsAggregationRange(this.header, this.metrics, this.rangeStartTimeInEpochSeconds, this.rangeEndTimeInEpochSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MetricsAggregationRange model) {
            if (model.wasPropertyExplicitlySet("header")) {
                this.header(model.getHeader());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            if (model.wasPropertyExplicitlySet("rangeStartTimeInEpochSeconds")) {
                this.rangeStartTimeInEpochSeconds(model.getRangeStartTimeInEpochSeconds());
            }
            if (model.wasPropertyExplicitlySet("rangeEndTimeInEpochSeconds")) {
                this.rangeEndTimeInEpochSeconds(model.getRangeEndTimeInEpochSeconds());
            }
            return this;
        }
    }
}

