/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AlertSeverityEnum;
import com.oracle.bmc.databasemanagement.model.AlertTypeEnum;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OpenAlertSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="severity")
    private final AlertSeverityEnum severity;
    @JsonProperty(value="type")
    private final AlertTypeEnum type;
    @JsonProperty(value="timeStartAt")
    private final Date timeStartAt;
    @JsonProperty(value="message")
    private final String message;

    @Deprecated
    @ConstructorProperties(value={"severity", "type", "timeStartAt", "message"})
    public OpenAlertSummary(AlertSeverityEnum severity, AlertTypeEnum type, Date timeStartAt, String message) {
        this.severity = severity;
        this.type = type;
        this.timeStartAt = timeStartAt;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AlertSeverityEnum getSeverity() {
        return this.severity;
    }

    public AlertTypeEnum getType() {
        return this.type;
    }

    public Date getTimeStartAt() {
        return this.timeStartAt;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OpenAlertSummary(");
        sb.append("super=").append(super.toString());
        sb.append("severity=").append(String.valueOf((Object)this.severity));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", timeStartAt=").append(String.valueOf(this.timeStartAt));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenAlertSummary)) {
            return false;
        }
        OpenAlertSummary other = (OpenAlertSummary)((Object)o);
        return Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.timeStartAt, other.timeStartAt) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.timeStartAt == null ? 43 : this.timeStartAt.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="severity")
        private AlertSeverityEnum severity;
        @JsonProperty(value="type")
        private AlertTypeEnum type;
        @JsonProperty(value="timeStartAt")
        private Date timeStartAt;
        @JsonProperty(value="message")
        private String message;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder severity(AlertSeverityEnum severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder type(AlertTypeEnum type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder timeStartAt(Date timeStartAt) {
            this.timeStartAt = timeStartAt;
            this.__explicitlySet__.add("timeStartAt");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public OpenAlertSummary build() {
            OpenAlertSummary model = new OpenAlertSummary(this.severity, this.type, this.timeStartAt, this.message);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OpenAlertSummary model) {
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("timeStartAt")) {
                this.timeStartAt(model.getTimeStartAt());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            return this;
        }
    }
}

