/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cpuTime")
    private final Long cpuTime;
    @JsonProperty(value="elapsedTime")
    private final Long elapsedTime;
    @JsonProperty(value="bufferGets")
    private final Long bufferGets;
    @JsonProperty(value="diskReads")
    private final Long diskReads;
    @JsonProperty(value="directWrites")
    private final Long directWrites;
    @JsonProperty(value="executions")
    private final Long executions;

    @Deprecated
    @ConstructorProperties(value={"cpuTime", "elapsedTime", "bufferGets", "diskReads", "directWrites", "executions"})
    public SqlMetrics(Long cpuTime, Long elapsedTime, Long bufferGets, Long diskReads, Long directWrites, Long executions) {
        this.cpuTime = cpuTime;
        this.elapsedTime = elapsedTime;
        this.bufferGets = bufferGets;
        this.diskReads = diskReads;
        this.directWrites = directWrites;
        this.executions = executions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getCpuTime() {
        return this.cpuTime;
    }

    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    public Long getBufferGets() {
        return this.bufferGets;
    }

    public Long getDiskReads() {
        return this.diskReads;
    }

    public Long getDirectWrites() {
        return this.directWrites;
    }

    public Long getExecutions() {
        return this.executions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("cpuTime=").append(String.valueOf(this.cpuTime));
        sb.append(", elapsedTime=").append(String.valueOf(this.elapsedTime));
        sb.append(", bufferGets=").append(String.valueOf(this.bufferGets));
        sb.append(", diskReads=").append(String.valueOf(this.diskReads));
        sb.append(", directWrites=").append(String.valueOf(this.directWrites));
        sb.append(", executions=").append(String.valueOf(this.executions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlMetrics)) {
            return false;
        }
        SqlMetrics other = (SqlMetrics)((Object)o);
        return Objects.equals(this.cpuTime, other.cpuTime) && Objects.equals(this.elapsedTime, other.elapsedTime) && Objects.equals(this.bufferGets, other.bufferGets) && Objects.equals(this.diskReads, other.diskReads) && Objects.equals(this.directWrites, other.directWrites) && Objects.equals(this.executions, other.executions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cpuTime == null ? 43 : this.cpuTime.hashCode());
        result = result * 59 + (this.elapsedTime == null ? 43 : this.elapsedTime.hashCode());
        result = result * 59 + (this.bufferGets == null ? 43 : this.bufferGets.hashCode());
        result = result * 59 + (this.diskReads == null ? 43 : this.diskReads.hashCode());
        result = result * 59 + (this.directWrites == null ? 43 : this.directWrites.hashCode());
        result = result * 59 + (this.executions == null ? 43 : this.executions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cpuTime")
        private Long cpuTime;
        @JsonProperty(value="elapsedTime")
        private Long elapsedTime;
        @JsonProperty(value="bufferGets")
        private Long bufferGets;
        @JsonProperty(value="diskReads")
        private Long diskReads;
        @JsonProperty(value="directWrites")
        private Long directWrites;
        @JsonProperty(value="executions")
        private Long executions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cpuTime(Long cpuTime) {
            this.cpuTime = cpuTime;
            this.__explicitlySet__.add("cpuTime");
            return this;
        }

        public Builder elapsedTime(Long elapsedTime) {
            this.elapsedTime = elapsedTime;
            this.__explicitlySet__.add("elapsedTime");
            return this;
        }

        public Builder bufferGets(Long bufferGets) {
            this.bufferGets = bufferGets;
            this.__explicitlySet__.add("bufferGets");
            return this;
        }

        public Builder diskReads(Long diskReads) {
            this.diskReads = diskReads;
            this.__explicitlySet__.add("diskReads");
            return this;
        }

        public Builder directWrites(Long directWrites) {
            this.directWrites = directWrites;
            this.__explicitlySet__.add("directWrites");
            return this;
        }

        public Builder executions(Long executions) {
            this.executions = executions;
            this.__explicitlySet__.add("executions");
            return this;
        }

        public SqlMetrics build() {
            SqlMetrics model = new SqlMetrics(this.cpuTime, this.elapsedTime, this.bufferGets, this.diskReads, this.directWrites, this.executions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlMetrics model) {
            if (model.wasPropertyExplicitlySet("cpuTime")) {
                this.cpuTime(model.getCpuTime());
            }
            if (model.wasPropertyExplicitlySet("elapsedTime")) {
                this.elapsedTime(model.getElapsedTime());
            }
            if (model.wasPropertyExplicitlySet("bufferGets")) {
                this.bufferGets(model.getBufferGets());
            }
            if (model.wasPropertyExplicitlySet("diskReads")) {
                this.diskReads(model.getDiskReads());
            }
            if (model.wasPropertyExplicitlySet("directWrites")) {
                this.directWrites(model.getDirectWrites());
            }
            if (model.wasPropertyExplicitlySet("executions")) {
                this.executions(model.getExecutions());
            }
            return this;
        }
    }
}

