/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.TableStatisticsStatusCategory;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TableStatisticSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final TableStatisticsStatusCategory type;
    @JsonProperty(value="count")
    private final Integer count;
    @JsonProperty(value="percentage")
    private final Double percentage;

    @Deprecated
    @ConstructorProperties(value={"type", "count", "percentage"})
    public TableStatisticSummary(TableStatisticsStatusCategory type, Integer count, Double percentage) {
        this.type = type;
        this.count = count;
        this.percentage = percentage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TableStatisticsStatusCategory getType() {
        return this.type;
    }

    public Integer getCount() {
        return this.count;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TableStatisticSummary(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf((Object)this.type));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(", percentage=").append(String.valueOf(this.percentage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableStatisticSummary)) {
            return false;
        }
        TableStatisticSummary other = (TableStatisticSummary)((Object)o);
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.count, other.count) && Objects.equals(this.percentage, other.percentage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.percentage == null ? 43 : this.percentage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private TableStatisticsStatusCategory type;
        @JsonProperty(value="count")
        private Integer count;
        @JsonProperty(value="percentage")
        private Double percentage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(TableStatisticsStatusCategory type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder percentage(Double percentage) {
            this.percentage = percentage;
            this.__explicitlySet__.add("percentage");
            return this;
        }

        public TableStatisticSummary build() {
            TableStatisticSummary model = new TableStatisticSummary(this.type, this.count, this.percentage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TableStatisticSummary model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("percentage")) {
                this.percentage(model.getPercentage());
            }
            return this;
        }
    }
}

