/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaselineOrigin;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSqlPlanBaselinesRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String planName;
    private String sqlHandle;
    private String sqlText;
    private Boolean isEnabled;
    private Boolean isAccepted;
    private Boolean isReproduced;
    private Boolean isFixed;
    private Boolean isAdaptive;
    private SqlPlanBaselineOrigin origin;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getSqlHandle() {
        return this.sqlHandle;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Boolean getIsAccepted() {
        return this.isAccepted;
    }

    public Boolean getIsReproduced() {
        return this.isReproduced;
    }

    public Boolean getIsFixed() {
        return this.isFixed;
    }

    public Boolean getIsAdaptive() {
        return this.isAdaptive;
    }

    public SqlPlanBaselineOrigin getOrigin() {
        return this.origin;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).planName(this.planName).sqlHandle(this.sqlHandle).sqlText(this.sqlText).isEnabled(this.isEnabled).isAccepted(this.isAccepted).isReproduced(this.isReproduced).isFixed(this.isFixed).isAdaptive(this.isAdaptive).origin(this.origin).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",planName=").append(String.valueOf(this.planName));
        sb.append(",sqlHandle=").append(String.valueOf(this.sqlHandle));
        sb.append(",sqlText=").append(String.valueOf(this.sqlText));
        sb.append(",isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(",isAccepted=").append(String.valueOf(this.isAccepted));
        sb.append(",isReproduced=").append(String.valueOf(this.isReproduced));
        sb.append(",isFixed=").append(String.valueOf(this.isFixed));
        sb.append(",isAdaptive=").append(String.valueOf(this.isAdaptive));
        sb.append(",origin=").append(String.valueOf((Object)this.origin));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSqlPlanBaselinesRequest)) {
            return false;
        }
        ListSqlPlanBaselinesRequest other = (ListSqlPlanBaselinesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.planName, other.planName) && Objects.equals(this.sqlHandle, other.sqlHandle) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.isAccepted, other.isAccepted) && Objects.equals(this.isReproduced, other.isReproduced) && Objects.equals(this.isFixed, other.isFixed) && Objects.equals(this.isAdaptive, other.isAdaptive) && Objects.equals((Object)this.origin, (Object)other.origin) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.planName == null ? 43 : this.planName.hashCode());
        result = result * 59 + (this.sqlHandle == null ? 43 : this.sqlHandle.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.isAccepted == null ? 43 : this.isAccepted.hashCode());
        result = result * 59 + (this.isReproduced == null ? 43 : this.isReproduced.hashCode());
        result = result * 59 + (this.isFixed == null ? 43 : this.isFixed.hashCode());
        result = result * 59 + (this.isAdaptive == null ? 43 : this.isAdaptive.hashCode());
        result = result * 59 + (this.origin == null ? 43 : this.origin.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlPlanBaselinesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String planName = null;
        private String sqlHandle = null;
        private String sqlText = null;
        private Boolean isEnabled = null;
        private Boolean isAccepted = null;
        private Boolean isReproduced = null;
        private Boolean isFixed = null;
        private Boolean isAdaptive = null;
        private SqlPlanBaselineOrigin origin = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public Builder sqlHandle(String sqlHandle) {
            this.sqlHandle = sqlHandle;
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder isAccepted(Boolean isAccepted) {
            this.isAccepted = isAccepted;
            return this;
        }

        public Builder isReproduced(Boolean isReproduced) {
            this.isReproduced = isReproduced;
            return this;
        }

        public Builder isFixed(Boolean isFixed) {
            this.isFixed = isFixed;
            return this;
        }

        public Builder isAdaptive(Boolean isAdaptive) {
            this.isAdaptive = isAdaptive;
            return this;
        }

        public Builder origin(SqlPlanBaselineOrigin origin) {
            this.origin = origin;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlPlanBaselinesRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.planName(o.getPlanName());
            this.sqlHandle(o.getSqlHandle());
            this.sqlText(o.getSqlText());
            this.isEnabled(o.getIsEnabled());
            this.isAccepted(o.getIsAccepted());
            this.isReproduced(o.getIsReproduced());
            this.isFixed(o.getIsFixed());
            this.isAdaptive(o.getIsAdaptive());
            this.origin(o.getOrigin());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlPlanBaselinesRequest build() {
            ListSqlPlanBaselinesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSqlPlanBaselinesRequest buildWithoutInvocationCallback() {
            ListSqlPlanBaselinesRequest request = new ListSqlPlanBaselinesRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.planName = this.planName;
            request.sqlHandle = this.sqlHandle;
            request.sqlText = this.sqlText;
            request.isEnabled = this.isEnabled;
            request.isAccepted = this.isAccepted;
            request.isReproduced = this.isReproduced;
            request.isFixed = this.isFixed;
            request.isAdaptive = this.isAdaptive;
            request.origin = this.origin;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        TimeLastModified("timeLastModified");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

