/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSqlTuningAdvisorTaskFindingsRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private Long sqlTuningAdvisorTaskId;
    private Long beginExecId;
    private Long endExecId;
    private SearchPeriod searchPeriod;
    private FindingFilter findingFilter;
    private String statsHashFilter;
    private String indexHashFilter;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String page;
    private Integer limit;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Long getSqlTuningAdvisorTaskId() {
        return this.sqlTuningAdvisorTaskId;
    }

    public Long getBeginExecId() {
        return this.beginExecId;
    }

    public Long getEndExecId() {
        return this.endExecId;
    }

    public SearchPeriod getSearchPeriod() {
        return this.searchPeriod;
    }

    public FindingFilter getFindingFilter() {
        return this.findingFilter;
    }

    public String getStatsHashFilter() {
        return this.statsHashFilter;
    }

    public String getIndexHashFilter() {
        return this.indexHashFilter;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).sqlTuningAdvisorTaskId(this.sqlTuningAdvisorTaskId).beginExecId(this.beginExecId).endExecId(this.endExecId).searchPeriod(this.searchPeriod).findingFilter(this.findingFilter).statsHashFilter(this.statsHashFilter).indexHashFilter(this.indexHashFilter).sortBy(this.sortBy).sortOrder(this.sortOrder).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",sqlTuningAdvisorTaskId=").append(String.valueOf(this.sqlTuningAdvisorTaskId));
        sb.append(",beginExecId=").append(String.valueOf(this.beginExecId));
        sb.append(",endExecId=").append(String.valueOf(this.endExecId));
        sb.append(",searchPeriod=").append(String.valueOf((Object)this.searchPeriod));
        sb.append(",findingFilter=").append(String.valueOf((Object)this.findingFilter));
        sb.append(",statsHashFilter=").append(String.valueOf(this.statsHashFilter));
        sb.append(",indexHashFilter=").append(String.valueOf(this.indexHashFilter));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSqlTuningAdvisorTaskFindingsRequest)) {
            return false;
        }
        ListSqlTuningAdvisorTaskFindingsRequest other = (ListSqlTuningAdvisorTaskFindingsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.sqlTuningAdvisorTaskId, other.sqlTuningAdvisorTaskId) && Objects.equals(this.beginExecId, other.beginExecId) && Objects.equals(this.endExecId, other.endExecId) && Objects.equals((Object)this.searchPeriod, (Object)other.searchPeriod) && Objects.equals((Object)this.findingFilter, (Object)other.findingFilter) && Objects.equals(this.statsHashFilter, other.statsHashFilter) && Objects.equals(this.indexHashFilter, other.indexHashFilter) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.sqlTuningAdvisorTaskId == null ? 43 : this.sqlTuningAdvisorTaskId.hashCode());
        result = result * 59 + (this.beginExecId == null ? 43 : this.beginExecId.hashCode());
        result = result * 59 + (this.endExecId == null ? 43 : this.endExecId.hashCode());
        result = result * 59 + (this.searchPeriod == null ? 43 : this.searchPeriod.hashCode());
        result = result * 59 + (this.findingFilter == null ? 43 : this.findingFilter.hashCode());
        result = result * 59 + (this.statsHashFilter == null ? 43 : this.statsHashFilter.hashCode());
        result = result * 59 + (this.indexHashFilter == null ? 43 : this.indexHashFilter.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlTuningAdvisorTaskFindingsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Long sqlTuningAdvisorTaskId = null;
        private Long beginExecId = null;
        private Long endExecId = null;
        private SearchPeriod searchPeriod = null;
        private FindingFilter findingFilter = null;
        private String statsHashFilter = null;
        private String indexHashFilter = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder sqlTuningAdvisorTaskId(Long sqlTuningAdvisorTaskId) {
            this.sqlTuningAdvisorTaskId = sqlTuningAdvisorTaskId;
            return this;
        }

        public Builder beginExecId(Long beginExecId) {
            this.beginExecId = beginExecId;
            return this;
        }

        public Builder endExecId(Long endExecId) {
            this.endExecId = endExecId;
            return this;
        }

        public Builder searchPeriod(SearchPeriod searchPeriod) {
            this.searchPeriod = searchPeriod;
            return this;
        }

        public Builder findingFilter(FindingFilter findingFilter) {
            this.findingFilter = findingFilter;
            return this;
        }

        public Builder statsHashFilter(String statsHashFilter) {
            this.statsHashFilter = statsHashFilter;
            return this;
        }

        public Builder indexHashFilter(String indexHashFilter) {
            this.indexHashFilter = indexHashFilter;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlTuningAdvisorTaskFindingsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.sqlTuningAdvisorTaskId(o.getSqlTuningAdvisorTaskId());
            this.beginExecId(o.getBeginExecId());
            this.endExecId(o.getEndExecId());
            this.searchPeriod(o.getSearchPeriod());
            this.findingFilter(o.getFindingFilter());
            this.statsHashFilter(o.getStatsHashFilter());
            this.indexHashFilter(o.getIndexHashFilter());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlTuningAdvisorTaskFindingsRequest build() {
            ListSqlTuningAdvisorTaskFindingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSqlTuningAdvisorTaskFindingsRequest buildWithoutInvocationCallback() {
            ListSqlTuningAdvisorTaskFindingsRequest request = new ListSqlTuningAdvisorTaskFindingsRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.sqlTuningAdvisorTaskId = this.sqlTuningAdvisorTaskId;
            request.beginExecId = this.beginExecId;
            request.endExecId = this.endExecId;
            request.searchPeriod = this.searchPeriod;
            request.findingFilter = this.findingFilter;
            request.statsHashFilter = this.statsHashFilter;
            request.indexHashFilter = this.indexHashFilter;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DbtimeBenefit("DBTIME_BENEFIT"),
        ParsingSchema("PARSING_SCHEMA"),
        SqlId("SQL_ID"),
        Stats("STATS"),
        Profiles("PROFILES"),
        SqlBenefit("SQL_BENEFIT"),
        Date("DATE"),
        Indices("INDICES"),
        Restructure("RESTRUCTURE"),
        Alternative("ALTERNATIVE"),
        Misc("MISC"),
        Error("ERROR"),
        Timeouts("TIMEOUTS");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum FindingFilter implements BmcEnum
    {
        None("none"),
        Findings("FINDINGS"),
        Nofindings("NOFINDINGS"),
        Errors("ERRORS"),
        Profiles("PROFILES"),
        Indices("INDICES"),
        Stats("STATS"),
        Restructure("RESTRUCTURE"),
        Alternative("ALTERNATIVE"),
        AutoProfiles("AUTO_PROFILES"),
        OtherProfiles("OTHER_PROFILES");

        private final String value;
        private static Map<String, FindingFilter> map;

        private FindingFilter(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FindingFilter create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FindingFilter: " + key);
        }

        static {
            map = new HashMap<String, FindingFilter>();
            for (FindingFilter v : FindingFilter.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SearchPeriod implements BmcEnum
    {
        Last24Hr("LAST_24HR"),
        Last7Day("LAST_7DAY"),
        Last31Day("LAST_31DAY"),
        SinceLast("SINCE_LAST"),
        All("ALL");

        private final String value;
        private static Map<String, SearchPeriod> map;

        private SearchPeriod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SearchPeriod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SearchPeriod: " + key);
        }

        static {
            map = new HashMap<String, SearchPeriod>();
            for (SearchPeriod v : SearchPeriod.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

