/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.ManagedMySqlDatabasesAsync;
import com.oracle.bmc.databasemanagement.model.ManagedMySqlDatabase;
import com.oracle.bmc.databasemanagement.model.ManagedMySqlDatabaseCollection;
import com.oracle.bmc.databasemanagement.model.MetricsAggregationRangeCollection;
import com.oracle.bmc.databasemanagement.model.MySqlConfigurationDataCollection;
import com.oracle.bmc.databasemanagement.model.MySqlDataCollection;
import com.oracle.bmc.databasemanagement.model.MySqlFleetMetrics;
import com.oracle.bmc.databasemanagement.requests.GetManagedMySqlDatabaseRequest;
import com.oracle.bmc.databasemanagement.requests.GetMySqlFleetMetricRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedMySqlDatabaseConfigurationDataRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedMySqlDatabaseSqlDataRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedMySqlDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeManagedMySqlDatabaseAvailabilityMetricsRequest;
import com.oracle.bmc.databasemanagement.responses.GetManagedMySqlDatabaseResponse;
import com.oracle.bmc.databasemanagement.responses.GetMySqlFleetMetricResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedMySqlDatabaseConfigurationDataResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedMySqlDatabaseSqlDataResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedMySqlDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeManagedMySqlDatabaseAvailabilityMetricsResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedMySqlDatabasesAsyncClient
extends BaseAsyncClient
implements ManagedMySqlDatabasesAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MANAGEDMYSQLDATABASES").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ManagedMySqlDatabasesAsyncClient.class);

    ManagedMySqlDatabasesAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetManagedMySqlDatabaseResponse> getManagedMySqlDatabase(GetManagedMySqlDatabaseRequest request, AsyncHandler<GetManagedMySqlDatabaseRequest, GetManagedMySqlDatabaseResponse> handler) {
        Validate.notBlank((String)request.getManagedMySqlDatabaseId(), (String)"managedMySqlDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagedMySqlDatabaseResponse::builder).logger(LOG, "getManagedMySqlDatabase").serviceDetails("ManagedMySqlDatabases", "GetManagedMySqlDatabase", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedMySqlDatabase/GetManagedMySqlDatabase").method(Method.GET).requestBuilder(GetManagedMySqlDatabaseRequest::builder).basePath("/20201101").appendPathParam("managedMySqlDatabases").appendPathParam(request.getManagedMySqlDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedMySqlDatabase.class, GetManagedMySqlDatabaseResponse.Builder::managedMySqlDatabase).handleResponseHeaderString("opc-request-id", GetManagedMySqlDatabaseResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMySqlFleetMetricResponse> getMySqlFleetMetric(GetMySqlFleetMetricRequest request, AsyncHandler<GetMySqlFleetMetricRequest, GetMySqlFleetMetricResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, GetMySqlFleetMetricResponse::builder).logger(LOG, "getMySqlFleetMetric").serviceDetails("ManagedMySqlDatabases", "GetMySqlFleetMetric", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/MySqlFleetMetrics/GetMySqlFleetMetric").method(Method.GET).requestBuilder(GetMySqlFleetMetricRequest::builder).basePath("/20201101").appendPathParam("mysqlFleetMetrics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendEnumQueryParam("filterByMySqlDeploymentTypeParam", (BmcEnum)request.getFilterByMySqlDeploymentTypeParam()).appendEnumQueryParam("filterByMdsDeploymentType", (BmcEnum)request.getFilterByMdsDeploymentType()).appendEnumQueryParam("filterByMySqlStatus", (BmcEnum)request.getFilterByMySqlStatus()).appendQueryParam("filterByMySqlDatabaseVersion", (Object)request.getFilterByMySqlDatabaseVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MySqlFleetMetrics.class, GetMySqlFleetMetricResponse.Builder::mySqlFleetMetrics).handleResponseHeaderString("opc-request-id", GetMySqlFleetMetricResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListManagedMySqlDatabaseConfigurationDataResponse> listManagedMySqlDatabaseConfigurationData(ListManagedMySqlDatabaseConfigurationDataRequest request, AsyncHandler<ListManagedMySqlDatabaseConfigurationDataRequest, ListManagedMySqlDatabaseConfigurationDataResponse> handler) {
        Validate.notBlank((String)request.getManagedMySqlDatabaseId(), (String)"managedMySqlDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListManagedMySqlDatabaseConfigurationDataResponse::builder).logger(LOG, "listManagedMySqlDatabaseConfigurationData").serviceDetails("ManagedMySqlDatabases", "ListManagedMySqlDatabaseConfigurationData", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedMySqlDatabase/ListManagedMySqlDatabaseConfigurationData").method(Method.GET).requestBuilder(ListManagedMySqlDatabaseConfigurationDataRequest::builder).basePath("/20201101").appendPathParam("managedMySqlDatabases").appendPathParam(request.getManagedMySqlDatabaseId()).appendPathParam("configurationData").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MySqlConfigurationDataCollection.class, ListManagedMySqlDatabaseConfigurationDataResponse.Builder::mySqlConfigurationDataCollection).handleResponseHeaderString("opc-request-id", ListManagedMySqlDatabaseConfigurationDataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedMySqlDatabaseConfigurationDataResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedMySqlDatabaseSqlDataResponse> listManagedMySqlDatabaseSqlData(ListManagedMySqlDatabaseSqlDataRequest request, AsyncHandler<ListManagedMySqlDatabaseSqlDataRequest, ListManagedMySqlDatabaseSqlDataResponse> handler) {
        Validate.notBlank((String)request.getManagedMySqlDatabaseId(), (String)"managedMySqlDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, ListManagedMySqlDatabaseSqlDataResponse::builder).logger(LOG, "listManagedMySqlDatabaseSqlData").serviceDetails("ManagedMySqlDatabases", "ListManagedMySqlDatabaseSqlData", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedMySqlDatabase/ListManagedMySqlDatabaseSqlData").method(Method.GET).requestBuilder(ListManagedMySqlDatabaseSqlDataRequest::builder).basePath("/20201101").appendPathParam("managedMySqlDatabases").appendPathParam(request.getManagedMySqlDatabaseId()).appendPathParam("sqlData").appendQueryParam("filterColumn", (Object)request.getFilterColumn()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MySqlDataCollection.class, ListManagedMySqlDatabaseSqlDataResponse.Builder::mySqlDataCollection).handleResponseHeaderString("opc-request-id", ListManagedMySqlDatabaseSqlDataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedMySqlDatabaseSqlDataResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedMySqlDatabasesResponse> listManagedMySqlDatabases(ListManagedMySqlDatabasesRequest request, AsyncHandler<ListManagedMySqlDatabasesRequest, ListManagedMySqlDatabasesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListManagedMySqlDatabasesResponse::builder).logger(LOG, "listManagedMySqlDatabases").serviceDetails("ManagedMySqlDatabases", "ListManagedMySqlDatabases", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedMySqlDatabaseCollection/ListManagedMySqlDatabases").method(Method.GET).requestBuilder(ListManagedMySqlDatabasesRequest::builder).basePath("/20201101").appendPathParam("managedMySqlDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedMySqlDatabaseCollection.class, ListManagedMySqlDatabasesResponse.Builder::managedMySqlDatabaseCollection).handleResponseHeaderString("opc-request-id", ListManagedMySqlDatabasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedMySqlDatabasesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeManagedMySqlDatabaseAvailabilityMetricsResponse> summarizeManagedMySqlDatabaseAvailabilityMetrics(SummarizeManagedMySqlDatabaseAvailabilityMetricsRequest request, AsyncHandler<SummarizeManagedMySqlDatabaseAvailabilityMetricsRequest, SummarizeManagedMySqlDatabaseAvailabilityMetricsResponse> handler) {
        Validate.notBlank((String)request.getManagedMySqlDatabaseId(), (String)"managedMySqlDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeManagedMySqlDatabaseAvailabilityMetricsResponse::builder).logger(LOG, "summarizeManagedMySqlDatabaseAvailabilityMetrics").serviceDetails("ManagedMySqlDatabases", "SummarizeManagedMySqlDatabaseAvailabilityMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedMySqlDatabase/SummarizeManagedMySqlDatabaseAvailabilityMetrics").method(Method.GET).requestBuilder(SummarizeManagedMySqlDatabaseAvailabilityMetricsRequest::builder).basePath("/20201101").appendPathParam("managedMySqlDatabases").appendPathParam(request.getManagedMySqlDatabaseId()).appendPathParam("availabilityMetrics").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricsAggregationRangeCollection.class, SummarizeManagedMySqlDatabaseAvailabilityMetricsResponse.Builder::metricsAggregationRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeManagedMySqlDatabaseAvailabilityMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeManagedMySqlDatabaseAvailabilityMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Deprecated
    public ManagedMySqlDatabasesAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ManagedMySqlDatabasesAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedMySqlDatabasesAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ManagedMySqlDatabasesAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedMySqlDatabasesAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ManagedMySqlDatabasesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedMySqlDatabasesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ManagedMySqlDatabasesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedMySqlDatabasesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ManagedMySqlDatabasesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedMySqlDatabasesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ManagedMySqlDatabasesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ManagedMySqlDatabasesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ManagedMySqlDatabasesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ManagedMySqlDatabasesAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "databasemanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"databasemanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ManagedMySqlDatabasesAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ManagedMySqlDatabasesAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

