/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AllowedParameterValue
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ordinal")
    private final BigDecimal ordinal;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;

    @Deprecated
    @ConstructorProperties(value={"ordinal", "value", "isDefault"})
    public AllowedParameterValue(BigDecimal ordinal, String value, Boolean isDefault) {
        this.ordinal = ordinal;
        this.value = value;
        this.isDefault = isDefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BigDecimal getOrdinal() {
        return this.ordinal;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AllowedParameterValue(");
        sb.append("super=").append(super.toString());
        sb.append("ordinal=").append(String.valueOf(this.ordinal));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AllowedParameterValue)) {
            return false;
        }
        AllowedParameterValue other = (AllowedParameterValue)((Object)o);
        return Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.value, other.value) && Objects.equals(this.isDefault, other.isDefault) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ordinal == null ? 43 : this.ordinal.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ordinal")
        private BigDecimal ordinal;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ordinal(BigDecimal ordinal) {
            this.ordinal = ordinal;
            this.__explicitlySet__.add("ordinal");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public AllowedParameterValue build() {
            AllowedParameterValue model = new AllowedParameterValue(this.ordinal, this.value, this.isDefault);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AllowedParameterValue model) {
            if (model.wasPropertyExplicitlySet("ordinal")) {
                this.ordinal(model.getOrdinal());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            return this;
        }
    }
}

