/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.SqlTuningTaskCredentialDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloneSqlTuningTaskDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="taskName")
    private final String taskName;
    @JsonProperty(value="originalTaskId")
    private final Long originalTaskId;
    @JsonProperty(value="taskDescription")
    private final String taskDescription;
    @JsonProperty(value="credentialDetails")
    private final SqlTuningTaskCredentialDetails credentialDetails;

    @Deprecated
    @ConstructorProperties(value={"taskName", "originalTaskId", "taskDescription", "credentialDetails"})
    public CloneSqlTuningTaskDetails(String taskName, Long originalTaskId, String taskDescription, SqlTuningTaskCredentialDetails credentialDetails) {
        this.taskName = taskName;
        this.originalTaskId = originalTaskId;
        this.taskDescription = taskDescription;
        this.credentialDetails = credentialDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Long getOriginalTaskId() {
        return this.originalTaskId;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public SqlTuningTaskCredentialDetails getCredentialDetails() {
        return this.credentialDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CloneSqlTuningTaskDetails(");
        sb.append("super=").append(super.toString());
        sb.append("taskName=").append(String.valueOf(this.taskName));
        sb.append(", originalTaskId=").append(String.valueOf(this.originalTaskId));
        sb.append(", taskDescription=").append(String.valueOf(this.taskDescription));
        sb.append(", credentialDetails=").append(String.valueOf((Object)this.credentialDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloneSqlTuningTaskDetails)) {
            return false;
        }
        CloneSqlTuningTaskDetails other = (CloneSqlTuningTaskDetails)((Object)o);
        return Objects.equals(this.taskName, other.taskName) && Objects.equals(this.originalTaskId, other.originalTaskId) && Objects.equals(this.taskDescription, other.taskDescription) && Objects.equals((Object)this.credentialDetails, (Object)other.credentialDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.taskName == null ? 43 : this.taskName.hashCode());
        result = result * 59 + (this.originalTaskId == null ? 43 : this.originalTaskId.hashCode());
        result = result * 59 + (this.taskDescription == null ? 43 : this.taskDescription.hashCode());
        result = result * 59 + (this.credentialDetails == null ? 43 : this.credentialDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="taskName")
        private String taskName;
        @JsonProperty(value="originalTaskId")
        private Long originalTaskId;
        @JsonProperty(value="taskDescription")
        private String taskDescription;
        @JsonProperty(value="credentialDetails")
        private SqlTuningTaskCredentialDetails credentialDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            this.__explicitlySet__.add("taskName");
            return this;
        }

        public Builder originalTaskId(Long originalTaskId) {
            this.originalTaskId = originalTaskId;
            this.__explicitlySet__.add("originalTaskId");
            return this;
        }

        public Builder taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            this.__explicitlySet__.add("taskDescription");
            return this;
        }

        public Builder credentialDetails(SqlTuningTaskCredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            this.__explicitlySet__.add("credentialDetails");
            return this;
        }

        public CloneSqlTuningTaskDetails build() {
            CloneSqlTuningTaskDetails model = new CloneSqlTuningTaskDetails(this.taskName, this.originalTaskId, this.taskDescription, this.credentialDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CloneSqlTuningTaskDetails model) {
            if (model.wasPropertyExplicitlySet("taskName")) {
                this.taskName(model.getTaskName());
            }
            if (model.wasPropertyExplicitlySet("originalTaskId")) {
                this.originalTaskId(model.getOriginalTaskId());
            }
            if (model.wasPropertyExplicitlySet("taskDescription")) {
                this.taskDescription(model.getTaskDescription());
            }
            if (model.wasPropertyExplicitlySet("credentialDetails")) {
                this.credentialDetails(model.getCredentialDetails());
            }
            return this;
        }
    }
}

