/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDataPoint;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseStorageAggregateMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="storageAllocated")
    private final MetricDataPoint storageAllocated;
    @JsonProperty(value="storageUsed")
    private final MetricDataPoint storageUsed;
    @JsonProperty(value="storageUsedByTableSpace")
    private final List<MetricDataPoint> storageUsedByTableSpace;

    @Deprecated
    @ConstructorProperties(value={"storageAllocated", "storageUsed", "storageUsedByTableSpace"})
    public DatabaseStorageAggregateMetrics(MetricDataPoint storageAllocated, MetricDataPoint storageUsed, List<MetricDataPoint> storageUsedByTableSpace) {
        this.storageAllocated = storageAllocated;
        this.storageUsed = storageUsed;
        this.storageUsedByTableSpace = storageUsedByTableSpace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MetricDataPoint getStorageAllocated() {
        return this.storageAllocated;
    }

    public MetricDataPoint getStorageUsed() {
        return this.storageUsed;
    }

    public List<MetricDataPoint> getStorageUsedByTableSpace() {
        return this.storageUsedByTableSpace;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseStorageAggregateMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("storageAllocated=").append(String.valueOf((Object)this.storageAllocated));
        sb.append(", storageUsed=").append(String.valueOf((Object)this.storageUsed));
        sb.append(", storageUsedByTableSpace=").append(String.valueOf(this.storageUsedByTableSpace));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseStorageAggregateMetrics)) {
            return false;
        }
        DatabaseStorageAggregateMetrics other = (DatabaseStorageAggregateMetrics)((Object)o);
        return Objects.equals((Object)this.storageAllocated, (Object)other.storageAllocated) && Objects.equals((Object)this.storageUsed, (Object)other.storageUsed) && Objects.equals(this.storageUsedByTableSpace, other.storageUsedByTableSpace) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.storageAllocated == null ? 43 : this.storageAllocated.hashCode());
        result = result * 59 + (this.storageUsed == null ? 43 : this.storageUsed.hashCode());
        result = result * 59 + (this.storageUsedByTableSpace == null ? 43 : this.storageUsedByTableSpace.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="storageAllocated")
        private MetricDataPoint storageAllocated;
        @JsonProperty(value="storageUsed")
        private MetricDataPoint storageUsed;
        @JsonProperty(value="storageUsedByTableSpace")
        private List<MetricDataPoint> storageUsedByTableSpace;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder storageAllocated(MetricDataPoint storageAllocated) {
            this.storageAllocated = storageAllocated;
            this.__explicitlySet__.add("storageAllocated");
            return this;
        }

        public Builder storageUsed(MetricDataPoint storageUsed) {
            this.storageUsed = storageUsed;
            this.__explicitlySet__.add("storageUsed");
            return this;
        }

        public Builder storageUsedByTableSpace(List<MetricDataPoint> storageUsedByTableSpace) {
            this.storageUsedByTableSpace = storageUsedByTableSpace;
            this.__explicitlySet__.add("storageUsedByTableSpace");
            return this;
        }

        public DatabaseStorageAggregateMetrics build() {
            DatabaseStorageAggregateMetrics model = new DatabaseStorageAggregateMetrics(this.storageAllocated, this.storageUsed, this.storageUsedByTableSpace);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseStorageAggregateMetrics model) {
            if (model.wasPropertyExplicitlySet("storageAllocated")) {
                this.storageAllocated(model.getStorageAllocated());
            }
            if (model.wasPropertyExplicitlySet("storageUsed")) {
                this.storageUsed(model.getStorageUsed());
            }
            if (model.wasPropertyExplicitlySet("storageUsedByTableSpace")) {
                this.storageUsedByTableSpace(model.getStorageUsedByTableSpace());
            }
            return this;
        }
    }
}

