/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AssociatedComponent;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalDbSystemComponent;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalPluggableDatabase;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscoveryConnector;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveredExternalDatabase
extends DiscoveredExternalDbSystemComponent {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="dbType")
    private final DatabaseSubType dbType;
    @JsonProperty(value="isCluster")
    private final Boolean isCluster;
    @JsonProperty(value="dbEdition")
    private final String dbEdition;
    @JsonProperty(value="dbId")
    private final String dbId;
    @JsonProperty(value="dbPacks")
    private final String dbPacks;
    @JsonProperty(value="dbRole")
    private final DbRole dbRole;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="pluggableDatabases")
    private final List<DiscoveredExternalPluggableDatabase> pluggableDatabases;
    @JsonProperty(value="connector")
    private final ExternalDbSystemDiscoveryConnector connector;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DiscoveredExternalDatabase(String componentId, String displayName, String componentName, String resourceId, Boolean isSelectedForMonitoring, DiscoveredExternalDbSystemComponent.Status status, List<AssociatedComponent> associatedComponents, String compartmentId, String dbUniqueName, DatabaseSubType dbType, Boolean isCluster, String dbEdition, String dbId, String dbPacks, DbRole dbRole, String dbVersion, List<DiscoveredExternalPluggableDatabase> pluggableDatabases, ExternalDbSystemDiscoveryConnector connector) {
        super(componentId, displayName, componentName, resourceId, isSelectedForMonitoring, status, associatedComponents);
        this.compartmentId = compartmentId;
        this.dbUniqueName = dbUniqueName;
        this.dbType = dbType;
        this.isCluster = isCluster;
        this.dbEdition = dbEdition;
        this.dbId = dbId;
        this.dbPacks = dbPacks;
        this.dbRole = dbRole;
        this.dbVersion = dbVersion;
        this.pluggableDatabases = pluggableDatabases;
        this.connector = connector;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public DatabaseSubType getDbType() {
        return this.dbType;
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public String getDbEdition() {
        return this.dbEdition;
    }

    public String getDbId() {
        return this.dbId;
    }

    public String getDbPacks() {
        return this.dbPacks;
    }

    public DbRole getDbRole() {
        return this.dbRole;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public List<DiscoveredExternalPluggableDatabase> getPluggableDatabases() {
        return this.pluggableDatabases;
    }

    public ExternalDbSystemDiscoveryConnector getConnector() {
        return this.connector;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveredExternalDatabase(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", dbType=").append(String.valueOf((Object)this.dbType));
        sb.append(", isCluster=").append(String.valueOf(this.isCluster));
        sb.append(", dbEdition=").append(String.valueOf(this.dbEdition));
        sb.append(", dbId=").append(String.valueOf(this.dbId));
        sb.append(", dbPacks=").append(String.valueOf(this.dbPacks));
        sb.append(", dbRole=").append(String.valueOf((Object)this.dbRole));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", pluggableDatabases=").append(String.valueOf(this.pluggableDatabases));
        sb.append(", connector=").append(String.valueOf((Object)this.connector));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveredExternalDatabase)) {
            return false;
        }
        DiscoveredExternalDatabase other = (DiscoveredExternalDatabase)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals((Object)this.dbType, (Object)other.dbType) && Objects.equals(this.isCluster, other.isCluster) && Objects.equals(this.dbEdition, other.dbEdition) && Objects.equals(this.dbId, other.dbId) && Objects.equals(this.dbPacks, other.dbPacks) && Objects.equals((Object)this.dbRole, (Object)other.dbRole) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.pluggableDatabases, other.pluggableDatabases) && Objects.equals((Object)this.connector, (Object)other.connector) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.dbType == null ? 43 : this.dbType.hashCode());
        result = result * 59 + (this.isCluster == null ? 43 : this.isCluster.hashCode());
        result = result * 59 + (this.dbEdition == null ? 43 : this.dbEdition.hashCode());
        result = result * 59 + (this.dbId == null ? 43 : this.dbId.hashCode());
        result = result * 59 + (this.dbPacks == null ? 43 : this.dbPacks.hashCode());
        result = result * 59 + (this.dbRole == null ? 43 : this.dbRole.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.pluggableDatabases == null ? 43 : this.pluggableDatabases.hashCode());
        result = result * 59 + (this.connector == null ? 43 : this.connector.hashCode());
        return result;
    }

    public static enum DbRole implements BmcEnum
    {
        LogicalStandby("LOGICAL_STANDBY"),
        PhysicalStandby("PHYSICAL_STANDBY"),
        SnapshotStandby("SNAPSHOT_STANDBY"),
        Primary("PRIMARY"),
        FarSync("FAR_SYNC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DbRole> map;

        private DbRole(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbRole create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DbRole', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DbRole.class);
            map = new HashMap<String, DbRole>();
            for (DbRole v : DbRole.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="componentId")
        private String componentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="componentName")
        private String componentName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="isSelectedForMonitoring")
        private Boolean isSelectedForMonitoring;
        @JsonProperty(value="status")
        private DiscoveredExternalDbSystemComponent.Status status;
        @JsonProperty(value="associatedComponents")
        private List<AssociatedComponent> associatedComponents;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="dbType")
        private DatabaseSubType dbType;
        @JsonProperty(value="isCluster")
        private Boolean isCluster;
        @JsonProperty(value="dbEdition")
        private String dbEdition;
        @JsonProperty(value="dbId")
        private String dbId;
        @JsonProperty(value="dbPacks")
        private String dbPacks;
        @JsonProperty(value="dbRole")
        private DbRole dbRole;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="pluggableDatabases")
        private List<DiscoveredExternalPluggableDatabase> pluggableDatabases;
        @JsonProperty(value="connector")
        private ExternalDbSystemDiscoveryConnector connector;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder componentId(String componentId) {
            this.componentId = componentId;
            this.__explicitlySet__.add("componentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.__explicitlySet__.add("componentName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder isSelectedForMonitoring(Boolean isSelectedForMonitoring) {
            this.isSelectedForMonitoring = isSelectedForMonitoring;
            this.__explicitlySet__.add("isSelectedForMonitoring");
            return this;
        }

        public Builder status(DiscoveredExternalDbSystemComponent.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder associatedComponents(List<AssociatedComponent> associatedComponents) {
            this.associatedComponents = associatedComponents;
            this.__explicitlySet__.add("associatedComponents");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder dbType(DatabaseSubType dbType) {
            this.dbType = dbType;
            this.__explicitlySet__.add("dbType");
            return this;
        }

        public Builder isCluster(Boolean isCluster) {
            this.isCluster = isCluster;
            this.__explicitlySet__.add("isCluster");
            return this;
        }

        public Builder dbEdition(String dbEdition) {
            this.dbEdition = dbEdition;
            this.__explicitlySet__.add("dbEdition");
            return this;
        }

        public Builder dbId(String dbId) {
            this.dbId = dbId;
            this.__explicitlySet__.add("dbId");
            return this;
        }

        public Builder dbPacks(String dbPacks) {
            this.dbPacks = dbPacks;
            this.__explicitlySet__.add("dbPacks");
            return this;
        }

        public Builder dbRole(DbRole dbRole) {
            this.dbRole = dbRole;
            this.__explicitlySet__.add("dbRole");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder pluggableDatabases(List<DiscoveredExternalPluggableDatabase> pluggableDatabases) {
            this.pluggableDatabases = pluggableDatabases;
            this.__explicitlySet__.add("pluggableDatabases");
            return this;
        }

        public Builder connector(ExternalDbSystemDiscoveryConnector connector) {
            this.connector = connector;
            this.__explicitlySet__.add("connector");
            return this;
        }

        public DiscoveredExternalDatabase build() {
            DiscoveredExternalDatabase model = new DiscoveredExternalDatabase(this.componentId, this.displayName, this.componentName, this.resourceId, this.isSelectedForMonitoring, this.status, this.associatedComponents, this.compartmentId, this.dbUniqueName, this.dbType, this.isCluster, this.dbEdition, this.dbId, this.dbPacks, this.dbRole, this.dbVersion, this.pluggableDatabases, this.connector);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveredExternalDatabase model) {
            if (model.wasPropertyExplicitlySet("componentId")) {
                this.componentId(model.getComponentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("componentName")) {
                this.componentName(model.getComponentName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("isSelectedForMonitoring")) {
                this.isSelectedForMonitoring(model.getIsSelectedForMonitoring());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("associatedComponents")) {
                this.associatedComponents(model.getAssociatedComponents());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("dbType")) {
                this.dbType(model.getDbType());
            }
            if (model.wasPropertyExplicitlySet("isCluster")) {
                this.isCluster(model.getIsCluster());
            }
            if (model.wasPropertyExplicitlySet("dbEdition")) {
                this.dbEdition(model.getDbEdition());
            }
            if (model.wasPropertyExplicitlySet("dbId")) {
                this.dbId(model.getDbId());
            }
            if (model.wasPropertyExplicitlySet("dbPacks")) {
                this.dbPacks(model.getDbPacks());
            }
            if (model.wasPropertyExplicitlySet("dbRole")) {
                this.dbRole(model.getDbRole());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("pluggableDatabases")) {
                this.pluggableDatabases(model.getPluggableDatabases());
            }
            if (model.wasPropertyExplicitlySet("connector")) {
                this.connector(model.getConnector());
            }
            return this;
        }
    }
}

