/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalClusterVipConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="nodeName")
    private final String nodeName;
    @JsonProperty(value="address")
    private final String address;
    @JsonProperty(value="networkNumber")
    private final Integer networkNumber;

    @Deprecated
    @ConstructorProperties(value={"nodeName", "address", "networkNumber"})
    public ExternalClusterVipConfiguration(String nodeName, String address, Integer networkNumber) {
        this.nodeName = nodeName;
        this.address = address;
        this.networkNumber = networkNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getNetworkNumber() {
        return this.networkNumber;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalClusterVipConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("nodeName=").append(String.valueOf(this.nodeName));
        sb.append(", address=").append(String.valueOf(this.address));
        sb.append(", networkNumber=").append(String.valueOf(this.networkNumber));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalClusterVipConfiguration)) {
            return false;
        }
        ExternalClusterVipConfiguration other = (ExternalClusterVipConfiguration)((Object)o);
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.address, other.address) && Objects.equals(this.networkNumber, other.networkNumber) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nodeName == null ? 43 : this.nodeName.hashCode());
        result = result * 59 + (this.address == null ? 43 : this.address.hashCode());
        result = result * 59 + (this.networkNumber == null ? 43 : this.networkNumber.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="nodeName")
        private String nodeName;
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="networkNumber")
        private Integer networkNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            this.__explicitlySet__.add("nodeName");
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            this.__explicitlySet__.add("address");
            return this;
        }

        public Builder networkNumber(Integer networkNumber) {
            this.networkNumber = networkNumber;
            this.__explicitlySet__.add("networkNumber");
            return this;
        }

        public ExternalClusterVipConfiguration build() {
            ExternalClusterVipConfiguration model = new ExternalClusterVipConfiguration(this.nodeName, this.address, this.networkNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalClusterVipConfiguration model) {
            if (model.wasPropertyExplicitlySet("nodeName")) {
                this.nodeName(model.getNodeName());
            }
            if (model.wasPropertyExplicitlySet("address")) {
                this.address(model.getAddress());
            }
            if (model.wasPropertyExplicitlySet("networkNumber")) {
                this.networkNumber(model.getNetworkNumber());
            }
            return this;
        }
    }
}

