/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnectionInfo;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscoveryConnector;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectorType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalDbSystemDiscoveryMacsConnector
extends ExternalDbSystemDiscoveryConnector {
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="connectionInfo")
    private final ExternalDbSystemConnectionInfo connectionInfo;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalDbSystemDiscoveryMacsConnector(String displayName, String connectionStatus, String connectionFailureMessage, Date timeConnectionStatusLastUpdated, String agentId, ExternalDbSystemConnectionInfo connectionInfo) {
        super(displayName, connectionStatus, connectionFailureMessage, timeConnectionStatusLastUpdated);
        this.agentId = agentId;
        this.connectionInfo = connectionInfo;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public ExternalDbSystemConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalDbSystemDiscoveryMacsConnector(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", agentId=").append(String.valueOf(this.agentId));
        sb.append(", connectionInfo=").append(String.valueOf((Object)this.connectionInfo));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalDbSystemDiscoveryMacsConnector)) {
            return false;
        }
        ExternalDbSystemDiscoveryMacsConnector other = (ExternalDbSystemDiscoveryMacsConnector)((Object)o);
        return Objects.equals(this.agentId, other.agentId) && Objects.equals((Object)this.connectionInfo, (Object)other.connectionInfo) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.connectionInfo == null ? 43 : this.connectionInfo.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="connectionStatus")
        private String connectionStatus;
        @JsonProperty(value="connectionFailureMessage")
        private String connectionFailureMessage;
        @JsonProperty(value="timeConnectionStatusLastUpdated")
        private Date timeConnectionStatusLastUpdated;
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="connectionInfo")
        private ExternalDbSystemConnectionInfo connectionInfo;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            this.__explicitlySet__.add("connectionStatus");
            return this;
        }

        public Builder connectionFailureMessage(String connectionFailureMessage) {
            this.connectionFailureMessage = connectionFailureMessage;
            this.__explicitlySet__.add("connectionFailureMessage");
            return this;
        }

        public Builder timeConnectionStatusLastUpdated(Date timeConnectionStatusLastUpdated) {
            this.timeConnectionStatusLastUpdated = timeConnectionStatusLastUpdated;
            this.__explicitlySet__.add("timeConnectionStatusLastUpdated");
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder connectionInfo(ExternalDbSystemConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            this.__explicitlySet__.add("connectionInfo");
            return this;
        }

        public ExternalDbSystemDiscoveryMacsConnector build() {
            ExternalDbSystemDiscoveryMacsConnector model = new ExternalDbSystemDiscoveryMacsConnector(this.displayName, this.connectionStatus, this.connectionFailureMessage, this.timeConnectionStatusLastUpdated, this.agentId, this.connectionInfo);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalDbSystemDiscoveryMacsConnector model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("connectionStatus")) {
                this.connectionStatus(model.getConnectionStatus());
            }
            if (model.wasPropertyExplicitlySet("connectionFailureMessage")) {
                this.connectionFailureMessage(model.getConnectionFailureMessage());
            }
            if (model.wasPropertyExplicitlySet("timeConnectionStatusLastUpdated")) {
                this.timeConnectionStatusLastUpdated(model.getTimeConnectionStatusLastUpdated());
            }
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("connectionInfo")) {
                this.connectionInfo(model.getConnectionInfo());
            }
            return this;
        }
    }
}

