/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.EntityDiscovered;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalStorageServerDiscoverySummary
extends EntityDiscovered {
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="makeModel")
    private final String makeModel;
    @JsonProperty(value="cpuCount")
    private final Integer cpuCount;
    @JsonProperty(value="memoryGB")
    private final Double memoryGB;
    @JsonProperty(value="connectorName")
    private final String connectorName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalStorageServerDiscoverySummary(String id, String agentId, String connectorId, String displayName, String version, String internalId, String status, EntityDiscovered.DiscoverStatus discoverStatus, String discoverErrorCode, String discoverErrorMsg, String ipAddress, String makeModel, Integer cpuCount, Double memoryGB, String connectorName) {
        super(id, agentId, connectorId, displayName, version, internalId, status, discoverStatus, discoverErrorCode, discoverErrorMsg);
        this.ipAddress = ipAddress;
        this.makeModel = makeModel;
        this.cpuCount = cpuCount;
        this.memoryGB = memoryGB;
        this.connectorName = connectorName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getMakeModel() {
        return this.makeModel;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public Double getMemoryGB() {
        return this.memoryGB;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalStorageServerDiscoverySummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", makeModel=").append(String.valueOf(this.makeModel));
        sb.append(", cpuCount=").append(String.valueOf(this.cpuCount));
        sb.append(", memoryGB=").append(String.valueOf(this.memoryGB));
        sb.append(", connectorName=").append(String.valueOf(this.connectorName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalStorageServerDiscoverySummary)) {
            return false;
        }
        ExternalStorageServerDiscoverySummary other = (ExternalStorageServerDiscoverySummary)((Object)o);
        return Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.makeModel, other.makeModel) && Objects.equals(this.cpuCount, other.cpuCount) && Objects.equals(this.memoryGB, other.memoryGB) && Objects.equals(this.connectorName, other.connectorName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.makeModel == null ? 43 : this.makeModel.hashCode());
        result = result * 59 + (this.cpuCount == null ? 43 : this.cpuCount.hashCode());
        result = result * 59 + (this.memoryGB == null ? 43 : this.memoryGB.hashCode());
        result = result * 59 + (this.connectorName == null ? 43 : this.connectorName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="connectorId")
        private String connectorId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="internalId")
        private String internalId;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="discoverStatus")
        private EntityDiscovered.DiscoverStatus discoverStatus;
        @JsonProperty(value="discoverErrorCode")
        private String discoverErrorCode;
        @JsonProperty(value="discoverErrorMsg")
        private String discoverErrorMsg;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="makeModel")
        private String makeModel;
        @JsonProperty(value="cpuCount")
        private Integer cpuCount;
        @JsonProperty(value="memoryGB")
        private Double memoryGB;
        @JsonProperty(value="connectorName")
        private String connectorName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            this.__explicitlySet__.add("connectorId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder internalId(String internalId) {
            this.internalId = internalId;
            this.__explicitlySet__.add("internalId");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder discoverStatus(EntityDiscovered.DiscoverStatus discoverStatus) {
            this.discoverStatus = discoverStatus;
            this.__explicitlySet__.add("discoverStatus");
            return this;
        }

        public Builder discoverErrorCode(String discoverErrorCode) {
            this.discoverErrorCode = discoverErrorCode;
            this.__explicitlySet__.add("discoverErrorCode");
            return this;
        }

        public Builder discoverErrorMsg(String discoverErrorMsg) {
            this.discoverErrorMsg = discoverErrorMsg;
            this.__explicitlySet__.add("discoverErrorMsg");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder makeModel(String makeModel) {
            this.makeModel = makeModel;
            this.__explicitlySet__.add("makeModel");
            return this;
        }

        public Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            this.__explicitlySet__.add("cpuCount");
            return this;
        }

        public Builder memoryGB(Double memoryGB) {
            this.memoryGB = memoryGB;
            this.__explicitlySet__.add("memoryGB");
            return this;
        }

        public Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            this.__explicitlySet__.add("connectorName");
            return this;
        }

        public ExternalStorageServerDiscoverySummary build() {
            ExternalStorageServerDiscoverySummary model = new ExternalStorageServerDiscoverySummary(this.id, this.agentId, this.connectorId, this.displayName, this.version, this.internalId, this.status, this.discoverStatus, this.discoverErrorCode, this.discoverErrorMsg, this.ipAddress, this.makeModel, this.cpuCount, this.memoryGB, this.connectorName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalStorageServerDiscoverySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("connectorId")) {
                this.connectorId(model.getConnectorId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("internalId")) {
                this.internalId(model.getInternalId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("discoverStatus")) {
                this.discoverStatus(model.getDiscoverStatus());
            }
            if (model.wasPropertyExplicitlySet("discoverErrorCode")) {
                this.discoverErrorCode(model.getDiscoverErrorCode());
            }
            if (model.wasPropertyExplicitlySet("discoverErrorMsg")) {
                this.discoverErrorMsg(model.getDiscoverErrorMsg());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("makeModel")) {
                this.makeModel(model.getMakeModel());
            }
            if (model.wasPropertyExplicitlySet("cpuCount")) {
                this.cpuCount(model.getCpuCount());
            }
            if (model.wasPropertyExplicitlySet("memoryGB")) {
                this.memoryGB(model.getMemoryGB());
            }
            if (model.wasPropertyExplicitlySet("connectorName")) {
                this.connectorName(model.getConnectorName());
            }
            return this;
        }
    }
}

