/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseCredential;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LoadSqlPlanBaselinesFromCursorCacheDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="jobName")
    private final String jobName;
    @JsonProperty(value="jobDescription")
    private final String jobDescription;
    @JsonProperty(value="sqlId")
    private final String sqlId;
    @JsonProperty(value="planHash")
    private final BigDecimal planHash;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="sqlHandle")
    private final String sqlHandle;
    @JsonProperty(value="filterName")
    private final FilterName filterName;
    @JsonProperty(value="filterValue")
    private final String filterValue;
    @JsonProperty(value="isFixed")
    private final Boolean isFixed;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="credentials")
    private final ManagedDatabaseCredential credentials;

    @Deprecated
    @ConstructorProperties(value={"jobName", "jobDescription", "sqlId", "planHash", "sqlText", "sqlHandle", "filterName", "filterValue", "isFixed", "isEnabled", "credentials"})
    public LoadSqlPlanBaselinesFromCursorCacheDetails(String jobName, String jobDescription, String sqlId, BigDecimal planHash, String sqlText, String sqlHandle, FilterName filterName, String filterValue, Boolean isFixed, Boolean isEnabled, ManagedDatabaseCredential credentials) {
        this.jobName = jobName;
        this.jobDescription = jobDescription;
        this.sqlId = sqlId;
        this.planHash = planHash;
        this.sqlText = sqlText;
        this.sqlHandle = sqlHandle;
        this.filterName = filterName;
        this.filterValue = filterValue;
        this.isFixed = isFixed;
        this.isEnabled = isEnabled;
        this.credentials = credentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public BigDecimal getPlanHash() {
        return this.planHash;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public String getSqlHandle() {
        return this.sqlHandle;
    }

    public FilterName getFilterName() {
        return this.filterName;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public Boolean getIsFixed() {
        return this.isFixed;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public ManagedDatabaseCredential getCredentials() {
        return this.credentials;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LoadSqlPlanBaselinesFromCursorCacheDetails(");
        sb.append("super=").append(super.toString());
        sb.append("jobName=").append(String.valueOf(this.jobName));
        sb.append(", jobDescription=").append(String.valueOf(this.jobDescription));
        sb.append(", sqlId=").append(String.valueOf(this.sqlId));
        sb.append(", planHash=").append(String.valueOf(this.planHash));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", sqlHandle=").append(String.valueOf(this.sqlHandle));
        sb.append(", filterName=").append(String.valueOf((Object)this.filterName));
        sb.append(", filterValue=").append(String.valueOf(this.filterValue));
        sb.append(", isFixed=").append(String.valueOf(this.isFixed));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", credentials=").append(String.valueOf((Object)this.credentials));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadSqlPlanBaselinesFromCursorCacheDetails)) {
            return false;
        }
        LoadSqlPlanBaselinesFromCursorCacheDetails other = (LoadSqlPlanBaselinesFromCursorCacheDetails)((Object)o);
        return Objects.equals(this.jobName, other.jobName) && Objects.equals(this.jobDescription, other.jobDescription) && Objects.equals(this.sqlId, other.sqlId) && Objects.equals(this.planHash, other.planHash) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals(this.sqlHandle, other.sqlHandle) && Objects.equals((Object)this.filterName, (Object)other.filterName) && Objects.equals(this.filterValue, other.filterValue) && Objects.equals(this.isFixed, other.isFixed) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.credentials, (Object)other.credentials) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.jobName == null ? 43 : this.jobName.hashCode());
        result = result * 59 + (this.jobDescription == null ? 43 : this.jobDescription.hashCode());
        result = result * 59 + (this.sqlId == null ? 43 : this.sqlId.hashCode());
        result = result * 59 + (this.planHash == null ? 43 : this.planHash.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.sqlHandle == null ? 43 : this.sqlHandle.hashCode());
        result = result * 59 + (this.filterName == null ? 43 : this.filterName.hashCode());
        result = result * 59 + (this.filterValue == null ? 43 : this.filterValue.hashCode());
        result = result * 59 + (this.isFixed == null ? 43 : this.isFixed.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FilterName implements BmcEnum
    {
        SqlText("SQL_TEXT"),
        ParsingSchemaName("PARSING_SCHEMA_NAME"),
        Module("MODULE"),
        Action("ACTION");

        private final String value;
        private static Map<String, FilterName> map;

        private FilterName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FilterName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FilterName: " + key);
        }

        static {
            map = new HashMap<String, FilterName>();
            for (FilterName v : FilterName.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="jobName")
        private String jobName;
        @JsonProperty(value="jobDescription")
        private String jobDescription;
        @JsonProperty(value="sqlId")
        private String sqlId;
        @JsonProperty(value="planHash")
        private BigDecimal planHash;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="sqlHandle")
        private String sqlHandle;
        @JsonProperty(value="filterName")
        private FilterName filterName;
        @JsonProperty(value="filterValue")
        private String filterValue;
        @JsonProperty(value="isFixed")
        private Boolean isFixed;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="credentials")
        private ManagedDatabaseCredential credentials;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            this.__explicitlySet__.add("jobName");
            return this;
        }

        public Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            this.__explicitlySet__.add("jobDescription");
            return this;
        }

        public Builder sqlId(String sqlId) {
            this.sqlId = sqlId;
            this.__explicitlySet__.add("sqlId");
            return this;
        }

        public Builder planHash(BigDecimal planHash) {
            this.planHash = planHash;
            this.__explicitlySet__.add("planHash");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder sqlHandle(String sqlHandle) {
            this.sqlHandle = sqlHandle;
            this.__explicitlySet__.add("sqlHandle");
            return this;
        }

        public Builder filterName(FilterName filterName) {
            this.filterName = filterName;
            this.__explicitlySet__.add("filterName");
            return this;
        }

        public Builder filterValue(String filterValue) {
            this.filterValue = filterValue;
            this.__explicitlySet__.add("filterValue");
            return this;
        }

        public Builder isFixed(Boolean isFixed) {
            this.isFixed = isFixed;
            this.__explicitlySet__.add("isFixed");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder credentials(ManagedDatabaseCredential credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public LoadSqlPlanBaselinesFromCursorCacheDetails build() {
            LoadSqlPlanBaselinesFromCursorCacheDetails model = new LoadSqlPlanBaselinesFromCursorCacheDetails(this.jobName, this.jobDescription, this.sqlId, this.planHash, this.sqlText, this.sqlHandle, this.filterName, this.filterValue, this.isFixed, this.isEnabled, this.credentials);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LoadSqlPlanBaselinesFromCursorCacheDetails model) {
            if (model.wasPropertyExplicitlySet("jobName")) {
                this.jobName(model.getJobName());
            }
            if (model.wasPropertyExplicitlySet("jobDescription")) {
                this.jobDescription(model.getJobDescription());
            }
            if (model.wasPropertyExplicitlySet("sqlId")) {
                this.sqlId(model.getSqlId());
            }
            if (model.wasPropertyExplicitlySet("planHash")) {
                this.planHash(model.getPlanHash());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("sqlHandle")) {
                this.sqlHandle(model.getSqlHandle());
            }
            if (model.wasPropertyExplicitlySet("filterName")) {
                this.filterName(model.getFilterName());
            }
            if (model.wasPropertyExplicitlySet("filterValue")) {
                this.filterValue(model.getFilterValue());
            }
            if (model.wasPropertyExplicitlySet("isFixed")) {
                this.isFixed(model.getIsFixed());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            return this;
        }
    }
}

