/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DatabaseType;
import com.oracle.bmc.databasemanagement.model.DeploymentType;
import com.oracle.bmc.databasemanagement.model.ManagementOption;
import com.oracle.bmc.databasemanagement.model.WorkloadType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedDatabaseSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="databaseSubType")
    private final DatabaseSubType databaseSubType;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="managementOption")
    private final ManagementOption managementOption;
    @JsonProperty(value="workloadType")
    private final WorkloadType workloadType;
    @JsonProperty(value="isCluster")
    private final Boolean isCluster;
    @JsonProperty(value="parentContainerId")
    private final String parentContainerId;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="storageSystemId")
    private final String storageSystemId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "name", "databaseType", "databaseSubType", "deploymentType", "managementOption", "workloadType", "isCluster", "parentContainerId", "dbSystemId", "storageSystemId", "timeCreated"})
    public ManagedDatabaseSummary(String id, String compartmentId, String name, DatabaseType databaseType, DatabaseSubType databaseSubType, DeploymentType deploymentType, ManagementOption managementOption, WorkloadType workloadType, Boolean isCluster, String parentContainerId, String dbSystemId, String storageSystemId, Date timeCreated) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.name = name;
        this.databaseType = databaseType;
        this.databaseSubType = databaseSubType;
        this.deploymentType = deploymentType;
        this.managementOption = managementOption;
        this.workloadType = workloadType;
        this.isCluster = isCluster;
        this.parentContainerId = parentContainerId;
        this.dbSystemId = dbSystemId;
        this.storageSystemId = storageSystemId;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseSubType getDatabaseSubType() {
        return this.databaseSubType;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public ManagementOption getManagementOption() {
        return this.managementOption;
    }

    public WorkloadType getWorkloadType() {
        return this.workloadType;
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public String getParentContainerId() {
        return this.parentContainerId;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getStorageSystemId() {
        return this.storageSystemId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedDatabaseSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", databaseSubType=").append(String.valueOf((Object)this.databaseSubType));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", managementOption=").append(String.valueOf((Object)this.managementOption));
        sb.append(", workloadType=").append(String.valueOf((Object)this.workloadType));
        sb.append(", isCluster=").append(String.valueOf(this.isCluster));
        sb.append(", parentContainerId=").append(String.valueOf(this.parentContainerId));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", storageSystemId=").append(String.valueOf(this.storageSystemId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedDatabaseSummary)) {
            return false;
        }
        ManagedDatabaseSummary other = (ManagedDatabaseSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.databaseSubType, (Object)other.databaseSubType) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals((Object)this.managementOption, (Object)other.managementOption) && Objects.equals((Object)this.workloadType, (Object)other.workloadType) && Objects.equals(this.isCluster, other.isCluster) && Objects.equals(this.parentContainerId, other.parentContainerId) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.storageSystemId, other.storageSystemId) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseSubType == null ? 43 : this.databaseSubType.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.managementOption == null ? 43 : this.managementOption.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.isCluster == null ? 43 : this.isCluster.hashCode());
        result = result * 59 + (this.parentContainerId == null ? 43 : this.parentContainerId.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.storageSystemId == null ? 43 : this.storageSystemId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="managementOption")
        private ManagementOption managementOption;
        @JsonProperty(value="workloadType")
        private WorkloadType workloadType;
        @JsonProperty(value="isCluster")
        private Boolean isCluster;
        @JsonProperty(value="parentContainerId")
        private String parentContainerId;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="storageSystemId")
        private String storageSystemId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder managementOption(ManagementOption managementOption) {
            this.managementOption = managementOption;
            this.__explicitlySet__.add("managementOption");
            return this;
        }

        public Builder workloadType(WorkloadType workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public Builder isCluster(Boolean isCluster) {
            this.isCluster = isCluster;
            this.__explicitlySet__.add("isCluster");
            return this;
        }

        public Builder parentContainerId(String parentContainerId) {
            this.parentContainerId = parentContainerId;
            this.__explicitlySet__.add("parentContainerId");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder storageSystemId(String storageSystemId) {
            this.storageSystemId = storageSystemId;
            this.__explicitlySet__.add("storageSystemId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public ManagedDatabaseSummary build() {
            ManagedDatabaseSummary model = new ManagedDatabaseSummary(this.id, this.compartmentId, this.name, this.databaseType, this.databaseSubType, this.deploymentType, this.managementOption, this.workloadType, this.isCluster, this.parentContainerId, this.dbSystemId, this.storageSystemId, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedDatabaseSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseSubType")) {
                this.databaseSubType(model.getDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("managementOption")) {
                this.managementOption(model.getManagementOption());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("isCluster")) {
                this.isCluster(model.getIsCluster());
            }
            if (model.wasPropertyExplicitlySet("parentContainerId")) {
                this.parentContainerId(model.getParentContainerId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("storageSystemId")) {
                this.storageSystemId(model.getStorageSystemId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

