/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ObjectPrivilegeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="schemaType")
    private final String schemaType;
    @JsonProperty(value="owner")
    private final String owner;
    @JsonProperty(value="grantor")
    private final String grantor;
    @JsonProperty(value="hierarchy")
    private final Hierarchy hierarchy;
    @JsonProperty(value="object")
    private final String object;
    @JsonProperty(value="grantOption")
    private final GrantOption grantOption;
    @JsonProperty(value="common")
    private final Common common;
    @JsonProperty(value="inherited")
    private final Inherited inherited;

    @Deprecated
    @ConstructorProperties(value={"name", "schemaType", "owner", "grantor", "hierarchy", "object", "grantOption", "common", "inherited"})
    public ObjectPrivilegeSummary(String name, String schemaType, String owner, String grantor, Hierarchy hierarchy, String object, GrantOption grantOption, Common common, Inherited inherited) {
        this.name = name;
        this.schemaType = schemaType;
        this.owner = owner;
        this.grantor = grantor;
        this.hierarchy = hierarchy;
        this.object = object;
        this.grantOption = grantOption;
        this.common = common;
        this.inherited = inherited;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String getObject() {
        return this.object;
    }

    public GrantOption getGrantOption() {
        return this.grantOption;
    }

    public Common getCommon() {
        return this.common;
    }

    public Inherited getInherited() {
        return this.inherited;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectPrivilegeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", schemaType=").append(String.valueOf(this.schemaType));
        sb.append(", owner=").append(String.valueOf(this.owner));
        sb.append(", grantor=").append(String.valueOf(this.grantor));
        sb.append(", hierarchy=").append(String.valueOf((Object)this.hierarchy));
        sb.append(", object=").append(String.valueOf(this.object));
        sb.append(", grantOption=").append(String.valueOf((Object)this.grantOption));
        sb.append(", common=").append(String.valueOf((Object)this.common));
        sb.append(", inherited=").append(String.valueOf((Object)this.inherited));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectPrivilegeSummary)) {
            return false;
        }
        ObjectPrivilegeSummary other = (ObjectPrivilegeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.schemaType, other.schemaType) && Objects.equals(this.owner, other.owner) && Objects.equals(this.grantor, other.grantor) && Objects.equals((Object)this.hierarchy, (Object)other.hierarchy) && Objects.equals(this.object, other.object) && Objects.equals((Object)this.grantOption, (Object)other.grantOption) && Objects.equals((Object)this.common, (Object)other.common) && Objects.equals((Object)this.inherited, (Object)other.inherited) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.schemaType == null ? 43 : this.schemaType.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.grantor == null ? 43 : this.grantor.hashCode());
        result = result * 59 + (this.hierarchy == null ? 43 : this.hierarchy.hashCode());
        result = result * 59 + (this.object == null ? 43 : this.object.hashCode());
        result = result * 59 + (this.grantOption == null ? 43 : this.grantOption.hashCode());
        result = result * 59 + (this.common == null ? 43 : this.common.hashCode());
        result = result * 59 + (this.inherited == null ? 43 : this.inherited.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Inherited implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Inherited> map;

        private Inherited(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Inherited create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Inherited', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Inherited.class);
            map = new HashMap<String, Inherited>();
            for (Inherited v : Inherited.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Common implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Common> map;

        private Common(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Common create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Common', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Common.class);
            map = new HashMap<String, Common>();
            for (Common v : Common.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum GrantOption implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GrantOption> map;

        private GrantOption(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GrantOption create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GrantOption', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GrantOption.class);
            map = new HashMap<String, GrantOption>();
            for (GrantOption v : GrantOption.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Hierarchy implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Hierarchy> map;

        private Hierarchy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Hierarchy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Hierarchy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Hierarchy.class);
            map = new HashMap<String, Hierarchy>();
            for (Hierarchy v : Hierarchy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="schemaType")
        private String schemaType;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="grantor")
        private String grantor;
        @JsonProperty(value="hierarchy")
        private Hierarchy hierarchy;
        @JsonProperty(value="object")
        private String object;
        @JsonProperty(value="grantOption")
        private GrantOption grantOption;
        @JsonProperty(value="common")
        private Common common;
        @JsonProperty(value="inherited")
        private Inherited inherited;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder schemaType(String schemaType) {
            this.schemaType = schemaType;
            this.__explicitlySet__.add("schemaType");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder grantor(String grantor) {
            this.grantor = grantor;
            this.__explicitlySet__.add("grantor");
            return this;
        }

        public Builder hierarchy(Hierarchy hierarchy) {
            this.hierarchy = hierarchy;
            this.__explicitlySet__.add("hierarchy");
            return this;
        }

        public Builder object(String object) {
            this.object = object;
            this.__explicitlySet__.add("object");
            return this;
        }

        public Builder grantOption(GrantOption grantOption) {
            this.grantOption = grantOption;
            this.__explicitlySet__.add("grantOption");
            return this;
        }

        public Builder common(Common common) {
            this.common = common;
            this.__explicitlySet__.add("common");
            return this;
        }

        public Builder inherited(Inherited inherited) {
            this.inherited = inherited;
            this.__explicitlySet__.add("inherited");
            return this;
        }

        public ObjectPrivilegeSummary build() {
            ObjectPrivilegeSummary model = new ObjectPrivilegeSummary(this.name, this.schemaType, this.owner, this.grantor, this.hierarchy, this.object, this.grantOption, this.common, this.inherited);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectPrivilegeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("schemaType")) {
                this.schemaType(model.getSchemaType());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("grantor")) {
                this.grantor(model.getGrantor());
            }
            if (model.wasPropertyExplicitlySet("hierarchy")) {
                this.hierarchy(model.getHierarchy());
            }
            if (model.wasPropertyExplicitlySet("object")) {
                this.object(model.getObject());
            }
            if (model.wasPropertyExplicitlySet("grantOption")) {
                this.grantOption(model.getGrantOption());
            }
            if (model.wasPropertyExplicitlySet("common")) {
                this.common(model.getCommon());
            }
            if (model.wasPropertyExplicitlySet("inherited")) {
                this.inherited(model.getInherited());
            }
            return this;
        }
    }
}

