/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.JobExecutionResultDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ObjectStorageJobExecutionResultDetails
extends JobExecutionResultDetails {
    @JsonProperty(value="namespaceName")
    private final String namespaceName;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="rowCount")
    private final Integer rowCount;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ObjectStorageJobExecutionResultDetails(String namespaceName, String bucketName, String objectName, Integer rowCount) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.rowCount = rowCount;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectStorageJobExecutionResultDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", rowCount=").append(String.valueOf(this.rowCount));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectStorageJobExecutionResultDetails)) {
            return false;
        }
        ObjectStorageJobExecutionResultDetails other = (ObjectStorageJobExecutionResultDetails)((Object)o);
        return Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.rowCount, other.rowCount) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.rowCount == null ? 43 : this.rowCount.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespaceName")
        private String namespaceName;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="rowCount")
        private Integer rowCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            this.__explicitlySet__.add("namespaceName");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder rowCount(Integer rowCount) {
            this.rowCount = rowCount;
            this.__explicitlySet__.add("rowCount");
            return this;
        }

        public ObjectStorageJobExecutionResultDetails build() {
            ObjectStorageJobExecutionResultDetails model = new ObjectStorageJobExecutionResultDetails(this.namespaceName, this.bucketName, this.objectName, this.rowCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectStorageJobExecutionResultDetails model) {
            if (model.wasPropertyExplicitlySet("namespaceName")) {
                this.namespaceName(model.getNamespaceName());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("rowCount")) {
                this.rowCount(model.getRowCount());
            }
            return this;
        }
    }
}

