/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaselineOrigin;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlPlanBaselineSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="planName")
    private final String planName;
    @JsonProperty(value="sqlHandle")
    private final String sqlHandle;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="origin")
    private final SqlPlanBaselineOrigin origin;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastModified")
    private final Date timeLastModified;
    @JsonProperty(value="timeLastExecuted")
    private final Date timeLastExecuted;
    @JsonProperty(value="enabled")
    private final String enabled;
    @JsonProperty(value="accepted")
    private final String accepted;
    @JsonProperty(value="fixed")
    private final String fixed;
    @JsonProperty(value="reproduced")
    private final String reproduced;
    @JsonProperty(value="autoPurge")
    private final String autoPurge;
    @JsonProperty(value="adaptive")
    private final String adaptive;

    @Deprecated
    @ConstructorProperties(value={"planName", "sqlHandle", "sqlText", "origin", "timeCreated", "timeLastModified", "timeLastExecuted", "enabled", "accepted", "fixed", "reproduced", "autoPurge", "adaptive"})
    public SqlPlanBaselineSummary(String planName, String sqlHandle, String sqlText, SqlPlanBaselineOrigin origin, Date timeCreated, Date timeLastModified, Date timeLastExecuted, String enabled, String accepted, String fixed, String reproduced, String autoPurge, String adaptive) {
        this.planName = planName;
        this.sqlHandle = sqlHandle;
        this.sqlText = sqlText;
        this.origin = origin;
        this.timeCreated = timeCreated;
        this.timeLastModified = timeLastModified;
        this.timeLastExecuted = timeLastExecuted;
        this.enabled = enabled;
        this.accepted = accepted;
        this.fixed = fixed;
        this.reproduced = reproduced;
        this.autoPurge = autoPurge;
        this.adaptive = adaptive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getSqlHandle() {
        return this.sqlHandle;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public SqlPlanBaselineOrigin getOrigin() {
        return this.origin;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastModified() {
        return this.timeLastModified;
    }

    public Date getTimeLastExecuted() {
        return this.timeLastExecuted;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String getAccepted() {
        return this.accepted;
    }

    public String getFixed() {
        return this.fixed;
    }

    public String getReproduced() {
        return this.reproduced;
    }

    public String getAutoPurge() {
        return this.autoPurge;
    }

    public String getAdaptive() {
        return this.adaptive;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlPlanBaselineSummary(");
        sb.append("super=").append(super.toString());
        sb.append("planName=").append(String.valueOf(this.planName));
        sb.append(", sqlHandle=").append(String.valueOf(this.sqlHandle));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", origin=").append(String.valueOf((Object)this.origin));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastModified=").append(String.valueOf(this.timeLastModified));
        sb.append(", timeLastExecuted=").append(String.valueOf(this.timeLastExecuted));
        sb.append(", enabled=").append(String.valueOf(this.enabled));
        sb.append(", accepted=").append(String.valueOf(this.accepted));
        sb.append(", fixed=").append(String.valueOf(this.fixed));
        sb.append(", reproduced=").append(String.valueOf(this.reproduced));
        sb.append(", autoPurge=").append(String.valueOf(this.autoPurge));
        sb.append(", adaptive=").append(String.valueOf(this.adaptive));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlPlanBaselineSummary)) {
            return false;
        }
        SqlPlanBaselineSummary other = (SqlPlanBaselineSummary)((Object)o);
        return Objects.equals(this.planName, other.planName) && Objects.equals(this.sqlHandle, other.sqlHandle) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals((Object)this.origin, (Object)other.origin) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastModified, other.timeLastModified) && Objects.equals(this.timeLastExecuted, other.timeLastExecuted) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.accepted, other.accepted) && Objects.equals(this.fixed, other.fixed) && Objects.equals(this.reproduced, other.reproduced) && Objects.equals(this.autoPurge, other.autoPurge) && Objects.equals(this.adaptive, other.adaptive) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.planName == null ? 43 : this.planName.hashCode());
        result = result * 59 + (this.sqlHandle == null ? 43 : this.sqlHandle.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.origin == null ? 43 : this.origin.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastModified == null ? 43 : this.timeLastModified.hashCode());
        result = result * 59 + (this.timeLastExecuted == null ? 43 : this.timeLastExecuted.hashCode());
        result = result * 59 + (this.enabled == null ? 43 : this.enabled.hashCode());
        result = result * 59 + (this.accepted == null ? 43 : this.accepted.hashCode());
        result = result * 59 + (this.fixed == null ? 43 : this.fixed.hashCode());
        result = result * 59 + (this.reproduced == null ? 43 : this.reproduced.hashCode());
        result = result * 59 + (this.autoPurge == null ? 43 : this.autoPurge.hashCode());
        result = result * 59 + (this.adaptive == null ? 43 : this.adaptive.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="planName")
        private String planName;
        @JsonProperty(value="sqlHandle")
        private String sqlHandle;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="origin")
        private SqlPlanBaselineOrigin origin;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastModified")
        private Date timeLastModified;
        @JsonProperty(value="timeLastExecuted")
        private Date timeLastExecuted;
        @JsonProperty(value="enabled")
        private String enabled;
        @JsonProperty(value="accepted")
        private String accepted;
        @JsonProperty(value="fixed")
        private String fixed;
        @JsonProperty(value="reproduced")
        private String reproduced;
        @JsonProperty(value="autoPurge")
        private String autoPurge;
        @JsonProperty(value="adaptive")
        private String adaptive;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder planName(String planName) {
            this.planName = planName;
            this.__explicitlySet__.add("planName");
            return this;
        }

        public Builder sqlHandle(String sqlHandle) {
            this.sqlHandle = sqlHandle;
            this.__explicitlySet__.add("sqlHandle");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder origin(SqlPlanBaselineOrigin origin) {
            this.origin = origin;
            this.__explicitlySet__.add("origin");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastModified(Date timeLastModified) {
            this.timeLastModified = timeLastModified;
            this.__explicitlySet__.add("timeLastModified");
            return this;
        }

        public Builder timeLastExecuted(Date timeLastExecuted) {
            this.timeLastExecuted = timeLastExecuted;
            this.__explicitlySet__.add("timeLastExecuted");
            return this;
        }

        public Builder enabled(String enabled) {
            this.enabled = enabled;
            this.__explicitlySet__.add("enabled");
            return this;
        }

        public Builder accepted(String accepted) {
            this.accepted = accepted;
            this.__explicitlySet__.add("accepted");
            return this;
        }

        public Builder fixed(String fixed) {
            this.fixed = fixed;
            this.__explicitlySet__.add("fixed");
            return this;
        }

        public Builder reproduced(String reproduced) {
            this.reproduced = reproduced;
            this.__explicitlySet__.add("reproduced");
            return this;
        }

        public Builder autoPurge(String autoPurge) {
            this.autoPurge = autoPurge;
            this.__explicitlySet__.add("autoPurge");
            return this;
        }

        public Builder adaptive(String adaptive) {
            this.adaptive = adaptive;
            this.__explicitlySet__.add("adaptive");
            return this;
        }

        public SqlPlanBaselineSummary build() {
            SqlPlanBaselineSummary model = new SqlPlanBaselineSummary(this.planName, this.sqlHandle, this.sqlText, this.origin, this.timeCreated, this.timeLastModified, this.timeLastExecuted, this.enabled, this.accepted, this.fixed, this.reproduced, this.autoPurge, this.adaptive);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlPlanBaselineSummary model) {
            if (model.wasPropertyExplicitlySet("planName")) {
                this.planName(model.getPlanName());
            }
            if (model.wasPropertyExplicitlySet("sqlHandle")) {
                this.sqlHandle(model.getSqlHandle());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("origin")) {
                this.origin(model.getOrigin());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastModified")) {
                this.timeLastModified(model.getTimeLastModified());
            }
            if (model.wasPropertyExplicitlySet("timeLastExecuted")) {
                this.timeLastExecuted(model.getTimeLastExecuted());
            }
            if (model.wasPropertyExplicitlySet("enabled")) {
                this.enabled(model.getEnabled());
            }
            if (model.wasPropertyExplicitlySet("accepted")) {
                this.accepted(model.getAccepted());
            }
            if (model.wasPropertyExplicitlySet("fixed")) {
                this.fixed(model.getFixed());
            }
            if (model.wasPropertyExplicitlySet("reproduced")) {
                this.reproduced(model.getReproduced());
            }
            if (model.wasPropertyExplicitlySet("autoPurge")) {
                this.autoPurge(model.getAutoPurge());
            }
            if (model.wasPropertyExplicitlySet("adaptive")) {
                this.adaptive(model.getAdaptive());
            }
            return this;
        }
    }
}

