/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetAwrDbSqlReportRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String awrDbId;
    private String sqlId;
    private String instNum;
    private Integer beginSnIdGreaterThanOrEqualTo;
    private Integer endSnIdLessThanOrEqualTo;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private ReportFormat reportFormat;
    private Integer containerId;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getAwrDbId() {
        return this.awrDbId;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public String getInstNum() {
        return this.instNum;
    }

    public Integer getBeginSnIdGreaterThanOrEqualTo() {
        return this.beginSnIdGreaterThanOrEqualTo;
    }

    public Integer getEndSnIdLessThanOrEqualTo() {
        return this.endSnIdLessThanOrEqualTo;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public Integer getContainerId() {
        return this.containerId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).awrDbId(this.awrDbId).sqlId(this.sqlId).instNum(this.instNum).beginSnIdGreaterThanOrEqualTo(this.beginSnIdGreaterThanOrEqualTo).endSnIdLessThanOrEqualTo(this.endSnIdLessThanOrEqualTo).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).reportFormat(this.reportFormat).containerId(this.containerId).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",awrDbId=").append(String.valueOf(this.awrDbId));
        sb.append(",sqlId=").append(String.valueOf(this.sqlId));
        sb.append(",instNum=").append(String.valueOf(this.instNum));
        sb.append(",beginSnIdGreaterThanOrEqualTo=").append(String.valueOf(this.beginSnIdGreaterThanOrEqualTo));
        sb.append(",endSnIdLessThanOrEqualTo=").append(String.valueOf(this.endSnIdLessThanOrEqualTo));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(",containerId=").append(String.valueOf(this.containerId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAwrDbSqlReportRequest)) {
            return false;
        }
        GetAwrDbSqlReportRequest other = (GetAwrDbSqlReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.awrDbId, other.awrDbId) && Objects.equals(this.sqlId, other.sqlId) && Objects.equals(this.instNum, other.instNum) && Objects.equals(this.beginSnIdGreaterThanOrEqualTo, other.beginSnIdGreaterThanOrEqualTo) && Objects.equals(this.endSnIdLessThanOrEqualTo, other.endSnIdLessThanOrEqualTo) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && Objects.equals(this.containerId, other.containerId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.awrDbId == null ? 43 : this.awrDbId.hashCode());
        result = result * 59 + (this.sqlId == null ? 43 : this.sqlId.hashCode());
        result = result * 59 + (this.instNum == null ? 43 : this.instNum.hashCode());
        result = result * 59 + (this.beginSnIdGreaterThanOrEqualTo == null ? 43 : this.beginSnIdGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endSnIdLessThanOrEqualTo == null ? 43 : this.endSnIdLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + (this.containerId == null ? 43 : this.containerId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAwrDbSqlReportRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String awrDbId = null;
        private String sqlId = null;
        private String instNum = null;
        private Integer beginSnIdGreaterThanOrEqualTo = null;
        private Integer endSnIdLessThanOrEqualTo = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private ReportFormat reportFormat = null;
        private Integer containerId = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder awrDbId(String awrDbId) {
            this.awrDbId = awrDbId;
            return this;
        }

        public Builder sqlId(String sqlId) {
            this.sqlId = sqlId;
            return this;
        }

        public Builder instNum(String instNum) {
            this.instNum = instNum;
            return this;
        }

        public Builder beginSnIdGreaterThanOrEqualTo(Integer beginSnIdGreaterThanOrEqualTo) {
            this.beginSnIdGreaterThanOrEqualTo = beginSnIdGreaterThanOrEqualTo;
            return this;
        }

        public Builder endSnIdLessThanOrEqualTo(Integer endSnIdLessThanOrEqualTo) {
            this.endSnIdLessThanOrEqualTo = endSnIdLessThanOrEqualTo;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        public Builder containerId(Integer containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAwrDbSqlReportRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.awrDbId(o.getAwrDbId());
            this.sqlId(o.getSqlId());
            this.instNum(o.getInstNum());
            this.beginSnIdGreaterThanOrEqualTo(o.getBeginSnIdGreaterThanOrEqualTo());
            this.endSnIdLessThanOrEqualTo(o.getEndSnIdLessThanOrEqualTo());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.reportFormat(o.getReportFormat());
            this.containerId(o.getContainerId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAwrDbSqlReportRequest build() {
            GetAwrDbSqlReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAwrDbSqlReportRequest buildWithoutInvocationCallback() {
            GetAwrDbSqlReportRequest request = new GetAwrDbSqlReportRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.awrDbId = this.awrDbId;
            request.sqlId = this.sqlId;
            request.instNum = this.instNum;
            request.beginSnIdGreaterThanOrEqualTo = this.beginSnIdGreaterThanOrEqualTo;
            request.endSnIdLessThanOrEqualTo = this.endSnIdLessThanOrEqualTo;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.reportFormat = this.reportFormat;
            request.containerId = this.containerId;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }

    public static enum ReportFormat implements BmcEnum
    {
        Html("HTML"),
        Text("TEXT");

        private final String value;
        private static Map<String, ReportFormat> map;

        private ReportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportFormat: " + key);
        }

        static {
            map = new HashMap<String, ReportFormat>();
            for (ReportFormat v : ReportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

