/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalDbSystemDiscoveryRequest
extends BmcRequest<Void> {
    private String externalDbSystemDiscoveryId;
    private String opcRequestId;

    public String getExternalDbSystemDiscoveryId() {
        return this.externalDbSystemDiscoveryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalDbSystemDiscoveryId(this.externalDbSystemDiscoveryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalDbSystemDiscoveryId=").append(String.valueOf(this.externalDbSystemDiscoveryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalDbSystemDiscoveryRequest)) {
            return false;
        }
        GetExternalDbSystemDiscoveryRequest other = (GetExternalDbSystemDiscoveryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalDbSystemDiscoveryId, other.externalDbSystemDiscoveryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalDbSystemDiscoveryId == null ? 43 : this.externalDbSystemDiscoveryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalDbSystemDiscoveryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalDbSystemDiscoveryId = null;
        private String opcRequestId = null;

        public Builder externalDbSystemDiscoveryId(String externalDbSystemDiscoveryId) {
            this.externalDbSystemDiscoveryId = externalDbSystemDiscoveryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalDbSystemDiscoveryRequest o) {
            this.externalDbSystemDiscoveryId(o.getExternalDbSystemDiscoveryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalDbSystemDiscoveryRequest build() {
            GetExternalDbSystemDiscoveryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalDbSystemDiscoveryRequest buildWithoutInvocationCallback() {
            GetExternalDbSystemDiscoveryRequest request = new GetExternalDbSystemDiscoveryRequest();
            request.externalDbSystemDiscoveryId = this.externalDbSystemDiscoveryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

