/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.math.BigDecimal;
import java.util.Objects;

public class GetOptimizerStatisticsCollectionOperationRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private BigDecimal optimizerStatisticsCollectionOperationId;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public BigDecimal getOptimizerStatisticsCollectionOperationId() {
        return this.optimizerStatisticsCollectionOperationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).optimizerStatisticsCollectionOperationId(this.optimizerStatisticsCollectionOperationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",optimizerStatisticsCollectionOperationId=").append(String.valueOf(this.optimizerStatisticsCollectionOperationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOptimizerStatisticsCollectionOperationRequest)) {
            return false;
        }
        GetOptimizerStatisticsCollectionOperationRequest other = (GetOptimizerStatisticsCollectionOperationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.optimizerStatisticsCollectionOperationId, other.optimizerStatisticsCollectionOperationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.optimizerStatisticsCollectionOperationId == null ? 43 : this.optimizerStatisticsCollectionOperationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOptimizerStatisticsCollectionOperationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private BigDecimal optimizerStatisticsCollectionOperationId = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder optimizerStatisticsCollectionOperationId(BigDecimal optimizerStatisticsCollectionOperationId) {
            this.optimizerStatisticsCollectionOperationId = optimizerStatisticsCollectionOperationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOptimizerStatisticsCollectionOperationRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.optimizerStatisticsCollectionOperationId(o.getOptimizerStatisticsCollectionOperationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOptimizerStatisticsCollectionOperationRequest build() {
            GetOptimizerStatisticsCollectionOperationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOptimizerStatisticsCollectionOperationRequest buildWithoutInvocationCallback() {
            GetOptimizerStatisticsCollectionOperationRequest request = new GetOptimizerStatisticsCollectionOperationRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.optimizerStatisticsCollectionOperationId = this.optimizerStatisticsCollectionOperationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

