/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.ResizeDataFileDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ResizeDataFileRequest
extends BmcRequest<ResizeDataFileDetails> {
    private String managedDatabaseId;
    private String tablespaceName;
    private ResizeDataFileDetails resizeDataFileDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public ResizeDataFileDetails getResizeDataFileDetails() {
        return this.resizeDataFileDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ResizeDataFileDetails getBody$() {
        return this.resizeDataFileDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).tablespaceName(this.tablespaceName).resizeDataFileDetails(this.resizeDataFileDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",tablespaceName=").append(String.valueOf(this.tablespaceName));
        sb.append(",resizeDataFileDetails=").append(String.valueOf((Object)this.resizeDataFileDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResizeDataFileRequest)) {
            return false;
        }
        ResizeDataFileRequest other = (ResizeDataFileRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.tablespaceName, other.tablespaceName) && Objects.equals((Object)this.resizeDataFileDetails, (Object)other.resizeDataFileDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.tablespaceName == null ? 43 : this.tablespaceName.hashCode());
        result = result * 59 + (this.resizeDataFileDetails == null ? 43 : this.resizeDataFileDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ResizeDataFileRequest, ResizeDataFileDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String tablespaceName = null;
        private ResizeDataFileDetails resizeDataFileDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder tablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
            return this;
        }

        public Builder resizeDataFileDetails(ResizeDataFileDetails resizeDataFileDetails) {
            this.resizeDataFileDetails = resizeDataFileDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ResizeDataFileRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.tablespaceName(o.getTablespaceName());
            this.resizeDataFileDetails(o.getResizeDataFileDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ResizeDataFileRequest build() {
            ResizeDataFileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ResizeDataFileDetails body) {
            this.resizeDataFileDetails(body);
            return this;
        }

        public ResizeDataFileRequest buildWithoutInvocationCallback() {
            ResizeDataFileRequest request = new ResizeDataFileRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.tablespaceName = this.tablespaceName;
            request.resizeDataFileDetails = this.resizeDataFileDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

