/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseCredentialDetails;
import com.oracle.bmc.databasemanagement.model.TablespaceAdminCredentialDetails;
import com.oracle.bmc.databasemanagement.model.TablespaceStorageSize;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddDataFilesDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="credentialDetails")
    private final TablespaceAdminCredentialDetails credentialDetails;
    @JsonProperty(value="databaseCredential")
    private final DatabaseCredentialDetails databaseCredential;
    @JsonProperty(value="fileType")
    private final FileType fileType;
    @JsonProperty(value="dataFiles")
    private final List<String> dataFiles;
    @JsonProperty(value="fileCount")
    private final Integer fileCount;
    @JsonProperty(value="fileSize")
    private final TablespaceStorageSize fileSize;
    @JsonProperty(value="isReusable")
    private final Boolean isReusable;
    @JsonProperty(value="isAutoExtensible")
    private final Boolean isAutoExtensible;
    @JsonProperty(value="autoExtendNextSize")
    private final TablespaceStorageSize autoExtendNextSize;
    @JsonProperty(value="autoExtendMaxSize")
    private final TablespaceStorageSize autoExtendMaxSize;
    @JsonProperty(value="isMaxSizeUnlimited")
    private final Boolean isMaxSizeUnlimited;

    @Deprecated
    @ConstructorProperties(value={"credentialDetails", "databaseCredential", "fileType", "dataFiles", "fileCount", "fileSize", "isReusable", "isAutoExtensible", "autoExtendNextSize", "autoExtendMaxSize", "isMaxSizeUnlimited"})
    public AddDataFilesDetails(TablespaceAdminCredentialDetails credentialDetails, DatabaseCredentialDetails databaseCredential, FileType fileType, List<String> dataFiles, Integer fileCount, TablespaceStorageSize fileSize, Boolean isReusable, Boolean isAutoExtensible, TablespaceStorageSize autoExtendNextSize, TablespaceStorageSize autoExtendMaxSize, Boolean isMaxSizeUnlimited) {
        this.credentialDetails = credentialDetails;
        this.databaseCredential = databaseCredential;
        this.fileType = fileType;
        this.dataFiles = dataFiles;
        this.fileCount = fileCount;
        this.fileSize = fileSize;
        this.isReusable = isReusable;
        this.isAutoExtensible = isAutoExtensible;
        this.autoExtendNextSize = autoExtendNextSize;
        this.autoExtendMaxSize = autoExtendMaxSize;
        this.isMaxSizeUnlimited = isMaxSizeUnlimited;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TablespaceAdminCredentialDetails getCredentialDetails() {
        return this.credentialDetails;
    }

    public DatabaseCredentialDetails getDatabaseCredential() {
        return this.databaseCredential;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public List<String> getDataFiles() {
        return this.dataFiles;
    }

    public Integer getFileCount() {
        return this.fileCount;
    }

    public TablespaceStorageSize getFileSize() {
        return this.fileSize;
    }

    public Boolean getIsReusable() {
        return this.isReusable;
    }

    public Boolean getIsAutoExtensible() {
        return this.isAutoExtensible;
    }

    public TablespaceStorageSize getAutoExtendNextSize() {
        return this.autoExtendNextSize;
    }

    public TablespaceStorageSize getAutoExtendMaxSize() {
        return this.autoExtendMaxSize;
    }

    public Boolean getIsMaxSizeUnlimited() {
        return this.isMaxSizeUnlimited;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddDataFilesDetails(");
        sb.append("super=").append(super.toString());
        sb.append("credentialDetails=").append(String.valueOf((Object)this.credentialDetails));
        sb.append(", databaseCredential=").append(String.valueOf((Object)this.databaseCredential));
        sb.append(", fileType=").append(String.valueOf((Object)this.fileType));
        sb.append(", dataFiles=").append(String.valueOf(this.dataFiles));
        sb.append(", fileCount=").append(String.valueOf(this.fileCount));
        sb.append(", fileSize=").append(String.valueOf((Object)this.fileSize));
        sb.append(", isReusable=").append(String.valueOf(this.isReusable));
        sb.append(", isAutoExtensible=").append(String.valueOf(this.isAutoExtensible));
        sb.append(", autoExtendNextSize=").append(String.valueOf((Object)this.autoExtendNextSize));
        sb.append(", autoExtendMaxSize=").append(String.valueOf((Object)this.autoExtendMaxSize));
        sb.append(", isMaxSizeUnlimited=").append(String.valueOf(this.isMaxSizeUnlimited));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddDataFilesDetails)) {
            return false;
        }
        AddDataFilesDetails other = (AddDataFilesDetails)((Object)o);
        return Objects.equals((Object)this.credentialDetails, (Object)other.credentialDetails) && Objects.equals((Object)this.databaseCredential, (Object)other.databaseCredential) && Objects.equals((Object)this.fileType, (Object)other.fileType) && Objects.equals(this.dataFiles, other.dataFiles) && Objects.equals(this.fileCount, other.fileCount) && Objects.equals((Object)this.fileSize, (Object)other.fileSize) && Objects.equals(this.isReusable, other.isReusable) && Objects.equals(this.isAutoExtensible, other.isAutoExtensible) && Objects.equals((Object)this.autoExtendNextSize, (Object)other.autoExtendNextSize) && Objects.equals((Object)this.autoExtendMaxSize, (Object)other.autoExtendMaxSize) && Objects.equals(this.isMaxSizeUnlimited, other.isMaxSizeUnlimited) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.credentialDetails == null ? 43 : this.credentialDetails.hashCode());
        result = result * 59 + (this.databaseCredential == null ? 43 : this.databaseCredential.hashCode());
        result = result * 59 + (this.fileType == null ? 43 : this.fileType.hashCode());
        result = result * 59 + (this.dataFiles == null ? 43 : this.dataFiles.hashCode());
        result = result * 59 + (this.fileCount == null ? 43 : this.fileCount.hashCode());
        result = result * 59 + (this.fileSize == null ? 43 : this.fileSize.hashCode());
        result = result * 59 + (this.isReusable == null ? 43 : this.isReusable.hashCode());
        result = result * 59 + (this.isAutoExtensible == null ? 43 : this.isAutoExtensible.hashCode());
        result = result * 59 + (this.autoExtendNextSize == null ? 43 : this.autoExtendNextSize.hashCode());
        result = result * 59 + (this.autoExtendMaxSize == null ? 43 : this.autoExtendMaxSize.hashCode());
        result = result * 59 + (this.isMaxSizeUnlimited == null ? 43 : this.isMaxSizeUnlimited.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FileType implements BmcEnum
    {
        Datafile("DATAFILE"),
        Tempfile("TEMPFILE");

        private final String value;
        private static Map<String, FileType> map;

        private FileType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FileType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid FileType: " + key);
        }

        static {
            map = new HashMap<String, FileType>();
            for (FileType v : FileType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialDetails")
        private TablespaceAdminCredentialDetails credentialDetails;
        @JsonProperty(value="databaseCredential")
        private DatabaseCredentialDetails databaseCredential;
        @JsonProperty(value="fileType")
        private FileType fileType;
        @JsonProperty(value="dataFiles")
        private List<String> dataFiles;
        @JsonProperty(value="fileCount")
        private Integer fileCount;
        @JsonProperty(value="fileSize")
        private TablespaceStorageSize fileSize;
        @JsonProperty(value="isReusable")
        private Boolean isReusable;
        @JsonProperty(value="isAutoExtensible")
        private Boolean isAutoExtensible;
        @JsonProperty(value="autoExtendNextSize")
        private TablespaceStorageSize autoExtendNextSize;
        @JsonProperty(value="autoExtendMaxSize")
        private TablespaceStorageSize autoExtendMaxSize;
        @JsonProperty(value="isMaxSizeUnlimited")
        private Boolean isMaxSizeUnlimited;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialDetails(TablespaceAdminCredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            this.__explicitlySet__.add("credentialDetails");
            return this;
        }

        public Builder databaseCredential(DatabaseCredentialDetails databaseCredential) {
            this.databaseCredential = databaseCredential;
            this.__explicitlySet__.add("databaseCredential");
            return this;
        }

        public Builder fileType(FileType fileType) {
            this.fileType = fileType;
            this.__explicitlySet__.add("fileType");
            return this;
        }

        public Builder dataFiles(List<String> dataFiles) {
            this.dataFiles = dataFiles;
            this.__explicitlySet__.add("dataFiles");
            return this;
        }

        public Builder fileCount(Integer fileCount) {
            this.fileCount = fileCount;
            this.__explicitlySet__.add("fileCount");
            return this;
        }

        public Builder fileSize(TablespaceStorageSize fileSize) {
            this.fileSize = fileSize;
            this.__explicitlySet__.add("fileSize");
            return this;
        }

        public Builder isReusable(Boolean isReusable) {
            this.isReusable = isReusable;
            this.__explicitlySet__.add("isReusable");
            return this;
        }

        public Builder isAutoExtensible(Boolean isAutoExtensible) {
            this.isAutoExtensible = isAutoExtensible;
            this.__explicitlySet__.add("isAutoExtensible");
            return this;
        }

        public Builder autoExtendNextSize(TablespaceStorageSize autoExtendNextSize) {
            this.autoExtendNextSize = autoExtendNextSize;
            this.__explicitlySet__.add("autoExtendNextSize");
            return this;
        }

        public Builder autoExtendMaxSize(TablespaceStorageSize autoExtendMaxSize) {
            this.autoExtendMaxSize = autoExtendMaxSize;
            this.__explicitlySet__.add("autoExtendMaxSize");
            return this;
        }

        public Builder isMaxSizeUnlimited(Boolean isMaxSizeUnlimited) {
            this.isMaxSizeUnlimited = isMaxSizeUnlimited;
            this.__explicitlySet__.add("isMaxSizeUnlimited");
            return this;
        }

        public AddDataFilesDetails build() {
            AddDataFilesDetails model = new AddDataFilesDetails(this.credentialDetails, this.databaseCredential, this.fileType, this.dataFiles, this.fileCount, this.fileSize, this.isReusable, this.isAutoExtensible, this.autoExtendNextSize, this.autoExtendMaxSize, this.isMaxSizeUnlimited);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddDataFilesDetails model) {
            if (model.wasPropertyExplicitlySet("credentialDetails")) {
                this.credentialDetails(model.getCredentialDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseCredential")) {
                this.databaseCredential(model.getDatabaseCredential());
            }
            if (model.wasPropertyExplicitlySet("fileType")) {
                this.fileType(model.getFileType());
            }
            if (model.wasPropertyExplicitlySet("dataFiles")) {
                this.dataFiles(model.getDataFiles());
            }
            if (model.wasPropertyExplicitlySet("fileCount")) {
                this.fileCount(model.getFileCount());
            }
            if (model.wasPropertyExplicitlySet("fileSize")) {
                this.fileSize(model.getFileSize());
            }
            if (model.wasPropertyExplicitlySet("isReusable")) {
                this.isReusable(model.getIsReusable());
            }
            if (model.wasPropertyExplicitlySet("isAutoExtensible")) {
                this.isAutoExtensible(model.getIsAutoExtensible());
            }
            if (model.wasPropertyExplicitlySet("autoExtendNextSize")) {
                this.autoExtendNextSize(model.getAutoExtendNextSize());
            }
            if (model.wasPropertyExplicitlySet("autoExtendMaxSize")) {
                this.autoExtendMaxSize(model.getAutoExtendMaxSize());
            }
            if (model.wasPropertyExplicitlySet("isMaxSizeUnlimited")) {
                this.isMaxSizeUnlimited(model.getIsMaxSizeUnlimited());
            }
            return this;
        }
    }
}

