/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutomaticCaptureFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final Name name;
    @JsonProperty(value="valuesToInclude")
    private final List<String> valuesToInclude;
    @JsonProperty(value="valuesToExclude")
    private final List<String> valuesToExclude;
    @JsonProperty(value="timeLastModified")
    private final Date timeLastModified;
    @JsonProperty(value="modifiedBy")
    private final String modifiedBy;

    @Deprecated
    @ConstructorProperties(value={"name", "valuesToInclude", "valuesToExclude", "timeLastModified", "modifiedBy"})
    public AutomaticCaptureFilter(Name name, List<String> valuesToInclude, List<String> valuesToExclude, Date timeLastModified, String modifiedBy) {
        this.name = name;
        this.valuesToInclude = valuesToInclude;
        this.valuesToExclude = valuesToExclude;
        this.timeLastModified = timeLastModified;
        this.modifiedBy = modifiedBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Name getName() {
        return this.name;
    }

    public List<String> getValuesToInclude() {
        return this.valuesToInclude;
    }

    public List<String> getValuesToExclude() {
        return this.valuesToExclude;
    }

    public Date getTimeLastModified() {
        return this.timeLastModified;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutomaticCaptureFilter(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf((Object)this.name));
        sb.append(", valuesToInclude=").append(String.valueOf(this.valuesToInclude));
        sb.append(", valuesToExclude=").append(String.valueOf(this.valuesToExclude));
        sb.append(", timeLastModified=").append(String.valueOf(this.timeLastModified));
        sb.append(", modifiedBy=").append(String.valueOf(this.modifiedBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutomaticCaptureFilter)) {
            return false;
        }
        AutomaticCaptureFilter other = (AutomaticCaptureFilter)((Object)o);
        return Objects.equals((Object)this.name, (Object)other.name) && Objects.equals(this.valuesToInclude, other.valuesToInclude) && Objects.equals(this.valuesToExclude, other.valuesToExclude) && Objects.equals(this.timeLastModified, other.timeLastModified) && Objects.equals(this.modifiedBy, other.modifiedBy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.valuesToInclude == null ? 43 : this.valuesToInclude.hashCode());
        result = result * 59 + (this.valuesToExclude == null ? 43 : this.valuesToExclude.hashCode());
        result = result * 59 + (this.timeLastModified == null ? 43 : this.timeLastModified.hashCode());
        result = result * 59 + (this.modifiedBy == null ? 43 : this.modifiedBy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Name implements BmcEnum
    {
        AutoCaptureSqlText("AUTO_CAPTURE_SQL_TEXT"),
        AutoCaptureParsingSchemaName("AUTO_CAPTURE_PARSING_SCHEMA_NAME"),
        AutoCaptureModule("AUTO_CAPTURE_MODULE"),
        AutoCaptureAction("AUTO_CAPTURE_ACTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Name> map;

        private Name(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Name create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Name', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Name.class);
            map = new HashMap<String, Name>();
            for (Name v : Name.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private Name name;
        @JsonProperty(value="valuesToInclude")
        private List<String> valuesToInclude;
        @JsonProperty(value="valuesToExclude")
        private List<String> valuesToExclude;
        @JsonProperty(value="timeLastModified")
        private Date timeLastModified;
        @JsonProperty(value="modifiedBy")
        private String modifiedBy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(Name name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder valuesToInclude(List<String> valuesToInclude) {
            this.valuesToInclude = valuesToInclude;
            this.__explicitlySet__.add("valuesToInclude");
            return this;
        }

        public Builder valuesToExclude(List<String> valuesToExclude) {
            this.valuesToExclude = valuesToExclude;
            this.__explicitlySet__.add("valuesToExclude");
            return this;
        }

        public Builder timeLastModified(Date timeLastModified) {
            this.timeLastModified = timeLastModified;
            this.__explicitlySet__.add("timeLastModified");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.__explicitlySet__.add("modifiedBy");
            return this;
        }

        public AutomaticCaptureFilter build() {
            AutomaticCaptureFilter model = new AutomaticCaptureFilter(this.name, this.valuesToInclude, this.valuesToExclude, this.timeLastModified, this.modifiedBy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutomaticCaptureFilter model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("valuesToInclude")) {
                this.valuesToInclude(model.getValuesToInclude());
            }
            if (model.wasPropertyExplicitlySet("valuesToExclude")) {
                this.valuesToExclude(model.getValuesToExclude());
            }
            if (model.wasPropertyExplicitlySet("timeLastModified")) {
                this.timeLastModified(model.getTimeLastModified());
            }
            if (model.wasPropertyExplicitlySet("modifiedBy")) {
                this.modifiedBy(model.getModifiedBy());
            }
            return this;
        }
    }
}

