/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.NamedCredentialContent;
import com.oracle.bmc.databasemanagement.model.PasswordSecretAccessMode;
import com.oracle.bmc.databasemanagement.model.Role;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType")
@JsonFilter(value="explicitlySetFilter")
public final class BasicNamedCredentialContent
extends NamedCredentialContent {
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="passwordSecretId")
    private final String passwordSecretId;
    @JsonProperty(value="passwordSecretAccessMode")
    private final PasswordSecretAccessMode passwordSecretAccessMode;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BasicNamedCredentialContent(String userName, Role role, String passwordSecretId, PasswordSecretAccessMode passwordSecretAccessMode) {
        this.userName = userName;
        this.role = role;
        this.passwordSecretId = passwordSecretId;
        this.passwordSecretAccessMode = passwordSecretAccessMode;
    }

    public String getUserName() {
        return this.userName;
    }

    public Role getRole() {
        return this.role;
    }

    public String getPasswordSecretId() {
        return this.passwordSecretId;
    }

    public PasswordSecretAccessMode getPasswordSecretAccessMode() {
        return this.passwordSecretAccessMode;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicNamedCredentialContent(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", passwordSecretId=").append(String.valueOf(this.passwordSecretId));
        sb.append(", passwordSecretAccessMode=").append(String.valueOf((Object)this.passwordSecretAccessMode));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicNamedCredentialContent)) {
            return false;
        }
        BasicNamedCredentialContent other = (BasicNamedCredentialContent)((Object)o);
        return Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.passwordSecretId, other.passwordSecretId) && Objects.equals((Object)this.passwordSecretAccessMode, (Object)other.passwordSecretAccessMode) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.passwordSecretId == null ? 43 : this.passwordSecretId.hashCode());
        result = result * 59 + (this.passwordSecretAccessMode == null ? 43 : this.passwordSecretAccessMode.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="passwordSecretId")
        private String passwordSecretId;
        @JsonProperty(value="passwordSecretAccessMode")
        private PasswordSecretAccessMode passwordSecretAccessMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder passwordSecretId(String passwordSecretId) {
            this.passwordSecretId = passwordSecretId;
            this.__explicitlySet__.add("passwordSecretId");
            return this;
        }

        public Builder passwordSecretAccessMode(PasswordSecretAccessMode passwordSecretAccessMode) {
            this.passwordSecretAccessMode = passwordSecretAccessMode;
            this.__explicitlySet__.add("passwordSecretAccessMode");
            return this;
        }

        public BasicNamedCredentialContent build() {
            BasicNamedCredentialContent model = new BasicNamedCredentialContent(this.userName, this.role, this.passwordSecretId, this.passwordSecretAccessMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BasicNamedCredentialContent model) {
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("passwordSecretId")) {
                this.passwordSecretId(model.getPasswordSecretId());
            }
            if (model.wasPropertyExplicitlySet("passwordSecretAccessMode")) {
                this.passwordSecretAccessMode(model.getPasswordSecretAccessMode());
            }
            return this;
        }
    }
}

