/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.ExternalDatabaseSystemDiscoverySummary;
import com.oracle.bmc.databasemanagement.model.ExternalExadataInfrastructureDiscovery;
import com.oracle.bmc.databasemanagement.model.ExternalExadataInfrastructureDiscoverySummary;
import com.oracle.bmc.databasemanagement.model.ExternalStorageGridDiscoverySummary;
import com.oracle.bmc.databasemanagement.model.ExternalStorageServerDiscoverySummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType", defaultImpl=EntityDiscovered.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExternalStorageGridDiscoverySummary.class, name="STORAGE_GRID_DISCOVER_SUMMARY"), @JsonSubTypes.Type(value=ExternalExadataInfrastructureDiscovery.class, name="INFRASTRUCTURE_DISCOVER"), @JsonSubTypes.Type(value=ExternalDatabaseSystemDiscoverySummary.class, name="DATABASE_SYSTEM_DISCOVER_SUMMARY"), @JsonSubTypes.Type(value=ExternalExadataInfrastructureDiscoverySummary.class, name="INFRASTRUCTURE_DISCOVER_SUMMARY"), @JsonSubTypes.Type(value=ExternalStorageServerDiscoverySummary.class, name="STORAGE_SERVER_DISCOVER_SUMMARY")})
@JsonFilter(value="explicitlySetFilter")
public class EntityDiscovered
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="connectorId")
    private final String connectorId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="internalId")
    private final String internalId;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="discoverStatus")
    private final DiscoverStatus discoverStatus;
    @JsonProperty(value="discoverErrorCode")
    private final String discoverErrorCode;
    @JsonProperty(value="discoverErrorMsg")
    private final String discoverErrorMsg;

    @Deprecated
    @ConstructorProperties(value={"id", "agentId", "connectorId", "displayName", "version", "internalId", "status", "discoverStatus", "discoverErrorCode", "discoverErrorMsg"})
    protected EntityDiscovered(String id, String agentId, String connectorId, String displayName, String version, String internalId, String status, DiscoverStatus discoverStatus, String discoverErrorCode, String discoverErrorMsg) {
        this.id = id;
        this.agentId = agentId;
        this.connectorId = connectorId;
        this.displayName = displayName;
        this.version = version;
        this.internalId = internalId;
        this.status = status;
        this.discoverStatus = discoverStatus;
        this.discoverErrorCode = discoverErrorCode;
        this.discoverErrorMsg = discoverErrorMsg;
    }

    public String getId() {
        return this.id;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public String getStatus() {
        return this.status;
    }

    public DiscoverStatus getDiscoverStatus() {
        return this.discoverStatus;
    }

    public String getDiscoverErrorCode() {
        return this.discoverErrorCode;
    }

    public String getDiscoverErrorMsg() {
        return this.discoverErrorMsg;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityDiscovered(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", agentId=").append(String.valueOf(this.agentId));
        sb.append(", connectorId=").append(String.valueOf(this.connectorId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", internalId=").append(String.valueOf(this.internalId));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", discoverStatus=").append(String.valueOf((Object)this.discoverStatus));
        sb.append(", discoverErrorCode=").append(String.valueOf(this.discoverErrorCode));
        sb.append(", discoverErrorMsg=").append(String.valueOf(this.discoverErrorMsg));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityDiscovered)) {
            return false;
        }
        EntityDiscovered other = (EntityDiscovered)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.version, other.version) && Objects.equals(this.internalId, other.internalId) && Objects.equals(this.status, other.status) && Objects.equals((Object)this.discoverStatus, (Object)other.discoverStatus) && Objects.equals(this.discoverErrorCode, other.discoverErrorCode) && Objects.equals(this.discoverErrorMsg, other.discoverErrorMsg) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.connectorId == null ? 43 : this.connectorId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.internalId == null ? 43 : this.internalId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.discoverStatus == null ? 43 : this.discoverStatus.hashCode());
        result = result * 59 + (this.discoverErrorCode == null ? 43 : this.discoverErrorCode.hashCode());
        result = result * 59 + (this.discoverErrorMsg == null ? 43 : this.discoverErrorMsg.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EntityType implements BmcEnum
    {
        StorageServerDiscoverSummary("STORAGE_SERVER_DISCOVER_SUMMARY"),
        StorageGridDiscoverSummary("STORAGE_GRID_DISCOVER_SUMMARY"),
        DatabaseSystemDiscoverSummary("DATABASE_SYSTEM_DISCOVER_SUMMARY"),
        InfrastructureDiscoverSummary("INFRASTRUCTURE_DISCOVER_SUMMARY"),
        InfrastructureDiscover("INFRASTRUCTURE_DISCOVER");

        private final String value;
        private static Map<String, EntityType> map;

        private EntityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EntityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EntityType: " + key);
        }

        static {
            map = new HashMap<String, EntityType>();
            for (EntityType v : EntityType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DiscoverStatus implements BmcEnum
    {
        PrevDiscovered("PREV_DISCOVERED"),
        NewDiscovered("NEW_DISCOVERED"),
        NotFound("NOT_FOUND"),
        Discovering("DISCOVERING");

        private final String value;
        private static Map<String, DiscoverStatus> map;

        private DiscoverStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiscoverStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DiscoverStatus: " + key);
        }

        static {
            map = new HashMap<String, DiscoverStatus>();
            for (DiscoverStatus v : DiscoverStatus.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

