/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ExternalClusterNetworkConfiguration;
import com.oracle.bmc.databasemanagement.model.ExternalClusterScanListenerConfiguration;
import com.oracle.bmc.databasemanagement.model.ExternalClusterVipConfiguration;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalCluster
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="componentName")
    private final String componentName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="externalDbSystemId")
    private final String externalDbSystemId;
    @JsonProperty(value="externalConnectorId")
    private final String externalConnectorId;
    @JsonProperty(value="gridHome")
    private final String gridHome;
    @JsonProperty(value="isFlexCluster")
    private final Boolean isFlexCluster;
    @JsonProperty(value="additionalDetails")
    private final Map<String, String> additionalDetails;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="networkConfigurations")
    private final List<ExternalClusterNetworkConfiguration> networkConfigurations;
    @JsonProperty(value="vipConfigurations")
    private final List<ExternalClusterVipConfiguration> vipConfigurations;
    @JsonProperty(value="scanConfigurations")
    private final List<ExternalClusterScanListenerConfiguration> scanConfigurations;
    @JsonProperty(value="ocrFileLocation")
    private final String ocrFileLocation;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "componentName", "compartmentId", "externalDbSystemId", "externalConnectorId", "gridHome", "isFlexCluster", "additionalDetails", "lifecycleState", "lifecycleDetails", "networkConfigurations", "vipConfigurations", "scanConfigurations", "ocrFileLocation", "timeCreated", "timeUpdated", "version", "freeformTags", "definedTags"})
    public ExternalCluster(String id, String displayName, String componentName, String compartmentId, String externalDbSystemId, String externalConnectorId, String gridHome, Boolean isFlexCluster, Map<String, String> additionalDetails, LifecycleState lifecycleState, String lifecycleDetails, List<ExternalClusterNetworkConfiguration> networkConfigurations, List<ExternalClusterVipConfiguration> vipConfigurations, List<ExternalClusterScanListenerConfiguration> scanConfigurations, String ocrFileLocation, Date timeCreated, Date timeUpdated, String version, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.displayName = displayName;
        this.componentName = componentName;
        this.compartmentId = compartmentId;
        this.externalDbSystemId = externalDbSystemId;
        this.externalConnectorId = externalConnectorId;
        this.gridHome = gridHome;
        this.isFlexCluster = isFlexCluster;
        this.additionalDetails = additionalDetails;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.networkConfigurations = networkConfigurations;
        this.vipConfigurations = vipConfigurations;
        this.scanConfigurations = scanConfigurations;
        this.ocrFileLocation = ocrFileLocation;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.version = version;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getExternalDbSystemId() {
        return this.externalDbSystemId;
    }

    public String getExternalConnectorId() {
        return this.externalConnectorId;
    }

    public String getGridHome() {
        return this.gridHome;
    }

    public Boolean getIsFlexCluster() {
        return this.isFlexCluster;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<ExternalClusterNetworkConfiguration> getNetworkConfigurations() {
        return this.networkConfigurations;
    }

    public List<ExternalClusterVipConfiguration> getVipConfigurations() {
        return this.vipConfigurations;
    }

    public List<ExternalClusterScanListenerConfiguration> getScanConfigurations() {
        return this.scanConfigurations;
    }

    public String getOcrFileLocation() {
        return this.ocrFileLocation;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalCluster(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", componentName=").append(String.valueOf(this.componentName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", externalDbSystemId=").append(String.valueOf(this.externalDbSystemId));
        sb.append(", externalConnectorId=").append(String.valueOf(this.externalConnectorId));
        sb.append(", gridHome=").append(String.valueOf(this.gridHome));
        sb.append(", isFlexCluster=").append(String.valueOf(this.isFlexCluster));
        sb.append(", additionalDetails=").append(String.valueOf(this.additionalDetails));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", networkConfigurations=").append(String.valueOf(this.networkConfigurations));
        sb.append(", vipConfigurations=").append(String.valueOf(this.vipConfigurations));
        sb.append(", scanConfigurations=").append(String.valueOf(this.scanConfigurations));
        sb.append(", ocrFileLocation=").append(String.valueOf(this.ocrFileLocation));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalCluster)) {
            return false;
        }
        ExternalCluster other = (ExternalCluster)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.componentName, other.componentName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.externalDbSystemId, other.externalDbSystemId) && Objects.equals(this.externalConnectorId, other.externalConnectorId) && Objects.equals(this.gridHome, other.gridHome) && Objects.equals(this.isFlexCluster, other.isFlexCluster) && Objects.equals(this.additionalDetails, other.additionalDetails) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.networkConfigurations, other.networkConfigurations) && Objects.equals(this.vipConfigurations, other.vipConfigurations) && Objects.equals(this.scanConfigurations, other.scanConfigurations) && Objects.equals(this.ocrFileLocation, other.ocrFileLocation) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.version, other.version) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.componentName == null ? 43 : this.componentName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.externalDbSystemId == null ? 43 : this.externalDbSystemId.hashCode());
        result = result * 59 + (this.externalConnectorId == null ? 43 : this.externalConnectorId.hashCode());
        result = result * 59 + (this.gridHome == null ? 43 : this.gridHome.hashCode());
        result = result * 59 + (this.isFlexCluster == null ? 43 : this.isFlexCluster.hashCode());
        result = result * 59 + (this.additionalDetails == null ? 43 : this.additionalDetails.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.networkConfigurations == null ? 43 : this.networkConfigurations.hashCode());
        result = result * 59 + (this.vipConfigurations == null ? 43 : this.vipConfigurations.hashCode());
        result = result * 59 + (this.scanConfigurations == null ? 43 : this.scanConfigurations.hashCode());
        result = result * 59 + (this.ocrFileLocation == null ? 43 : this.ocrFileLocation.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        NotConnected("NOT_CONNECTED"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="componentName")
        private String componentName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="externalDbSystemId")
        private String externalDbSystemId;
        @JsonProperty(value="externalConnectorId")
        private String externalConnectorId;
        @JsonProperty(value="gridHome")
        private String gridHome;
        @JsonProperty(value="isFlexCluster")
        private Boolean isFlexCluster;
        @JsonProperty(value="additionalDetails")
        private Map<String, String> additionalDetails;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="networkConfigurations")
        private List<ExternalClusterNetworkConfiguration> networkConfigurations;
        @JsonProperty(value="vipConfigurations")
        private List<ExternalClusterVipConfiguration> vipConfigurations;
        @JsonProperty(value="scanConfigurations")
        private List<ExternalClusterScanListenerConfiguration> scanConfigurations;
        @JsonProperty(value="ocrFileLocation")
        private String ocrFileLocation;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.__explicitlySet__.add("componentName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder externalDbSystemId(String externalDbSystemId) {
            this.externalDbSystemId = externalDbSystemId;
            this.__explicitlySet__.add("externalDbSystemId");
            return this;
        }

        public Builder externalConnectorId(String externalConnectorId) {
            this.externalConnectorId = externalConnectorId;
            this.__explicitlySet__.add("externalConnectorId");
            return this;
        }

        public Builder gridHome(String gridHome) {
            this.gridHome = gridHome;
            this.__explicitlySet__.add("gridHome");
            return this;
        }

        public Builder isFlexCluster(Boolean isFlexCluster) {
            this.isFlexCluster = isFlexCluster;
            this.__explicitlySet__.add("isFlexCluster");
            return this;
        }

        public Builder additionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.__explicitlySet__.add("additionalDetails");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder networkConfigurations(List<ExternalClusterNetworkConfiguration> networkConfigurations) {
            this.networkConfigurations = networkConfigurations;
            this.__explicitlySet__.add("networkConfigurations");
            return this;
        }

        public Builder vipConfigurations(List<ExternalClusterVipConfiguration> vipConfigurations) {
            this.vipConfigurations = vipConfigurations;
            this.__explicitlySet__.add("vipConfigurations");
            return this;
        }

        public Builder scanConfigurations(List<ExternalClusterScanListenerConfiguration> scanConfigurations) {
            this.scanConfigurations = scanConfigurations;
            this.__explicitlySet__.add("scanConfigurations");
            return this;
        }

        public Builder ocrFileLocation(String ocrFileLocation) {
            this.ocrFileLocation = ocrFileLocation;
            this.__explicitlySet__.add("ocrFileLocation");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public ExternalCluster build() {
            ExternalCluster model = new ExternalCluster(this.id, this.displayName, this.componentName, this.compartmentId, this.externalDbSystemId, this.externalConnectorId, this.gridHome, this.isFlexCluster, this.additionalDetails, this.lifecycleState, this.lifecycleDetails, this.networkConfigurations, this.vipConfigurations, this.scanConfigurations, this.ocrFileLocation, this.timeCreated, this.timeUpdated, this.version, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalCluster model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("componentName")) {
                this.componentName(model.getComponentName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("externalDbSystemId")) {
                this.externalDbSystemId(model.getExternalDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("externalConnectorId")) {
                this.externalConnectorId(model.getExternalConnectorId());
            }
            if (model.wasPropertyExplicitlySet("gridHome")) {
                this.gridHome(model.getGridHome());
            }
            if (model.wasPropertyExplicitlySet("isFlexCluster")) {
                this.isFlexCluster(model.getIsFlexCluster());
            }
            if (model.wasPropertyExplicitlySet("additionalDetails")) {
                this.additionalDetails(model.getAdditionalDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("networkConfigurations")) {
                this.networkConfigurations(model.getNetworkConfigurations());
            }
            if (model.wasPropertyExplicitlySet("vipConfigurations")) {
                this.vipConfigurations(model.getVipConfigurations());
            }
            if (model.wasPropertyExplicitlySet("scanConfigurations")) {
                this.scanConfigurations(model.getScanConfigurations());
            }
            if (model.wasPropertyExplicitlySet("ocrFileLocation")) {
                this.ocrFileLocation(model.getOcrFileLocation());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

