/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscoveryMacsConnector;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectorType", defaultImpl=ExternalDbSystemDiscoveryConnector.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExternalDbSystemDiscoveryMacsConnector.class, name="MACS")})
@JsonFilter(value="explicitlySetFilter")
public class ExternalDbSystemDiscoveryConnector
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="connectionStatus")
    private final String connectionStatus;
    @JsonProperty(value="connectionFailureMessage")
    private final String connectionFailureMessage;
    @JsonProperty(value="timeConnectionStatusLastUpdated")
    private final Date timeConnectionStatusLastUpdated;

    @Deprecated
    @ConstructorProperties(value={"displayName", "connectionStatus", "connectionFailureMessage", "timeConnectionStatusLastUpdated"})
    protected ExternalDbSystemDiscoveryConnector(String displayName, String connectionStatus, String connectionFailureMessage, Date timeConnectionStatusLastUpdated) {
        this.displayName = displayName;
        this.connectionStatus = connectionStatus;
        this.connectionFailureMessage = connectionFailureMessage;
        this.timeConnectionStatusLastUpdated = timeConnectionStatusLastUpdated;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public String getConnectionFailureMessage() {
        return this.connectionFailureMessage;
    }

    public Date getTimeConnectionStatusLastUpdated() {
        return this.timeConnectionStatusLastUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalDbSystemDiscoveryConnector(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", connectionStatus=").append(String.valueOf(this.connectionStatus));
        sb.append(", connectionFailureMessage=").append(String.valueOf(this.connectionFailureMessage));
        sb.append(", timeConnectionStatusLastUpdated=").append(String.valueOf(this.timeConnectionStatusLastUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalDbSystemDiscoveryConnector)) {
            return false;
        }
        ExternalDbSystemDiscoveryConnector other = (ExternalDbSystemDiscoveryConnector)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.connectionStatus, other.connectionStatus) && Objects.equals(this.connectionFailureMessage, other.connectionFailureMessage) && Objects.equals(this.timeConnectionStatusLastUpdated, other.timeConnectionStatusLastUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.connectionStatus == null ? 43 : this.connectionStatus.hashCode());
        result = result * 59 + (this.connectionFailureMessage == null ? 43 : this.connectionFailureMessage.hashCode());
        result = result * 59 + (this.timeConnectionStatusLastUpdated == null ? 43 : this.timeConnectionStatusLastUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConnectorType implements BmcEnum
    {
        Macs("MACS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConnectorType> map;

        private ConnectorType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConnectorType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConnectorType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConnectorType.class);
            map = new HashMap<String, ConnectorType>();
            for (ConnectorType v : ConnectorType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

