/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnectionInfo;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnector;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectorType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalDbSystemMacsConnector
extends ExternalDbSystemConnector {
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="connectionInfo")
    private final ExternalDbSystemConnectionInfo connectionInfo;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalDbSystemMacsConnector(String id, String displayName, String compartmentId, String externalDbSystemId, String connectionStatus, String connectionFailureMessage, ExternalDbSystemConnector.LifecycleState lifecycleState, String lifecycleDetails, Date timeConnectionStatusLastUpdated, Date timeCreated, Date timeUpdated, String agentId, ExternalDbSystemConnectionInfo connectionInfo, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        super(id, displayName, compartmentId, externalDbSystemId, connectionStatus, connectionFailureMessage, lifecycleState, lifecycleDetails, timeConnectionStatusLastUpdated, timeCreated, timeUpdated);
        this.agentId = agentId;
        this.connectionInfo = connectionInfo;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public ExternalDbSystemConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalDbSystemMacsConnector(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", agentId=").append(String.valueOf(this.agentId));
        sb.append(", connectionInfo=").append(String.valueOf((Object)this.connectionInfo));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalDbSystemMacsConnector)) {
            return false;
        }
        ExternalDbSystemMacsConnector other = (ExternalDbSystemMacsConnector)((Object)o);
        return Objects.equals(this.agentId, other.agentId) && Objects.equals((Object)this.connectionInfo, (Object)other.connectionInfo) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.connectionInfo == null ? 43 : this.connectionInfo.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="externalDbSystemId")
        private String externalDbSystemId;
        @JsonProperty(value="connectionStatus")
        private String connectionStatus;
        @JsonProperty(value="connectionFailureMessage")
        private String connectionFailureMessage;
        @JsonProperty(value="lifecycleState")
        private ExternalDbSystemConnector.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeConnectionStatusLastUpdated")
        private Date timeConnectionStatusLastUpdated;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="connectionInfo")
        private ExternalDbSystemConnectionInfo connectionInfo;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder externalDbSystemId(String externalDbSystemId) {
            this.externalDbSystemId = externalDbSystemId;
            this.__explicitlySet__.add("externalDbSystemId");
            return this;
        }

        public Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            this.__explicitlySet__.add("connectionStatus");
            return this;
        }

        public Builder connectionFailureMessage(String connectionFailureMessage) {
            this.connectionFailureMessage = connectionFailureMessage;
            this.__explicitlySet__.add("connectionFailureMessage");
            return this;
        }

        public Builder lifecycleState(ExternalDbSystemConnector.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeConnectionStatusLastUpdated(Date timeConnectionStatusLastUpdated) {
            this.timeConnectionStatusLastUpdated = timeConnectionStatusLastUpdated;
            this.__explicitlySet__.add("timeConnectionStatusLastUpdated");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder connectionInfo(ExternalDbSystemConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            this.__explicitlySet__.add("connectionInfo");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public ExternalDbSystemMacsConnector build() {
            ExternalDbSystemMacsConnector model = new ExternalDbSystemMacsConnector(this.id, this.displayName, this.compartmentId, this.externalDbSystemId, this.connectionStatus, this.connectionFailureMessage, this.lifecycleState, this.lifecycleDetails, this.timeConnectionStatusLastUpdated, this.timeCreated, this.timeUpdated, this.agentId, this.connectionInfo, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalDbSystemMacsConnector model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("externalDbSystemId")) {
                this.externalDbSystemId(model.getExternalDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("connectionStatus")) {
                this.connectionStatus(model.getConnectionStatus());
            }
            if (model.wasPropertyExplicitlySet("connectionFailureMessage")) {
                this.connectionFailureMessage(model.getConnectionFailureMessage());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeConnectionStatusLastUpdated")) {
                this.timeConnectionStatusLastUpdated(model.getTimeConnectionStatusLastUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("connectionInfo")) {
                this.connectionInfo(model.getConnectionInfo());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

