/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobInBind
extends ExplicitlySetBmcModel {
    @JsonProperty(value="position")
    private final Integer position;
    @JsonProperty(value="dataType")
    private final DataType dataType;
    @JsonProperty(value="values")
    private final List<String> values;
    @JsonProperty(value="arrayTypeName")
    private final String arrayTypeName;

    @Deprecated
    @ConstructorProperties(value={"position", "dataType", "values", "arrayTypeName"})
    public JobInBind(Integer position, DataType dataType, List<String> values, String arrayTypeName) {
        this.position = position;
        this.dataType = dataType;
        this.values = values;
        this.arrayTypeName = arrayTypeName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPosition() {
        return this.position;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getArrayTypeName() {
        return this.arrayTypeName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobInBind(");
        sb.append("super=").append(super.toString());
        sb.append("position=").append(String.valueOf(this.position));
        sb.append(", dataType=").append(String.valueOf((Object)this.dataType));
        sb.append(", values=").append(String.valueOf(this.values));
        sb.append(", arrayTypeName=").append(String.valueOf(this.arrayTypeName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobInBind)) {
            return false;
        }
        JobInBind other = (JobInBind)((Object)o);
        return Objects.equals(this.position, other.position) && Objects.equals((Object)this.dataType, (Object)other.dataType) && Objects.equals(this.values, other.values) && Objects.equals(this.arrayTypeName, other.arrayTypeName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.position == null ? 43 : this.position.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.values == null ? 43 : this.values.hashCode());
        result = result * 59 + (this.arrayTypeName == null ? 43 : this.arrayTypeName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DataType implements BmcEnum
    {
        Number("NUMBER"),
        String("STRING"),
        Clob("CLOB"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DataType> map;

        private DataType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DataType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DataType.class);
            map = new HashMap<String, DataType>();
            for (DataType v : DataType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="position")
        private Integer position;
        @JsonProperty(value="dataType")
        private DataType dataType;
        @JsonProperty(value="values")
        private List<String> values;
        @JsonProperty(value="arrayTypeName")
        private String arrayTypeName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder position(Integer position) {
            this.position = position;
            this.__explicitlySet__.add("position");
            return this;
        }

        public Builder dataType(DataType dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder values(List<String> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public Builder arrayTypeName(String arrayTypeName) {
            this.arrayTypeName = arrayTypeName;
            this.__explicitlySet__.add("arrayTypeName");
            return this;
        }

        public JobInBind build() {
            JobInBind model = new JobInBind(this.position, this.dataType, this.values, this.arrayTypeName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobInBind model) {
            if (model.wasPropertyExplicitlySet("position")) {
                this.position(model.getPosition());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("values")) {
                this.values(model.getValues());
            }
            if (model.wasPropertyExplicitlySet("arrayTypeName")) {
                this.arrayTypeName(model.getArrayTypeName());
            }
            return this;
        }
    }
}

